/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.publish;

import caseapp.core.RemainingArgs;
import caseapp.core.app.CaseApp;
import cats.data.NonEmptyList;
import coursier.cache.internal.ThreadUtil$;
import coursier.cli.publish.Hooks;
import coursier.cli.publish.Input$;
import coursier.cli.publish.PublishError;
import coursier.cli.publish.PublishTasks$;
import coursier.cli.publish.options.PublishOptions;
import coursier.cli.publish.options.PublishOptions$;
import coursier.cli.publish.params.PublishParams;
import coursier.cli.publish.params.PublishParams$;
import coursier.cli.publish.util.DeleteOnExit;
import coursier.cli.publish.util.Git$;
import coursier.cli.util.Guard$;
import coursier.maven.MavenRepository;
import coursier.publish.Content;
import coursier.publish.checksum.ChecksumType;
import coursier.publish.checksum.ChecksumType$;
import coursier.publish.checksum.Checksums$;
import coursier.publish.download.Download;
import coursier.publish.download.FileDownload;
import coursier.publish.download.OkhttpDownload$;
import coursier.publish.fileset.FileSet;
import coursier.publish.fileset.FileSet$;
import coursier.publish.fileset.Group;
import coursier.publish.fileset.Group$;
import coursier.publish.upload.DummyUpload;
import coursier.publish.upload.FileUpload;
import coursier.publish.upload.HttpURLConnectionUpload$;
import coursier.publish.upload.OkhttpUpload$;
import coursier.publish.upload.Upload;
import coursier.util.Sync$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Publish$
extends CaseApp<PublishOptions> {
    public static Publish$ MODULE$;
    private final Seq<ChecksumType> defaultChecksums;

    static {
        new Publish$();
    }

    public Seq<ChecksumType> defaultChecksums() {
        return this.defaultChecksums;
    }

    private Tuple4<Upload, Download, MavenRepository, Object> repoParams(MavenRepository repo, boolean parallel, boolean dummyUpload, String urlSuffix) {
        Tuple4 tuple4;
        if (!repo.root().contains("://") && new StringOps(Predef$.MODULE$.augmentString(repo.root())).contains((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar))) {
            Path p = Paths.get(repo.root(), new String[0]).toAbsolutePath();
            tuple4 = new Tuple4((Object)new FileUpload(p), (Object)new FileDownload(p), (Object)repo.withRoot("."), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (repo.root().startsWith("file:")) {
            Path p = Paths.get(new URI(repo.root())).toAbsolutePath();
            tuple4 = new Tuple4((Object)new FileUpload(p), (Object)new FileDownload(p), (Object)repo.withRoot("."), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (repo.root().startsWith("http://") || repo.root().startsWith("https://")) {
            ExecutorService pool = Sync$.MODULE$.fixedThreadPool(parallel ? 4 : 1);
            Upload upload = parallel ? OkhttpUpload$.MODULE$.create(pool, true, urlSuffix) : HttpURLConnectionUpload$.MODULE$.create(pool, urlSuffix);
            tuple4 = new Tuple4((Object)upload, (Object)OkhttpDownload$.MODULE$.create(pool), (Object)repo, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new PublishError.UnrecognizedRepositoryFormat(repo.root());
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        Upload upload = (Upload)tuple42._1();
        Download download = (Download)tuple42._2();
        MavenRepository repo0 = (MavenRepository)tuple42._3();
        boolean isLocal = BoxesRunTime.unboxToBoolean((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)upload, (Object)download, (Object)repo0, (Object)BoxesRunTime.boxToBoolean((boolean)isLocal));
        Tuple4 tuple44 = tuple43;
        Upload upload2 = (Upload)tuple44._1();
        Download download2 = (Download)tuple44._2();
        MavenRepository repo02 = (MavenRepository)tuple44._3();
        boolean isLocal2 = BoxesRunTime.unboxToBoolean((Object)tuple44._4());
        Upload actualUpload = dummyUpload ? new DummyUpload(upload2) : upload2;
        return new Tuple4((Object)actualUpload, (Object)download2, (Object)repo02, (Object)BoxesRunTime.boxToBoolean((boolean)isLocal2));
    }

    private boolean repoParams$default$2() {
        return false;
    }

    private boolean repoParams$default$3() {
        return false;
    }

    private String repoParams$default$4() {
        return "";
    }

    private Function1<ExecutionContext, Future<Object>> isSnapshot(FileSet fs) {
        Seq versions = (Seq)Group$.MODULE$.split(fs).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Group, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Group.Module) {
                    Group.Module module = (Group.Module)A1;
                    object = module.version();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Group x1) {
                Group group = x1;
                boolean bl = group instanceof Group.Module;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map snapshotMap = versions.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith("SNAPSHOT")));
        return snapshotMap.size() >= 2 ? Task$.MODULE$.fail((Throwable)new Exception("Cannot push both snapshot and non-snapshot artifacts")) : Task$.MODULE$.point((Object)BoxesRunTime.boxToBoolean((!snapshotMap.contains((Object)BoxesRunTime.boxToBoolean((boolean)false)) ? 1 : 0) != 0));
    }

    public Function1<ExecutionContext, Future<BoxedUnit>> publish(PublishParams params, PrintStream out, ScheduledExecutorService es) {
        DeleteOnExit deleteOnExit = new DeleteOnExit(params.verbosity());
        Instant now = Instant.now();
        params.maybeWarnSigner(out);
        Hooks hooks = params.hooks(out, es);
        return Task$.MODULE$.flatMap$extension(params.initSigner(), (Function1 & Serializable & scala.Serializable)_ -> new Task(Task$.MODULE$.flatMap$extension(Input$.MODULE$.manualPackageFileSetOpt(params, now), (Function1 & Serializable & scala.Serializable)manualPackageFileSetOpt -> new Task(Task$.MODULE$.flatMap$extension(Input$.MODULE$.dirFileSet(params$1, out$1), (Function1 & Serializable & scala.Serializable)dirFileSet0 -> new Task(Task$.MODULE$.flatMap$extension(Task$.MODULE$.map$extension(Input$.MODULE$.sbtFileSet(params$1, now$1, out$1, deleteOnExit$1, manualPackageFileSetOpt.isEmpty(), es$1), (Function1 & Serializable & scala.Serializable)sbtFileSet0 -> {
            BoxedUnit boxedUnit;
            FileSet fileSet0 = (FileSet)((TraversableOnce)Option$.MODULE$.option2Iterable(manualPackageFileSetOpt$1).toSeq().$plus$plus((GenTraversableOnce)new .colon.colon((Object)dirFileSet0, (List)new .colon.colon(sbtFileSet0, (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)FileSet$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$plus$plus(x$4));
            if (params$1.verbosity() >= 2) {
                System.err.println(new StringBuilder(28).append("Initial file set (").append(fileSet0.elements().length()).append(" elements)").toString());
                fileSet0.elements().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Publish$.$anonfun$publish$6(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    Publish$.$anonfun$publish$7(x$5);
                    return BoxedUnit.UNIT;
                });
                System.err.println();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$13 = boxedUnit;
            return new Tuple3(sbtFileSet0, (Object)fileSet0, (Object)x$13);
        }), (Function1 & Serializable & scala.Serializable)x$22 -> new Task(Publish$.$anonfun$publish$8(params$1, now$1, out$1, hooks$1, x$22)))))))));
    }

    public void run(PublishOptions options, RemainingArgs args) {
        block12: {
            Either either;
            block11: {
                Throwable err2;
                PublishParams p;
                Guard$.MODULE$.apply();
                Either either2 = PublishParams$.MODULE$.apply(options, (Seq<String>)args.all()).toEither();
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    NonEmptyList errors = (NonEmptyList)left.value();
                    errors.toList().foreach((Function1 & Serializable & scala.Serializable)err -> {
                        System.err.println(err);
                        return BoxedUnit.UNIT;
                    });
                    throw package$.MODULE$.exit(1);
                }
                if (!(either2 instanceof Right)) {
                    throw new MatchError((Object)either2);
                }
                Right right = (Right)either2;
                PublishParams publishParams = p = (PublishParams)right.value();
                PublishParams params = publishParams;
                ScheduledExecutorService es = ThreadUtil$.MODULE$.fixedScheduledThreadPool(params.cache().parallel());
                ExecutionContextExecutorService ec = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)es);
                Function1<ExecutionContext, Future<BoxedUnit>> task2 = this.publish(params, System.err, es);
                Future f = Task$.MODULE$.future$extension(Task$.MODULE$.attempt$extension(task2), (ExecutionContext)ec);
                Either res = (Either)Await$.MODULE$.result((Awaitable)f, (Duration)Duration$.MODULE$.Inf());
                boolean bl = false;
                Left left = null;
                either = res;
                if (either instanceof Left) {
                    bl = true;
                    left = (Left)either;
                    Throwable err3 = (Throwable)left.value();
                    if (err3 instanceof PublishError) {
                        PublishError publishError = (PublishError)err3;
                        if (params.verbosity() <= 1) {
                            System.err.println(publishError.message());
                            throw package$.MODULE$.exit(1);
                        }
                    }
                }
                if (bl && (err2 = (Throwable)left.value()) instanceof Upload.Error) {
                    Upload.Error error = (Upload.Error)err2;
                    if (params.verbosity() <= 1) {
                        System.err.println(error.getMessage());
                        throw package$.MODULE$.exit(1);
                    }
                }
                if (bl) {
                    Throwable e = (Throwable)left.value();
                    throw e;
                }
                if (!(either instanceof Right)) break block11;
                Right right2 = (Right)either;
                BoxedUnit boxedUnit = (BoxedUnit)right2.value();
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = boxedUnit;
                if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null)) break block12;
            }
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$publish$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$publish$7(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        coursier.publish.fileset.Path p = (coursier.publish.fileset.Path)tuple2._1();
        System.err.println(new StringBuilder(2).append("  ").append(p.repr()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$publish$15(char x$7) {
        return x$7 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$publish$16(char x$8) {
        return x$8 != '/';
    }

    public static final /* synthetic */ Tuple2 $anonfun$publish$18(PublishParams params$1, boolean isSnapshot0) {
        Tuple4<Upload, Download, MavenRepository, Object> tuple4 = MODULE$.repoParams(params$1.repository().repository().readRepo(isSnapshot0), MODULE$.repoParams$default$2(), MODULE$.repoParams$default$3(), MODULE$.repoParams$default$4());
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Download readDownload = (Download)tuple4._2();
        MavenRepository readRepo = (MavenRepository)tuple4._3();
        Tuple3 tuple3 = new Tuple3(tuple4, (Object)readDownload, (Object)readRepo);
        Tuple3 tuple32 = tuple3;
        Tuple4 x$14 = (Tuple4)tuple32._1();
        Download download = (Download)tuple32._2();
        MavenRepository mavenRepository = (MavenRepository)tuple32._3();
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isSnapshot0), (Object)x$14);
    }

    public static final /* synthetic */ Function1 $anonfun$publish$25(FileSet fileSet1$1, Either x0$2) {
        Function1 function1;
        Left left;
        Tuple3 tuple3;
        Either either = x0$2;
        if (either instanceof Left && (tuple3 = (Tuple3)(left = (Left)either).value()) != null) {
            coursier.publish.fileset.Path path = (coursier.publish.fileset.Path)tuple3._1();
            String msg = (String)tuple3._3();
            function1 = Task$.MODULE$.fail((Throwable)new Exception(new StringBuilder(17).append("Failed to sign ").append(path).append(": ").append(msg).toString()));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            FileSet fs = (FileSet)right.value();
            function1 = Task$.MODULE$.point((Object)fileSet1$1.$plus$plus(fs));
        } else {
            throw new MatchError((Object)either);
        }
        return function1;
    }

    public static final /* synthetic */ boolean $anonfun$publish$32(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$publish$33(Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        coursier.publish.fileset.Path f = (coursier.publish.fileset.Path)tuple2._1();
        System.err.println(new StringBuilder(2).append("  ").append(f.repr()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$publish$44(MavenRepository actualReadRepo$1, PrintStream out$1, Group.Module m) {
        String base = new StringBuilder(0).append(actualReadRepo$1.root()).append(((TraversableOnce)m.baseDir().map((Function1 & Serializable & scala.Serializable)x$12 -> new StringBuilder(1).append("/").append((String)x$12).toString(), Seq$.MODULE$.canBuildFrom())).mkString()).toString();
        out$1.println(new StringBuilder(2).append("  ").append(base).toString());
    }

    public static final /* synthetic */ void $anonfun$publish$42(PublishParams params$1, boolean isSnapshot0$1, FileSet sortedFinalFileSet$1, PrintStream out$1, BoxedUnit _) {
        block0: {
            if (params$1.verbosity() < 0) break block0;
            MavenRepository actualReadRepo = params$1.repository().repository().checkResultsRepo(isSnapshot0$1);
            Seq modules = (Seq)((SeqLike)Group$.MODULE$.split(sortedFinalFileSet$1).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Group, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Group.Module module;
                    A1 A1 = x1;
                    Object object = A1 instanceof Group.Module ? (module = (Group.Module)A1) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Group x1) {
                    Group group = x1;
                    boolean bl = group instanceof Group.Module;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)m -> new Tuple3((Object)m.organization(), (Object)m.name(), (Object)m.version()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
            out$1.println("\n \ud83d\udc40 Check results at");
            modules.foreach((Function1 & Serializable & scala.Serializable)m -> {
                Publish$.$anonfun$publish$44(actualReadRepo, out$1, m);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ Function1 $anonfun$publish$39(FileSet sortedFinalFileSet$1, PublishParams params$1, PrintStream out$1, Hooks hooks$1, boolean isSnapshot0$1, Tuple5 x$19) {
        Tuple4 tuple4;
        boolean parallel;
        Object hooksData;
        block3: {
            Tuple5 tuple5;
            block2: {
                tuple5 = x$19;
                if (tuple5 == null) break block2;
                hooksData = tuple5._1();
                parallel = BoxesRunTime.unboxToBoolean((Object)tuple5._3());
                tuple4 = (Tuple4)tuple5._5();
                if (tuple4 != null) break block3;
            }
            throw new MatchError((Object)tuple5);
        }
        Upload upload = (Upload)tuple4._1();
        MavenRepository repo = (MavenRepository)tuple4._3();
        boolean isLocal = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
        Function1 function1 = Task$.MODULE$.flatMap$extension(upload.uploadFileSet(repo, sortedFinalFileSet$1, params$1.uploadLogger(out$1, isLocal), parallel), (Function1 & Serializable & scala.Serializable)res -> new Task(Task$.MODULE$.flatMap$extension(res.isEmpty() ? Task$.MODULE$.point((Object)BoxedUnit.UNIT) : Task$.MODULE$.fail((Throwable)new PublishError.UploadingError(repo, (Seq<Tuple3<coursier.publish.fileset.Path, Content, Upload.Error>>)res)), (Function1 & Serializable & scala.Serializable)_ -> new Task(Task$.MODULE$.map$extension(hooks$1.afterUpload(hooksData$1), (Function1 & Serializable & scala.Serializable)_ -> {
            Publish$.$anonfun$publish$42(params$1, isSnapshot0$1, sortedFinalFileSet$1, out$1, _);
            return BoxedUnit.UNIT;
        })))));
        return function1;
    }

    public static final /* synthetic */ Function1 $anonfun$publish$34(Hooks hooks$1, boolean isSnapshot0$1, PublishParams params$1, PrintStream out$1, Tuple2 x$20) {
        Tuple2 tuple2 = x$20;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileSet sortedFinalFileSet = (FileSet)tuple2._1();
        Function1 function1 = Task$.MODULE$.flatMap$extension(Task$.MODULE$.map$extension(hooks$1.beforeUpload(sortedFinalFileSet, isSnapshot0$1), (Function1 & Serializable & scala.Serializable)hooksData -> {
            MavenRepository retainedRepo = (MavenRepository)hooks$1.repository(hooksData, params$1.repository().repository(), isSnapshot0$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> params$1.repository().repository().repo(isSnapshot0$1));
            boolean parallel = BoxesRunTime.unboxToBoolean((Object)params$1.parallel().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !params$1.repository().gitHub()));
            String urlSuffix = (String)params$1.urlSuffixOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> params$1.repository().bintray() ? ";publish=1" : "");
            Tuple4<Upload, Download, MavenRepository, Object> tuple4 = MODULE$.repoParams(retainedRepo, parallel, params$1.dummy(), urlSuffix);
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            Upload upload = (Upload)tuple4._1();
            MavenRepository repo = (MavenRepository)tuple4._3();
            boolean isLocal = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Tuple4 tuple42 = new Tuple4(tuple4, (Object)upload, (Object)repo, (Object)BoxesRunTime.boxToBoolean((boolean)isLocal));
            Tuple4 tuple43 = tuple42;
            Tuple4 x$17 = (Tuple4)tuple43._1();
            Upload upload2 = (Upload)tuple43._2();
            MavenRepository mavenRepository = (MavenRepository)tuple43._3();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
            return new Tuple5(hooksData, (Object)retainedRepo, (Object)BoxesRunTime.boxToBoolean((boolean)parallel), (Object)urlSuffix, (Object)x$17);
        }), (Function1 & Serializable & scala.Serializable)x$19 -> new Task(Publish$.$anonfun$publish$39(sortedFinalFileSet, params$1, out$1, hooks$1, isSnapshot0$1, x$19)));
        return function1;
    }

    public static final /* synthetic */ Function1 $anonfun$publish$26(PublishParams params$1, Instant now$1, PrintStream out$1, Hooks hooks$1, boolean isSnapshot0$1, FileSet withSignatures) {
        Seq checksums = (Seq)params$1.checksum().checksumsOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> params$1.repository().gitHub() || params$1.repository().bintray() ? Nil$.MODULE$ : MODULE$.defaultChecksums());
        return Task$.MODULE$.flatMap$extension(checksums.isEmpty() ? Task$.MODULE$.point((Object)Checksums$.MODULE$.clear(ChecksumType$.MODULE$.all(), withSignatures)) : Task$.MODULE$.map$extension(Checksums$.MODULE$.apply(checksums, withSignatures, now$1, (Function0 & Serializable & scala.Serializable)() -> params$1.checksumLogger(out$1)), (Function1 & Serializable & scala.Serializable)x$10 -> withSignatures.$plus$plus(x$10)), (Function1 & Serializable & scala.Serializable)finalFileSet -> new Task(Task$.MODULE$.flatMap$extension(Task$.MODULE$.map$extension(finalFileSet.order(), (Function1 & Serializable & scala.Serializable)sortedFinalFileSet -> {
            BoxedUnit boxedUnit;
            if (params$1.verbosity() >= 2) {
                System.err.println(new StringBuilder(28).append("Writing / pushing ").append(sortedFinalFileSet.elements().length()).append(" elements:").toString());
                sortedFinalFileSet.elements().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Publish$.$anonfun$publish$32(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                    Publish$.$anonfun$publish$33(x$11);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$16 = boxedUnit;
            return new Tuple2(sortedFinalFileSet, (Object)x$16);
        }), (Function1 & Serializable & scala.Serializable)x$20 -> new Task(Publish$.$anonfun$publish$34(hooks$1, isSnapshot0$1, params$1, out$1, x$20)))));
    }

    public static final /* synthetic */ Function1 $anonfun$publish$19(PublishParams params$1, FileSet updateFileSet0$1, Instant now$1, PrintStream out$1, Hooks hooks$1, Tuple2 x$21) {
        Tuple4 tuple4;
        boolean isSnapshot0;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$21;
                if (tuple2 == null) break block2;
                isSnapshot0 = tuple2._1$mcZ$sp();
                tuple4 = (Tuple4)tuple2._2();
                if (tuple4 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        Download readDownload = (Download)tuple4._2();
        MavenRepository readRepo = (MavenRepository)tuple4._3();
        Function1 function1 = Task$.MODULE$.flatMap$extension(BoxesRunTime.unboxToBoolean((Object)params$1.metadata().mavenMetadata().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !params$1.repository().gitHub())) ? PublishTasks$.MODULE$.updateMavenMetadata(updateFileSet0$1, now$1, readDownload, readRepo, params$1.downloadLogger(out$1), params$1.repository().snapshotVersioning()) : Task$.MODULE$.point((Object)PublishTasks$.MODULE$.clearMavenMetadata(updateFileSet0$1)), (Function1 & Serializable & scala.Serializable)fileSet1 -> new Task(Task$.MODULE$.flatMap$extension(params$1.initSigner(), (Function1 & Serializable & scala.Serializable)_ -> new Task(Task$.MODULE$.flatMap$extension(Task$.MODULE$.flatMap$extension(params$1.signer().signatures(fileSet1, now$1, ((TraversableOnce)ChecksumType$.MODULE$.all().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.extension(), Seq$.MODULE$.canBuildFrom())).toSet(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maven-metadata.xml"})), (Function0 & Serializable & scala.Serializable)() -> params$1.signerLogger(out$1)), (Function1 & Serializable & scala.Serializable)x0$2 -> new Task(Publish$.$anonfun$publish$25(fileSet1$1, x0$2))), (Function1 & Serializable & scala.Serializable)withSignatures -> new Task(Publish$.$anonfun$publish$26(params$1, now$1, out$1, hooks$1, isSnapshot0$1, withSignatures)))))));
        return function1;
    }

    public static final /* synthetic */ Function1 $anonfun$publish$9(PublishParams params$1, FileSet fileSet0$1, Instant now$1, PrintStream out$1, Hooks hooks$1, BoxedUnit _) {
        File dir = (File)params$1.directory().directories().headOption().orElse((Function0 & Serializable & scala.Serializable)() -> params$1.directory().sbtDirectories().headOption()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toFile()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new File("."));
        Option<Tuple2<String, String>> scmDomainPath = BoxesRunTime.unboxToBoolean((Object)params$1.metadata().git().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> params$1.repository().gitHub())) ? Git$.MODULE$.apply(dir) : None$.MODULE$;
        None$ distMgmtRepo = params$1.repository().gitHub() ? scmDomainPath.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return None$.MODULE$;
            String string = (String)tuple2._1();
            String path = (String)tuple2._2();
            if (!"github.com".equals(string)) return None$.MODULE$;
            if (new StringOps(Predef$.MODULE$.augmentString(path)).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Publish$.$anonfun$publish$15(BoxesRunTime.unboxToChar((Object)x$7)))) != 1) return None$.MODULE$;
            String owner = (String)new StringOps(Predef$.MODULE$.augmentString(path)).takeWhile((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Publish$.$anonfun$publish$16(BoxesRunTime.unboxToChar((Object)x$8))));
            return new Some((Object)new Tuple3((Object)"github", (Object)owner, (Object)new StringBuilder(29).append("https://maven.pkg.github.com/").append(path).toString()));
        }) : None$.MODULE$;
        return Task$.MODULE$.flatMap$extension(fileSet0$1.updateMetadata(params$1.metadata().organization(), params$1.metadata().name(), params$1.metadata().version(), params$1.metadata().licenses(), params$1.metadata().developersOpt(), params$1.metadata().homePage(), scmDomainPath, (Option)distMgmtRepo, now$1), (Function1 & Serializable & scala.Serializable)updateFileSet0 -> new Task(Task$.MODULE$.flatMap$extension(Task$.MODULE$.map$extension(Publish$.MODULE$.isSnapshot(updateFileSet0), (Function1 & Serializable & scala.Serializable)isSnapshot0 -> Publish$.$anonfun$publish$18(params$1, BoxesRunTime.unboxToBoolean((Object)isSnapshot0))), (Function1 & Serializable & scala.Serializable)x$21 -> new Task(Publish$.$anonfun$publish$19(params$1, updateFileSet0, now$1, out$1, hooks$1, x$21)))));
    }

    public static final /* synthetic */ Function1 $anonfun$publish$8(PublishParams params$1, Instant now$1, PrintStream out$1, Hooks hooks$1, Tuple3 x$22) {
        Tuple3 tuple3 = x$22;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        FileSet fileSet0 = (FileSet)tuple3._2();
        Function1 function1 = Task$.MODULE$.flatMap$extension(fileSet0.isEmpty() ? Task$.MODULE$.fail((Throwable)new PublishError.NoInput()) : Task$.MODULE$.point((Object)BoxedUnit.UNIT), (Function1 & Serializable & scala.Serializable)_ -> new Task(Publish$.$anonfun$publish$9(params$1, fileSet0, now$1, out$1, hooks$1, _)));
        return function1;
    }

    private Publish$() {
        super(PublishOptions$.MODULE$.parser(), PublishOptions$.MODULE$.help());
        MODULE$ = this;
        this.defaultChecksums = (Seq)new .colon.colon((Object)ChecksumType.MD5$.MODULE$, (List)new .colon.colon((Object)ChecksumType.SHA1$.MODULE$, (List)Nil$.MODULE$));
    }
}

