/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.publish.params;

import cats.data.NonEmptyList;
import cats.data.Validated;
import coursier.cli.params.CacheParams;
import coursier.cli.publish.Hooks;
import coursier.cli.publish.Hooks$;
import coursier.cli.publish.PublishRepository;
import coursier.cli.publish.conf.Conf;
import coursier.cli.publish.options.PublishOptions;
import coursier.cli.publish.params.ChecksumParams;
import coursier.cli.publish.params.DirectoryParams;
import coursier.cli.publish.params.MetadataParams;
import coursier.cli.publish.params.PublishParams$;
import coursier.cli.publish.params.RepositoryParams;
import coursier.cli.publish.params.SignatureParams;
import coursier.cli.publish.params.SinglePackageParams;
import coursier.core.ModuleName;
import coursier.core.Organization;
import coursier.publish.Content;
import coursier.publish.Pom;
import coursier.publish.bintray.BintrayApi;
import coursier.publish.checksum.logger.BatchChecksumLogger;
import coursier.publish.checksum.logger.ChecksumLogger;
import coursier.publish.checksum.logger.InteractiveChecksumLogger$;
import coursier.publish.download.logger.DownloadLogger;
import coursier.publish.download.logger.SimpleDownloadLogger;
import coursier.publish.signing.GpgSigner;
import coursier.publish.signing.GpgSigner$;
import coursier.publish.signing.NopSigner$;
import coursier.publish.signing.Signer;
import coursier.publish.signing.logger.BatchSignerLogger;
import coursier.publish.signing.logger.InteractiveSignerLogger$;
import coursier.publish.signing.logger.SignerLogger;
import coursier.publish.sonatype.SonatypeApi;
import coursier.publish.sonatype.SonatypeApi$;
import coursier.publish.upload.logger.BatchUploadLogger;
import coursier.publish.upload.logger.InteractiveUploadLogger$;
import coursier.publish.upload.logger.UploadLogger;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple13;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\rue\u0001\u0002#F\u0005:C\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\tC\u0002\u0011\t\u0012)A\u0005;\"A!\r\u0001BK\u0002\u0013\u00051\r\u0003\u0005h\u0001\tE\t\u0015!\u0003e\u0011!A\u0007A!f\u0001\n\u0003I\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011\u00026\t\u00119\u0004!Q3A\u0005\u0002=D\u0001b\u001d\u0001\u0003\u0012\u0003\u0006I\u0001\u001d\u0005\ti\u0002\u0011)\u001a!C\u0001k\"A\u0011\u0010\u0001B\tB\u0003%a\u000f\u0003\u0005{\u0001\tU\r\u0011\"\u0001|\u0011!y\bA!E!\u0002\u0013a\bBCA\u0001\u0001\tU\r\u0011\"\u0001\u0002\u0004!Q\u0011q\u0002\u0001\u0003\u0012\u0003\u0006I!!\u0002\t\u0015\u0005E\u0001A!f\u0001\n\u0003\t\u0019\u0002\u0003\u0006\u0002\u001c\u0001\u0011\t\u0012)A\u0005\u0003+A!\"!\b\u0001\u0005+\u0007I\u0011AA\u0010\u0011)\t9\u0003\u0001B\tB\u0003%\u0011\u0011\u0005\u0005\u000b\u0003S\u0001!Q3A\u0005\u0002\u0005}\u0001BCA\u0016\u0001\tE\t\u0015!\u0003\u0002\"!Q\u0011Q\u0006\u0001\u0003\u0016\u0004%\t!a\f\t\u0015\u0005]\u0002A!E!\u0002\u0013\t\t\u0004\u0003\u0006\u0002:\u0001\u0011)\u001a!C\u0001\u0003wA!\"a\u0010\u0001\u0005#\u0005\u000b\u0011BA\u001f\u0011)\t\t\u0005\u0001BK\u0002\u0013\u0005\u00111\t\u0005\u000b\u0003;\u0002!\u0011#Q\u0001\n\u0005\u0015\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\t\t\n\u0001C\u0001\u0003'C\u0011\"!-\u0001#\u0003%\t!a-\t\u0015\u0005%\u0007\u0001#b\u0001\n\u0003\tY\rC\u0004\u0002\\\u0002!\t!!8\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0001b\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u001bBqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0005\u0003v\u0001\t\t\u0011\"\u0001\u0003x!I!1\u0013\u0001\u0012\u0002\u0013\u0005!Q\u0013\u0005\n\u00053\u0003\u0011\u0013!C\u0001\u00057C\u0011Ba(\u0001#\u0003%\tA!)\t\u0013\t\u0015\u0006!%A\u0005\u0002\t\u001d\u0006\"\u0003BV\u0001E\u0005I\u0011\u0001BW\u0011%\u0011\t\fAI\u0001\n\u0003\u0011\u0019\fC\u0005\u00038\u0002\t\n\u0011\"\u0001\u0003:\"I!Q\u0018\u0001\u0012\u0002\u0013\u0005!q\u0018\u0005\n\u0005\u0007\u0004\u0011\u0013!C\u0001\u0005\u000bD\u0011B!3\u0001#\u0003%\tA!2\t\u0013\t-\u0007!%A\u0005\u0002\t5\u0007\"\u0003Bi\u0001E\u0005I\u0011\u0001Bj\u0011%\u00119\u000eAI\u0001\n\u0003\t\u0019\fC\u0005\u0003Z\u0002\t\t\u0011\"\u0011\u0003\\\"I!q\u001d\u0001\u0002\u0002\u0013\u0005\u00111\u0003\u0005\n\u0005S\u0004\u0011\u0011!C\u0001\u0005WD\u0011Ba>\u0001\u0003\u0003%\tE!?\t\u0013\r\u001d\u0001!!A\u0005\u0002\r%\u0001\"CB\u0007\u0001\u0005\u0005I\u0011IB\b\u0011%\u0019\t\u0002AA\u0001\n\u0003\u001a\u0019\u0002C\u0005\u0004\u0016\u0001\t\t\u0011\"\u0011\u0004\u0018\u001d911D#\t\u0002\ruaA\u0002#F\u0011\u0003\u0019y\u0002C\u0004\u0002`y\"\ta!\t\t\u000f\r\rb\b\"\u0001\u0004&!I11\u0005 \u0002\u0002\u0013\u00055q\r\u0005\n\u0007\u0007s\u0014\u0011!CA\u0007\u000bC\u0011ba%?\u0003\u0003%Ia!&\u0003\u001bA+(\r\\5tQB\u000b'/Y7t\u0015\t1u)\u0001\u0004qCJ\fWn\u001d\u0006\u0003\u0011&\u000bq\u0001];cY&\u001c\bN\u0003\u0002K\u0017\u0006\u00191\r\\5\u000b\u00031\u000b\u0001bY8veNLWM]\u0002\u0001'\u0011\u0001q*\u0016-\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\r\u0005s\u0017PU3g!\t\u0001f+\u0003\u0002X#\n9\u0001K]8ek\u000e$\bC\u0001)Z\u0013\tQ\u0016K\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006sKB|7/\u001b;pef,\u0012!\u0018\t\u0003=~k\u0011!R\u0005\u0003A\u0016\u0013\u0001CU3q_NLGo\u001c:z!\u0006\u0014\u0018-\\:\u0002\u0017I,\u0007o\\:ji>\u0014\u0018\u0010I\u0001\t[\u0016$\u0018\rZ1uCV\tA\r\u0005\u0002_K&\u0011a-\u0012\u0002\u000f\u001b\u0016$\u0018\rZ1uCB\u000b'/Y7t\u0003%iW\r^1eCR\f\u0007%A\u0007tS:<G.\u001a)bG.\fw-Z\u000b\u0002UB\u0011al[\u0005\u0003Y\u0016\u00131cU5oO2,\u0007+Y2lC\u001e,\u0007+\u0019:b[N\fab]5oO2,\u0007+Y2lC\u001e,\u0007%A\u0005eSJ,7\r^8ssV\t\u0001\u000f\u0005\u0002_c&\u0011!/\u0012\u0002\u0010\t&\u0014Xm\u0019;pef\u0004\u0016M]1ng\u0006QA-\u001b:fGR|'/\u001f\u0011\u0002\u0011\rDWmY6tk6,\u0012A\u001e\t\u0003=^L!\u0001_#\u0003\u001d\rCWmY6tk6\u0004\u0016M]1ng\u0006I1\r[3dWN,X\u000eI\u0001\ng&<g.\u0019;ve\u0016,\u0012\u0001 \t\u0003=vL!A`#\u0003\u001fMKwM\\1ukJ,\u0007+\u0019:b[N\f!b]5h]\u0006$XO]3!\u0003\u0015\u0019\u0017m\u00195f+\t\t)\u0001\u0005\u0003\u0002\b\u0005-QBAA\u0005\u0015\t1\u0015*\u0003\u0003\u0002\u000e\u0005%!aC\"bG\",\u0007+\u0019:b[N\faaY1dQ\u0016\u0004\u0013!\u0003<fe\n|7/\u001b;z+\t\t)\u0002E\u0002Q\u0003/I1!!\u0007R\u0005\rIe\u000e^\u0001\u000bm\u0016\u0014(m\\:jif\u0004\u0013!\u00023v[6LXCAA\u0011!\r\u0001\u00161E\u0005\u0004\u0003K\t&a\u0002\"p_2,\u0017M\\\u0001\u0007IVlW.\u001f\u0011\u0002\u000b\t\fGo\u00195\u0002\r\t\fGo\u00195!\u00039\u0019(\r^(viB,HO\u0012:b[\u0016,\"!!\r\u0011\u000bA\u000b\u0019$!\u0006\n\u0007\u0005U\u0012K\u0001\u0004PaRLwN\\\u0001\u0010g\n$x*\u001e;qkR4%/Y7fA\u0005A\u0001/\u0019:bY2,G.\u0006\u0002\u0002>A)\u0001+a\r\u0002\"\u0005I\u0001/\u0019:bY2,G\u000eI\u0001\rkJd7+\u001e4gSb|\u0005\u000f^\u000b\u0003\u0003\u000b\u0002R\u0001UA\u001a\u0003\u000f\u0002B!!\u0013\u0002X9!\u00111JA*!\r\ti%U\u0007\u0003\u0003\u001fR1!!\u0015N\u0003\u0019a$o\\8u}%\u0019\u0011QK)\u0002\rA\u0013X\rZ3g\u0013\u0011\tI&a\u0017\u0003\rM#(/\u001b8h\u0015\r\t)&U\u0001\u000ekJd7+\u001e4gSb|\u0005\u000f\u001e\u0011\u0002\rqJg.\u001b;?)q\t\u0019'!\u001a\u0002h\u0005%\u00141NA7\u0003_\n\t(a\u001d\u0002v\u0005]\u0014\u0011PA>\u0003{\u0002\"A\u0018\u0001\t\u000bm[\u0002\u0019A/\t\u000b\t\\\u0002\u0019\u00013\t\u000b!\\\u0002\u0019\u00016\t\u000b9\\\u0002\u0019\u00019\t\u000bQ\\\u0002\u0019\u0001<\t\u000bi\\\u0002\u0019\u0001?\t\u000f\u0005\u00051\u00041\u0001\u0002\u0006!9\u0011\u0011C\u000eA\u0002\u0005U\u0001bBA\u000f7\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003SY\u0002\u0019AA\u0011\u0011\u001d\tic\u0007a\u0001\u0003cAq!!\u000f\u001c\u0001\u0004\ti\u0004C\u0004\u0002Bm\u0001\r!!\u0012\u0002\u0011]LG\u000f[\"p]\u001a$B!a\u0019\u0002\u0004\"9\u0011Q\u0011\u000fA\u0002\u0005\u001d\u0015\u0001B2p]\u001a\u0004B!!#\u0002\u000e6\u0011\u00111\u0012\u0006\u0004\u0003\u000b;\u0015\u0002BAH\u0003\u0017\u0013AaQ8oM\u00069A-\u001b:OC6,GCBA$\u0003+\u000bi\u000bC\u0004\u0002\u0018v\u0001\r!!'\u0002\u0007\u0011L'\u000f\u0005\u0003\u0002\u001c\u0006%VBAAO\u0015\u0011\ty*!)\u0002\t\u0019LG.\u001a\u0006\u0005\u0003G\u000b)+A\u0002oS>T!!a*\u0002\t)\fg/Y\u0005\u0005\u0003W\u000biJ\u0001\u0003QCRD\u0007\"CAX;A\u0005\t\u0019AA#\u0003\u0015\u0019\bn\u001c:u\u0003E!\u0017N\u001d(b[\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003kSC!!\u0012\u00028.\u0012\u0011\u0011\u0018\t\u0005\u0003w\u000b)-\u0004\u0002\u0002>*!\u0011qXAa\u0003%)hn\u00195fG.,GMC\u0002\u0002DF\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9-!0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0004tS\u001etWM]\u000b\u0003\u0003\u001b\u0004B!a4\u0002X6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).A\u0004tS\u001et\u0017N\\4\u000b\u0005![\u0015\u0002BAm\u0003#\u0014aaU5h]\u0016\u0014\u0018aD7bs\n,w+\u0019:o'&<g.\u001a:\u0015\t\u0005}\u0017Q\u001d\t\u0004!\u0006\u0005\u0018bAAr#\n!QK\\5u\u0011\u001d\t9\u000f\ta\u0001\u0003S\f1a\\;u!\u0011\tY/!=\u000e\u0005\u00055(\u0002BAx\u0003K\u000b!![8\n\t\u0005M\u0018Q\u001e\u0002\f!JLg\u000e^*ue\u0016\fW.\u0001\u0006j]&$8+[4oKJ,\"!!?\u0011\r\u0005m(\u0011AAp\u001b\t\tiPC\u0002\u0002\u0000.\u000bA!\u001e;jY&!!1AA\u007f\u0005\u0011!\u0016m]6\u0002\u000b!|wn[:\u0015\r\t%!\u0011\u0003B\n!\u0011\u0011YA!\u0004\u000e\u0003\u001dK1Aa\u0004H\u0005\u0015Aun\\6t\u0011\u001d\t9O\ta\u0001\u0003SDqA!\u0006#\u0001\u0004\u00119\"\u0001\u0002fgB!!\u0011\u0004B\u0011\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011AC2p]\u000e,(O]3oi*!\u0011q`AS\u0013\u0011\u0011\u0019Ca\u0007\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-\u0001\be_^tGn\\1e\u0019><w-\u001a:\u0015\t\t%\"\u0011\b\t\u0005\u0005W\u0011)$\u0004\u0002\u0003.)!!q\u0006B\u0019\u0003\u0019awnZ4fe*!!1GAk\u0003!!wn\u001e8m_\u0006$\u0017\u0002\u0002B\u001c\u0005[\u0011a\u0002R8x]2|\u0017\r\u001a'pO\u001e,'\u000fC\u0004\u0002h\u000e\u0002\r!!;\u0002\u0019MLwM\\3s\u0019><w-\u001a:\u0015\t\t}\"\u0011\n\t\u0005\u0005\u0003\u0012)%\u0004\u0002\u0003D)!!qFAi\u0013\u0011\u00119Ea\u0011\u0003\u0019MKwM\\3s\u0019><w-\u001a:\t\u000f\u0005\u001dH\u00051\u0001\u0002j\u0006q1\r[3dWN,X\u000eT8hO\u0016\u0014H\u0003\u0002B(\u00057\u0002BA!\u0015\u0003X5\u0011!1\u000b\u0006\u0005\u0005_\u0011)FC\u0002u\u0003+LAA!\u0017\u0003T\tq1\t[3dWN,X\u000eT8hO\u0016\u0014\bbBAtK\u0001\u0007\u0011\u0011^\u0001\rkBdw.\u00193M_\u001e<WM\u001d\u000b\u0007\u0005C\u0012yG!\u001d\u0011\t\t\r$1N\u0007\u0003\u0005KRAAa\f\u0003h)!!\u0011NAk\u0003\u0019)\b\u000f\\8bI&!!Q\u000eB3\u00051)\u0006\u000f\\8bI2{wmZ3s\u0011\u001d\t9O\na\u0001\u0003SDqAa\u001d'\u0001\u0004\t\t#A\u0004jg2{7-\u00197\u0002\t\r|\u0007/\u001f\u000b\u001d\u0003G\u0012IHa\u001f\u0003~\t}$\u0011\u0011BB\u0005\u000b\u00139I!#\u0003\f\n5%q\u0012BI\u0011\u001dYv\u0005%AA\u0002uCqAY\u0014\u0011\u0002\u0003\u0007A\rC\u0004iOA\u0005\t\u0019\u00016\t\u000f9<\u0003\u0013!a\u0001a\"9Ao\nI\u0001\u0002\u00041\bb\u0002>(!\u0003\u0005\r\u0001 \u0005\n\u0003\u00039\u0003\u0013!a\u0001\u0003\u000bA\u0011\"!\u0005(!\u0003\u0005\r!!\u0006\t\u0013\u0005uq\u0005%AA\u0002\u0005\u0005\u0002\"CA\u0015OA\u0005\t\u0019AA\u0011\u0011%\tic\nI\u0001\u0002\u0004\t\t\u0004C\u0005\u0002:\u001d\u0002\n\u00111\u0001\u0002>!I\u0011\u0011I\u0014\u0011\u0002\u0003\u0007\u0011QI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119JK\u0002^\u0003o\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u001e*\u001aA-a.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0015\u0016\u0004U\u0006]\u0016AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005SS3\u0001]A\\\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"Aa,+\u0007Y\f9,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tU&f\u0001?\u00028\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012:TC\u0001B^U\u0011\t)!a.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!\u0011\u0019\u0016\u0005\u0003+\t9,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t\u001d'\u0006BA\u0011\u0003o\u000bqbY8qs\u0012\"WMZ1vYR$\u0013\u0007M\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132cU\u0011!q\u001a\u0016\u0005\u0003c\t9,A\bd_BLH\u0005Z3gCVdG\u000fJ\u00193+\t\u0011)N\u000b\u0003\u0002>\u0005]\u0016aD2paf$C-\u001a4bk2$H%M\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011i\u000e\u0005\u0003\u0003`\n\u0015XB\u0001Bq\u0015\u0011\u0011\u0019/!*\u0002\t1\fgnZ\u0005\u0005\u00033\u0012\t/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t5(1\u001f\t\u0004!\n=\u0018b\u0001By#\n\u0019\u0011I\\=\t\u0013\tUx'!AA\u0002\u0005U\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003|B1!Q`B\u0002\u0005[l!Aa@\u000b\u0007\r\u0005\u0011+\u0001\u0006d_2dWm\u0019;j_:LAa!\u0002\u0003\u0000\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\tca\u0003\t\u0013\tU\u0018(!AA\u0002\t5\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tu\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002\"\re\u0001\"\u0003B{y\u0005\u0005\t\u0019\u0001Bw\u00035\u0001VO\u00197jg\"\u0004\u0016M]1ngB\u0011aLP\n\u0004}=CFCAB\u000f\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u00199c!\u0012\u0004TAA1\u0011FB \u0003\u000f\n\u0019G\u0004\u0003\u0004,\reb\u0002BB\u0017\u0007gqA!!\u0014\u00040%\u00111\u0011G\u0001\u0005G\u0006$8/\u0003\u0003\u00046\r]\u0012\u0001\u00023bi\u0006T!a!\r\n\t\rm2QH\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\u0019)da\u000e\n\t\r\u000531\t\u0002\r-\u0006d\u0017\u000eZ1uK\u0012tU\r\u001c\u0006\u0005\u0007w\u0019i\u0004C\u0004\u0004H\u0001\u0003\ra!\u0013\u0002\u000f=\u0004H/[8ogB!11JB(\u001b\t\u0019iEC\u0002\u0004H\u001dKAa!\u0015\u0004N\tq\u0001+\u001e2mSNDw\n\u001d;j_:\u001c\bbBB+\u0001\u0002\u00071qK\u0001\u0005CJ<7\u000f\u0005\u0004\u0004Z\r\u0005\u0014q\t\b\u0005\u00077\u001ayF\u0004\u0003\u0002N\ru\u0013\"\u0001*\n\u0007\rm\u0012+\u0003\u0003\u0004d\r\u0015$aA*fc*\u001911H)\u00159\u0005\r4\u0011NB6\u0007[\u001ayg!\u001d\u0004t\rU4qOB=\u0007w\u001aiha \u0004\u0002\")1,\u0011a\u0001;\")!-\u0011a\u0001I\")\u0001.\u0011a\u0001U\")a.\u0011a\u0001a\")A/\u0011a\u0001m\")!0\u0011a\u0001y\"9\u0011\u0011A!A\u0002\u0005\u0015\u0001bBA\t\u0003\u0002\u0007\u0011Q\u0003\u0005\b\u0003;\t\u0005\u0019AA\u0011\u0011\u001d\tI#\u0011a\u0001\u0003CAq!!\fB\u0001\u0004\t\t\u0004C\u0004\u0002:\u0005\u0003\r!!\u0010\t\u000f\u0005\u0005\u0013\t1\u0001\u0002F\u00059QO\\1qa2LH\u0003BBD\u0007\u001f\u0003R\u0001UA\u001a\u0007\u0013\u0003r\u0003UBF;\u0012T\u0007O\u001e?\u0002\u0006\u0005U\u0011\u0011EA\u0011\u0003c\ti$!\u0012\n\u0007\r5\u0015KA\u0004UkBdW-M\u001a\t\u0013\rE%)!AA\u0002\u0005\r\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00199\n\u0005\u0003\u0003`\u000ee\u0015\u0002BBN\u0005C\u0014aa\u00142kK\u000e$\b")
public final class PublishParams
implements Product,
scala.Serializable {
    private Signer signer;
    private final RepositoryParams repository;
    private final MetadataParams metadata;
    private final SinglePackageParams singlePackage;
    private final DirectoryParams directory;
    private final ChecksumParams checksum;
    private final SignatureParams signature;
    private final CacheParams cache;
    private final int verbosity;
    private final boolean dummy;
    private final boolean batch;
    private final Option<Object> sbtOutputFrame;
    private final Option<Object> parallel;
    private final Option<String> urlSuffixOpt;
    private volatile boolean bitmap$0;

    public static Option<Tuple13<RepositoryParams, MetadataParams, SinglePackageParams, DirectoryParams, ChecksumParams, SignatureParams, CacheParams, Object, Object, Object, Option<Object>, Option<Object>, Option<String>>> unapply(PublishParams publishParams) {
        return PublishParams$.MODULE$.unapply(publishParams);
    }

    public static PublishParams apply(RepositoryParams repositoryParams, MetadataParams metadataParams, SinglePackageParams singlePackageParams, DirectoryParams directoryParams, ChecksumParams checksumParams, SignatureParams signatureParams, CacheParams cacheParams, int n, boolean bl, boolean bl2, Option<Object> option, Option<Object> option2, Option<String> option3) {
        return PublishParams$.MODULE$.apply(repositoryParams, metadataParams, singlePackageParams, directoryParams, checksumParams, signatureParams, cacheParams, n, bl, bl2, option, option2, option3);
    }

    public static Validated<NonEmptyList<String>, PublishParams> apply(PublishOptions publishOptions, Seq<String> seq) {
        return PublishParams$.MODULE$.apply(publishOptions, seq);
    }

    public RepositoryParams repository() {
        return this.repository;
    }

    public MetadataParams metadata() {
        return this.metadata;
    }

    public SinglePackageParams singlePackage() {
        return this.singlePackage;
    }

    public DirectoryParams directory() {
        return this.directory;
    }

    public ChecksumParams checksum() {
        return this.checksum;
    }

    public SignatureParams signature() {
        return this.signature;
    }

    public CacheParams cache() {
        return this.cache;
    }

    public int verbosity() {
        return this.verbosity;
    }

    public boolean dummy() {
        return this.dummy;
    }

    public boolean batch() {
        return this.batch;
    }

    public Option<Object> sbtOutputFrame() {
        return this.sbtOutputFrame;
    }

    public Option<Object> parallel() {
        return this.parallel;
    }

    public Option<String> urlSuffixOpt() {
        return this.urlSuffixOpt;
    }

    public PublishParams withConf(Conf conf) {
        ObjectRef p = ObjectRef.create((Object)this);
        conf.organization().organization().withFilter((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)PublishParams.$anonfun$withConf$1(p, ((Organization)o).value()))).foreach((Function1 & Serializable & scala.Serializable)o -> {
            PublishParams.$anonfun$withConf$2(p, ((Organization)o).value());
            return BoxedUnit.UNIT;
        });
        conf.version().withFilter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)PublishParams.$anonfun$withConf$3(p, v))).foreach((Function1 & Serializable & scala.Serializable)v -> {
            PublishParams.$anonfun$withConf$4(p, v);
            return BoxedUnit.UNIT;
        });
        conf.homePage().withFilter((Function1 & Serializable & scala.Serializable)url -> BoxesRunTime.boxToBoolean((boolean)PublishParams.$anonfun$withConf$5(p, url))).foreach((Function1 & Serializable & scala.Serializable)url -> {
            PublishParams.$anonfun$withConf$6(p, url);
            return BoxedUnit.UNIT;
        });
        conf.licenses().withFilter((Function1 & Serializable & scala.Serializable)licenses -> BoxesRunTime.boxToBoolean((boolean)PublishParams.$anonfun$withConf$7(p, licenses))).foreach((Function1 & Serializable & scala.Serializable)licenses -> {
            PublishParams.$anonfun$withConf$8(p, licenses);
            return BoxedUnit.UNIT;
        });
        conf.developers().withFilter((Function1 & Serializable & scala.Serializable)developers -> BoxesRunTime.boxToBoolean((boolean)PublishParams.$anonfun$withConf$9(p, developers))).foreach((Function1 & Serializable & scala.Serializable)developers -> {
            PublishParams.$anonfun$withConf$10(p, developers);
            return BoxedUnit.UNIT;
        });
        return (PublishParams)p.elem;
    }

    public String dirName(Path dir, Option<String> option) {
        return this.verbosity() >= 2 ? ((Object)dir.normalize().toAbsolutePath()).toString() : (String)option.getOrElse((Function0 & Serializable & scala.Serializable)() -> ((Object)dir.getFileName()).toString());
    }

    public Option<String> dirName$default$2() {
        return None$.MODULE$;
    }

    private Signer signer$lzycompute() {
        PublishParams publishParams = this;
        synchronized (publishParams) {
            if (!this.bitmap$0) {
                NopSigner$ nopSigner$;
                if (this.signature().gpg()) {
                    GpgSigner.Key$.Default$ default$;
                    Option<String> option = this.signature().gpgKeyOpt();
                    if (None$.MODULE$.equals(option)) {
                        default$ = GpgSigner.Key$.Default$.MODULE$;
                    } else if (option instanceof Some) {
                        Some some = (Some)option;
                        String id = (String)some.value();
                        default$ = new GpgSigner.Key$.Id(id);
                    } else {
                        throw new MatchError(option);
                    }
                    GpgSigner.Key$.Default$ key = default$;
                    nopSigner$ = new GpgSigner((GpgSigner.Key)key, GpgSigner$.MODULE$.apply$default$2(), GpgSigner$.MODULE$.apply$default$3());
                } else {
                    nopSigner$ = NopSigner$.MODULE$;
                }
                this.signer = nopSigner$;
                this.bitmap$0 = true;
            }
        }
        return this.signer;
    }

    public Signer signer() {
        return !this.bitmap$0 ? this.signer$lzycompute() : this.signer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void maybeWarnSigner(PrintStream out) {
        Tuple2 tuple2 = new Tuple2((Object)this.repository().repository(), (Object)this.signer());
        if (tuple2 != null) {
            Signer signer = (Signer)tuple2._2();
            if (tuple2._1() instanceof PublishRepository.Sonatype && NopSigner$.MODULE$.equals(signer)) {
                out.println("Warning: --sonatype passed, but signing not enabled, trying to proceed anyway");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Function1<ExecutionContext, Future<BoxedUnit>> initSigner() {
        return Task$.MODULE$.flatMap$extension(this.signer().sign((Content)new Content.InMemory(Instant.EPOCH, "hello".getBytes(StandardCharsets.UTF_8))), (Function1 & Serializable & scala.Serializable)x0$1 -> new Task(PublishParams.$anonfun$initSigner$1(x0$1)));
    }

    public Hooks hooks(PrintStream out, ScheduledExecutorService es) {
        Hooks hooks;
        PublishRepository publishRepository = this.repository().repository();
        if (publishRepository instanceof PublishRepository.Sonatype) {
            PublishRepository.Sonatype sonatype = (PublishRepository.Sonatype)publishRepository;
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).build();
            Option authentication = this.repository().repository().snapshotRepo().authentication();
            if (authentication.isEmpty() && this.verbosity() >= 0) {
                out.println("Warning: no Sonatype credentials passed, trying to proceed anyway");
            }
            SonatypeApi api = new SonatypeApi(client, sonatype.restBase(), this.repository().repository().snapshotRepo().authentication(), this.verbosity(), SonatypeApi$.MODULE$.apply$default$5());
            hooks = Hooks$.MODULE$.sonatype(sonatype, api, out, this.verbosity(), this.batch(), es);
        } else if (publishRepository instanceof PublishRepository.Bintray) {
            PublishRepository.Bintray bintray = (PublishRepository.Bintray)publishRepository;
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).build();
            Option authentication = this.repository().repository().snapshotRepo().authentication();
            if (authentication.isEmpty() && this.verbosity() >= 0) {
                out.println("Warning: no Bintray credentials passed, trying to proceed anyway");
            }
            BintrayApi api = new BintrayApi(client, "https://api.bintray.com", (Option)new Some((Object)bintray.authentication()), this.verbosity());
            hooks = Hooks$.MODULE$.bintray(api, bintray.user(), bintray.repository(), bintray.package0(), (Seq<String>)(this.repository().bintrayLicenses().isEmpty() ? (Seq)new .colon.colon((Object)"Apache-2.0", (List)Nil$.MODULE$) : this.repository().bintrayLicenses()), (String)this.repository().bintrayVcsUrlOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("https://bintray.com/").append(bintray.user()).append("/").append(bintray.repository()).append("/").append(bintray.package0()).toString()));
        } else {
            hooks = Hooks$.MODULE$.dummy();
        }
        return hooks;
    }

    public DownloadLogger downloadLogger(PrintStream out) {
        return new SimpleDownloadLogger(out, this.verbosity());
    }

    public SignerLogger signerLogger(PrintStream out) {
        return this.batch() ? new BatchSignerLogger(out, this.verbosity()) : InteractiveSignerLogger$.MODULE$.create((OutputStream)out, this.verbosity());
    }

    public ChecksumLogger checksumLogger(PrintStream out) {
        return this.batch() ? new BatchChecksumLogger(out, this.verbosity()) : InteractiveChecksumLogger$.MODULE$.create((OutputStream)out, this.verbosity());
    }

    public UploadLogger uploadLogger(PrintStream out, boolean isLocal) {
        return this.batch() ? new BatchUploadLogger(out, this.dummy(), isLocal) : InteractiveUploadLogger$.MODULE$.create((OutputStream)out, this.dummy(), isLocal);
    }

    public PublishParams copy(RepositoryParams repository, MetadataParams metadata, SinglePackageParams singlePackage, DirectoryParams directory, ChecksumParams checksum, SignatureParams signature, CacheParams cache, int verbosity, boolean dummy, boolean batch, Option<Object> sbtOutputFrame, Option<Object> parallel, Option<String> urlSuffixOpt) {
        return new PublishParams(repository, metadata, singlePackage, directory, checksum, signature, cache, verbosity, dummy, batch, sbtOutputFrame, parallel, urlSuffixOpt);
    }

    public RepositoryParams copy$default$1() {
        return this.repository();
    }

    public boolean copy$default$10() {
        return this.batch();
    }

    public Option<Object> copy$default$11() {
        return this.sbtOutputFrame();
    }

    public Option<Object> copy$default$12() {
        return this.parallel();
    }

    public Option<String> copy$default$13() {
        return this.urlSuffixOpt();
    }

    public MetadataParams copy$default$2() {
        return this.metadata();
    }

    public SinglePackageParams copy$default$3() {
        return this.singlePackage();
    }

    public DirectoryParams copy$default$4() {
        return this.directory();
    }

    public ChecksumParams copy$default$5() {
        return this.checksum();
    }

    public SignatureParams copy$default$6() {
        return this.signature();
    }

    public CacheParams copy$default$7() {
        return this.cache();
    }

    public int copy$default$8() {
        return this.verbosity();
    }

    public boolean copy$default$9() {
        return this.dummy();
    }

    public String productPrefix() {
        return "PublishParams";
    }

    public int productArity() {
        return 13;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.repository();
                break;
            }
            case 1: {
                object = this.metadata();
                break;
            }
            case 2: {
                object = this.singlePackage();
                break;
            }
            case 3: {
                object = this.directory();
                break;
            }
            case 4: {
                object = this.checksum();
                break;
            }
            case 5: {
                object = this.signature();
                break;
            }
            case 6: {
                object = this.cache();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToInteger((int)this.verbosity());
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean((boolean)this.dummy());
                break;
            }
            case 9: {
                object = BoxesRunTime.boxToBoolean((boolean)this.batch());
                break;
            }
            case 10: {
                object = this.sbtOutputFrame();
                break;
            }
            case 11: {
                object = this.parallel();
                break;
            }
            case 12: {
                object = this.urlSuffixOpt();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PublishParams;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.repository()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.metadata()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.singlePackage()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.directory()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.checksum()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.signature()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cache()));
        n = Statics.mix((int)n, (int)this.verbosity());
        n = Statics.mix((int)n, (int)(this.dummy() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.batch() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.sbtOutputFrame()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.parallel()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.urlSuffixOpt()));
        return Statics.finalizeHash((int)n, (int)13);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PublishParams)) return false;
        boolean bl = true;
        if (!bl) return false;
        PublishParams publishParams = (PublishParams)x$1;
        RepositoryParams repositoryParams = this.repository();
        RepositoryParams repositoryParams2 = publishParams.repository();
        if (repositoryParams == null) {
            if (repositoryParams2 != null) {
                return false;
            }
        } else if (!((Object)repositoryParams).equals(repositoryParams2)) return false;
        MetadataParams metadataParams = this.metadata();
        MetadataParams metadataParams2 = publishParams.metadata();
        if (metadataParams == null) {
            if (metadataParams2 != null) {
                return false;
            }
        } else if (!((Object)metadataParams).equals(metadataParams2)) return false;
        SinglePackageParams singlePackageParams = this.singlePackage();
        SinglePackageParams singlePackageParams2 = publishParams.singlePackage();
        if (singlePackageParams == null) {
            if (singlePackageParams2 != null) {
                return false;
            }
        } else if (!((Object)singlePackageParams).equals(singlePackageParams2)) return false;
        DirectoryParams directoryParams = this.directory();
        DirectoryParams directoryParams2 = publishParams.directory();
        if (directoryParams == null) {
            if (directoryParams2 != null) {
                return false;
            }
        } else if (!((Object)directoryParams).equals(directoryParams2)) return false;
        ChecksumParams checksumParams = this.checksum();
        ChecksumParams checksumParams2 = publishParams.checksum();
        if (checksumParams == null) {
            if (checksumParams2 != null) {
                return false;
            }
        } else if (!((Object)checksumParams).equals(checksumParams2)) return false;
        SignatureParams signatureParams = this.signature();
        SignatureParams signatureParams2 = publishParams.signature();
        if (signatureParams == null) {
            if (signatureParams2 != null) {
                return false;
            }
        } else if (!((Object)signatureParams).equals(signatureParams2)) return false;
        CacheParams cacheParams = this.cache();
        CacheParams cacheParams2 = publishParams.cache();
        if (cacheParams == null) {
            if (cacheParams2 != null) {
                return false;
            }
        } else if (!((Object)cacheParams).equals(cacheParams2)) return false;
        if (this.verbosity() != publishParams.verbosity()) return false;
        if (this.dummy() != publishParams.dummy()) return false;
        if (this.batch() != publishParams.batch()) return false;
        Option<Object> option = this.sbtOutputFrame();
        Option<Object> option2 = publishParams.sbtOutputFrame();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.parallel();
        Option<Object> option4 = publishParams.parallel();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.urlSuffixOpt();
        Option<String> option6 = publishParams.urlSuffixOpt();
        if (option5 == null) {
            if (option6 == null) return true;
            return false;
        } else {
            if (!option5.equals(option6)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$withConf$1(ObjectRef p$1, String o) {
        return ((PublishParams)p$1.elem).metadata().organization().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$withConf$2(ObjectRef p$1, String o) {
        PublishParams qual$1 = (PublishParams)p$1.elem;
        MetadataParams qual$2 = ((PublishParams)p$1.elem).metadata();
        Some x$1 = new Some((Object)new Organization(o));
        Option<ModuleName> x$2 = qual$2.copy$default$2();
        Option<String> x$3 = qual$2.copy$default$3();
        Option<Seq<Pom.License>> x$4 = qual$2.copy$default$4();
        Option<String> x$5 = qual$2.copy$default$5();
        Option<Seq<Tuple3<Organization, ModuleName, String>>> x$6 = qual$2.copy$default$6();
        Option<Seq<Pom.Developer>> x$7 = qual$2.copy$default$7();
        Option<Object> x$8 = qual$2.copy$default$8();
        Option<Object> x$9 = qual$2.copy$default$9();
        MetadataParams x$10 = qual$2.copy((Option<Organization>)x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
        RepositoryParams x$11 = qual$1.copy$default$1();
        SinglePackageParams x$12 = qual$1.copy$default$3();
        DirectoryParams x$13 = qual$1.copy$default$4();
        ChecksumParams x$14 = qual$1.copy$default$5();
        SignatureParams x$15 = qual$1.copy$default$6();
        CacheParams x$16 = qual$1.copy$default$7();
        int x$17 = qual$1.copy$default$8();
        boolean x$18 = qual$1.copy$default$9();
        boolean x$19 = qual$1.copy$default$10();
        Option<Object> x$20 = qual$1.copy$default$11();
        Option<Object> x$21 = qual$1.copy$default$12();
        Option<String> x$22 = qual$1.copy$default$13();
        p$1.elem = qual$1.copy(x$11, x$10, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
    }

    public static final /* synthetic */ boolean $anonfun$withConf$3(ObjectRef p$1, String v) {
        return ((PublishParams)p$1.elem).metadata().version().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$withConf$4(ObjectRef p$1, String v) {
        PublishParams qual$3 = (PublishParams)p$1.elem;
        MetadataParams qual$4 = ((PublishParams)p$1.elem).metadata();
        Some x$23 = new Some((Object)v);
        Option<Organization> x$24 = qual$4.copy$default$1();
        Option<ModuleName> x$25 = qual$4.copy$default$2();
        Option<Seq<Pom.License>> x$26 = qual$4.copy$default$4();
        Option<String> x$27 = qual$4.copy$default$5();
        Option<Seq<Tuple3<Organization, ModuleName, String>>> x$28 = qual$4.copy$default$6();
        Option<Seq<Pom.Developer>> x$29 = qual$4.copy$default$7();
        Option<Object> x$30 = qual$4.copy$default$8();
        Option<Object> x$31 = qual$4.copy$default$9();
        MetadataParams x$32 = qual$4.copy(x$24, x$25, (Option<String>)x$23, x$26, x$27, x$28, x$29, x$30, x$31);
        RepositoryParams x$33 = qual$3.copy$default$1();
        SinglePackageParams x$34 = qual$3.copy$default$3();
        DirectoryParams x$35 = qual$3.copy$default$4();
        ChecksumParams x$36 = qual$3.copy$default$5();
        SignatureParams x$37 = qual$3.copy$default$6();
        CacheParams x$38 = qual$3.copy$default$7();
        int x$39 = qual$3.copy$default$8();
        boolean x$40 = qual$3.copy$default$9();
        boolean x$41 = qual$3.copy$default$10();
        Option<Object> x$42 = qual$3.copy$default$11();
        Option<Object> x$43 = qual$3.copy$default$12();
        Option<String> x$44 = qual$3.copy$default$13();
        p$1.elem = qual$3.copy(x$33, x$32, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44);
    }

    public static final /* synthetic */ boolean $anonfun$withConf$5(ObjectRef p$1, String url) {
        return ((PublishParams)p$1.elem).metadata().homePage().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$withConf$6(ObjectRef p$1, String url) {
        PublishParams qual$5 = (PublishParams)p$1.elem;
        MetadataParams qual$6 = ((PublishParams)p$1.elem).metadata();
        Some x$45 = new Some((Object)url);
        Option<Organization> x$46 = qual$6.copy$default$1();
        Option<ModuleName> x$47 = qual$6.copy$default$2();
        Option<String> x$48 = qual$6.copy$default$3();
        Option<Seq<Pom.License>> x$49 = qual$6.copy$default$4();
        Option<Seq<Tuple3<Organization, ModuleName, String>>> x$50 = qual$6.copy$default$6();
        Option<Seq<Pom.Developer>> x$51 = qual$6.copy$default$7();
        Option<Object> x$52 = qual$6.copy$default$8();
        Option<Object> x$53 = qual$6.copy$default$9();
        MetadataParams x$54 = qual$6.copy(x$46, x$47, x$48, x$49, (Option<String>)x$45, x$50, x$51, x$52, x$53);
        RepositoryParams x$55 = qual$5.copy$default$1();
        SinglePackageParams x$56 = qual$5.copy$default$3();
        DirectoryParams x$57 = qual$5.copy$default$4();
        ChecksumParams x$58 = qual$5.copy$default$5();
        SignatureParams x$59 = qual$5.copy$default$6();
        CacheParams x$60 = qual$5.copy$default$7();
        int x$61 = qual$5.copy$default$8();
        boolean x$62 = qual$5.copy$default$9();
        boolean x$63 = qual$5.copy$default$10();
        Option<Object> x$64 = qual$5.copy$default$11();
        Option<Object> x$65 = qual$5.copy$default$12();
        Option<String> x$66 = qual$5.copy$default$13();
        p$1.elem = qual$5.copy(x$55, x$54, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66);
    }

    public static final /* synthetic */ boolean $anonfun$withConf$7(ObjectRef p$1, List licenses) {
        return ((PublishParams)p$1.elem).metadata().licenses().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$withConf$8(ObjectRef p$1, List licenses) {
        PublishParams qual$7 = (PublishParams)p$1.elem;
        MetadataParams qual$8 = ((PublishParams)p$1.elem).metadata();
        Some x$67 = new Some((Object)licenses);
        Option<Organization> x$68 = qual$8.copy$default$1();
        Option<ModuleName> x$69 = qual$8.copy$default$2();
        Option<String> x$70 = qual$8.copy$default$3();
        Option<String> x$71 = qual$8.copy$default$5();
        Option<Seq<Tuple3<Organization, ModuleName, String>>> x$72 = qual$8.copy$default$6();
        Option<Seq<Pom.Developer>> x$73 = qual$8.copy$default$7();
        Option<Object> x$74 = qual$8.copy$default$8();
        Option<Object> x$75 = qual$8.copy$default$9();
        MetadataParams x$76 = qual$8.copy(x$68, x$69, x$70, (Option<Seq<Pom.License>>)x$67, x$71, x$72, x$73, x$74, x$75);
        RepositoryParams x$77 = qual$7.copy$default$1();
        SinglePackageParams x$78 = qual$7.copy$default$3();
        DirectoryParams x$79 = qual$7.copy$default$4();
        ChecksumParams x$80 = qual$7.copy$default$5();
        SignatureParams x$81 = qual$7.copy$default$6();
        CacheParams x$82 = qual$7.copy$default$7();
        int x$83 = qual$7.copy$default$8();
        boolean x$84 = qual$7.copy$default$9();
        boolean x$85 = qual$7.copy$default$10();
        Option<Object> x$86 = qual$7.copy$default$11();
        Option<Object> x$87 = qual$7.copy$default$12();
        Option<String> x$88 = qual$7.copy$default$13();
        p$1.elem = qual$7.copy(x$77, x$76, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88);
    }

    public static final /* synthetic */ boolean $anonfun$withConf$9(ObjectRef p$1, List developers) {
        return ((PublishParams)p$1.elem).metadata().developersOpt().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$withConf$10(ObjectRef p$1, List developers) {
        PublishParams qual$9 = (PublishParams)p$1.elem;
        MetadataParams qual$10 = ((PublishParams)p$1.elem).metadata();
        Some x$89 = new Some((Object)developers);
        Option<Organization> x$90 = qual$10.copy$default$1();
        Option<ModuleName> x$91 = qual$10.copy$default$2();
        Option<String> x$92 = qual$10.copy$default$3();
        Option<Seq<Pom.License>> x$93 = qual$10.copy$default$4();
        Option<String> x$94 = qual$10.copy$default$5();
        Option<Seq<Tuple3<Organization, ModuleName, String>>> x$95 = qual$10.copy$default$6();
        Option<Object> x$96 = qual$10.copy$default$8();
        Option<Object> x$97 = qual$10.copy$default$9();
        MetadataParams x$98 = qual$10.copy(x$90, x$91, x$92, x$93, x$94, x$95, (Option<Seq<Pom.Developer>>)x$89, x$96, x$97);
        RepositoryParams x$99 = qual$9.copy$default$1();
        SinglePackageParams x$100 = qual$9.copy$default$3();
        DirectoryParams x$101 = qual$9.copy$default$4();
        ChecksumParams x$102 = qual$9.copy$default$5();
        SignatureParams x$103 = qual$9.copy$default$6();
        CacheParams x$104 = qual$9.copy$default$7();
        int x$105 = qual$9.copy$default$8();
        boolean x$106 = qual$9.copy$default$9();
        boolean x$107 = qual$9.copy$default$10();
        Option<Object> x$108 = qual$9.copy$default$11();
        Option<Object> x$109 = qual$9.copy$default$12();
        Option<String> x$110 = qual$9.copy$default$13();
        p$1.elem = qual$9.copy(x$99, x$98, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110);
    }

    public static final /* synthetic */ Function1 $anonfun$initSigner$1(Either x0$1) {
        Function1 function1;
        Either either = x0$1;
        if (either instanceof Left) {
            Left left = (Left)either;
            String msg = (String)left.value();
            function1 = Task$.MODULE$.fail((Throwable)new Exception(new StringBuilder(16).append("Failed to sign: ").append(msg).toString()));
        } else if (either instanceof Right) {
            function1 = Task$.MODULE$.point((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return function1;
    }

    public PublishParams(RepositoryParams repository, MetadataParams metadata, SinglePackageParams singlePackage, DirectoryParams directory, ChecksumParams checksum, SignatureParams signature, CacheParams cache, int verbosity, boolean dummy, boolean batch, Option<Object> sbtOutputFrame, Option<Object> parallel, Option<String> urlSuffixOpt) {
        this.repository = repository;
        this.metadata = metadata;
        this.singlePackage = singlePackage;
        this.directory = directory;
        this.checksum = checksum;
        this.signature = signature;
        this.cache = cache;
        this.verbosity = verbosity;
        this.dummy = dummy;
        this.batch = batch;
        this.sbtOutputFrame = sbtOutputFrame;
        this.parallel = parallel;
        this.urlSuffixOpt = urlSuffixOpt;
        Product.$init$((Product)this);
    }
}

