/*
 * Decompiled with CFR 0.152.
 */
package io.getquill.context.cassandra;

import io.getquill.ast.Aggregation;
import io.getquill.ast.AggregationOperator;
import io.getquill.ast.AggregationOperator$size$;
import io.getquill.ast.Ast;
import io.getquill.ast.CaseClass;
import io.getquill.ast.Constant$;
import io.getquill.ast.Distinct;
import io.getquill.ast.Entity;
import io.getquill.ast.Filter;
import io.getquill.ast.FlatMap;
import io.getquill.ast.GroupBy;
import io.getquill.ast.Ident;
import io.getquill.ast.Join;
import io.getquill.ast.JoinType;
import io.getquill.ast.Lift;
import io.getquill.ast.Map;
import io.getquill.ast.Ordering;
import io.getquill.ast.Property;
import io.getquill.ast.PropertyOrdering;
import io.getquill.ast.Query;
import io.getquill.ast.ScalarTag;
import io.getquill.ast.SortBy;
import io.getquill.ast.Take;
import io.getquill.ast.Tuple;
import io.getquill.ast.TupleOrdering;
import io.getquill.ast.Union;
import io.getquill.ast.UnionAll;
import io.getquill.context.cassandra.CqlQuery;
import io.getquill.context.cassandra.OrderByCriteria;
import io.getquill.util.Messages$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CqlQuery$
implements Serializable {
    public static final CqlQuery$ MODULE$ = new CqlQuery$();

    public CqlQuery apply(Query q) {
        Distinct distinct;
        Ast q2;
        Query query = q;
        if (query instanceof Distinct && (q2 = (distinct = (Distinct)query).a()) instanceof Query) {
            Query query2 = (Query)q2;
            return this.apply(query2, true);
        }
        return this.apply(q, false);
    }

    private CqlQuery apply(Query q, boolean distinct) {
        Query query = q;
        if (query instanceof Map) {
            Map map = (Map)query;
            Ast q2 = map.query();
            Ast p = map.body();
            if (q2 instanceof Query) {
                Query query2 = (Query)q2;
                return this.apply(query2, this.select(p), distinct);
            }
        }
        if (query instanceof Aggregation) {
            Aggregation aggregation = (Aggregation)query;
            AggregationOperator aggregationOperator = aggregation.operator();
            Ast q3 = aggregation.ast();
            if (AggregationOperator$size$.MODULE$.equals(aggregationOperator) && q3 instanceof Query) {
                Query query3 = (Query)q3;
                return this.apply(query3, (List<Ast>)new .colon.colon((Object)new Aggregation(AggregationOperator$size$.MODULE$, Constant$.MODULE$.auto(BoxesRunTime.boxToInteger((int)1))), (List)Nil$.MODULE$), distinct);
            }
        }
        return this.apply(q, (List<Ast>)package$.MODULE$.List().empty(), distinct);
    }

    private CqlQuery apply(Query q, List<Ast> select, boolean distinct) {
        Query query = q;
        if (query instanceof Take) {
            Take take = (Take)query;
            Ast q2 = take.query();
            Ast limit = take.n();
            if (q2 instanceof Query) {
                Query query2 = (Query)q2;
                return this.apply(query2, (Option<Ast>)new Some((Object)limit), select, distinct);
            }
        }
        return this.apply(q, (Option<Ast>)None$.MODULE$, select, distinct);
    }

    private CqlQuery apply(Query q, Option<Ast> limit, List<Ast> select, boolean distinct) {
        Query query = q;
        if (query instanceof SortBy) {
            SortBy sortBy = (SortBy)query;
            Ast q2 = sortBy.query();
            Ast p = sortBy.criteria();
            Ast o = sortBy.ordering();
            if (q2 instanceof Query) {
                Query query2 = (Query)q2;
                return this.apply(query2, this.orderByCriteria(p, o), limit, select, distinct);
            }
        }
        return this.apply(q, (List<OrderByCriteria>)package$.MODULE$.List().empty(), limit, select, distinct);
    }

    private CqlQuery apply(Query q, List<OrderByCriteria> orderBy, Option<Ast> limit, List<Ast> select, boolean distinct) {
        Query query = q;
        if (query instanceof Filter) {
            Filter filter = (Filter)query;
            Ast q2 = filter.query();
            Ast p = filter.body();
            if (q2 instanceof Query) {
                Query query2 = (Query)q2;
                return this.apply(query2, (Option<Ast>)new Some((Object)p), orderBy, limit, select, distinct);
            }
        }
        return this.apply(q, (Option<Ast>)None$.MODULE$, orderBy, limit, select, distinct);
    }

    private CqlQuery apply(Query q, Option<Ast> filter, List<OrderByCriteria> orderBy, Option<Ast> limit, List<Ast> select, boolean distinct) {
        Query query = q;
        if (query instanceof Entity) {
            Entity entity = (Entity)query;
            return new CqlQuery(entity, filter, orderBy, limit, select, distinct);
        }
        if (query instanceof FlatMap) {
            throw Messages$.MODULE$.fail("Cql doesn't support flatMap.");
        }
        if (query instanceof Union ? true : query instanceof UnionAll) {
            throw Messages$.MODULE$.fail("Cql doesn't support union/unionAll.");
        }
        if (query instanceof Join) {
            Join join = (Join)query;
            JoinType joinType = join.typ();
            throw Messages$.MODULE$.fail("Cql doesn't support " + joinType + ".");
        }
        if (query instanceof GroupBy) {
            throw Messages$.MODULE$.fail("Cql doesn't support groupBy.");
        }
        throw Messages$.MODULE$.fail("Invalid cql query: " + query);
    }

    private List<Ast> select(Ast ast2) {
        Ast ast3 = ast2;
        if (ast3 instanceof Tuple) {
            Tuple tuple = (Tuple)ast3;
            List<Ast> values = tuple.values();
            return values.flatMap((Function1 & Serializable)ast -> MODULE$.select((Ast)ast));
        }
        if (ast3 instanceof CaseClass) {
            CaseClass caseClass = (CaseClass)ast3;
            List<Tuple2<String, Ast>> values = caseClass.values();
            return values.flatMap((Function1 & Serializable)v -> MODULE$.select((Ast)v._2()));
        }
        if (ast3 instanceof Property) {
            Property property = (Property)ast3;
            return new .colon.colon((Object)property, (List)Nil$.MODULE$);
        }
        if (ast3 instanceof Ident) {
            return package$.MODULE$.List().empty();
        }
        if (ast3 instanceof Lift) {
            Lift lift = (Lift)ast3;
            return new .colon.colon((Object)lift, (List)Nil$.MODULE$);
        }
        if (ast3 instanceof ScalarTag) {
            ScalarTag scalarTag = (ScalarTag)ast3;
            return new .colon.colon((Object)scalarTag, (List)Nil$.MODULE$);
        }
        throw Messages$.MODULE$.fail("Cql supports only properties as select elements. Found: " + ast3);
    }

    private List<OrderByCriteria> orderByCriteria(Ast ast, Ast ordering) {
        Tuple2 tuple2 = new Tuple2((Object)ast, (Object)ordering);
        if (tuple2 != null) {
            Ast ast2 = (Ast)tuple2._1();
            Ast ord = (Ast)tuple2._2();
            if (ast2 instanceof Tuple) {
                Tuple tuple = (Tuple)ast2;
                List<Ast> properties = tuple.values();
                if (ord instanceof PropertyOrdering) {
                    PropertyOrdering propertyOrdering = (PropertyOrdering)ord;
                    return properties.flatMap((Function1 & Serializable)x$1 -> MODULE$.orderByCriteria((Ast)x$1, propertyOrdering));
                }
            }
        }
        if (tuple2 != null) {
            Ast ast3 = (Ast)tuple2._1();
            Ast ast4 = (Ast)tuple2._2();
            if (ast3 instanceof Tuple) {
                Tuple tuple = (Tuple)ast3;
                List<Ast> properties = tuple.values();
                if (ast4 instanceof TupleOrdering) {
                    TupleOrdering tupleOrdering = (TupleOrdering)ast4;
                    List<Ordering> ord = tupleOrdering.elems();
                    return ((List)properties.zip(ord)).flatMap((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Ast a = (Ast)tuple2._1();
                            Ordering o = (Ordering)tuple2._2();
                            return MODULE$.orderByCriteria(a, o);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
            }
        }
        if (tuple2 != null) {
            Ast a = (Ast)tuple2._1();
            Ast o = (Ast)tuple2._2();
            if (a instanceof Property) {
                Property property = (Property)a;
                if (o instanceof PropertyOrdering) {
                    PropertyOrdering propertyOrdering = (PropertyOrdering)o;
                    return new .colon.colon((Object)new OrderByCriteria(property, propertyOrdering), (List)Nil$.MODULE$);
                }
            }
        }
        throw Messages$.MODULE$.fail("Invalid order by criteria " + ast);
    }

    public CqlQuery apply(Entity entity, Option<Ast> filter, List<OrderByCriteria> orderBy, Option<Ast> limit, List<Ast> select, boolean distinct) {
        return new CqlQuery(entity, filter, orderBy, limit, select, distinct);
    }

    public Option<Tuple6<Entity, Option<Ast>, List<OrderByCriteria>, Option<Ast>, List<Ast>, Object>> unapply(CqlQuery x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.entity(), x$0.filter(), x$0.orderBy(), x$0.limit(), x$0.select(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.distinct())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CqlQuery$.class);
    }

    private CqlQuery$() {
    }
}

