/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class MavenDependencyPathResolver {
    private static final Logger log = LoggerFactory.getLogger(MavenDependencyPathResolver.class);
    private final ArtifactResolver artifactResolver;
    private final DependencyResolver dependencyResolver;

    @Inject
    public MavenDependencyPathResolver(ArtifactResolver artifactResolver, DependencyResolver dependencyResolver) {
        this.artifactResolver = artifactResolver;
        this.dependencyResolver = dependencyResolver;
    }

    public Collection<Path> resolveProjectDependencyPaths(MavenSession session, Set<String> allowedScopes) throws ResolutionException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Dependency dependency : session.getCurrentProject().getDependencies()) {
            DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
            coordinate.setGroupId(dependency.getGroupId());
            coordinate.setArtifactId(dependency.getArtifactId());
            coordinate.setVersion(dependency.getVersion());
            coordinate.setType(dependency.getType());
            coordinate.setClassifier(dependency.getClassifier());
            paths.addAll(this.resolveDependencyTreePaths(session, allowedScopes, (DependableCoordinate)coordinate));
        }
        return paths;
    }

    public Path resolveArtifact(MavenSession session, ArtifactCoordinate artifact) throws ResolutionException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        try {
            return this.artifactResolver.resolveArtifact((ProjectBuildingRequest)request, artifact).getArtifact().getFile().toPath();
        }
        catch (ArtifactResolverException ex) {
            throw new ResolutionException("Failed to resolve artifact '" + artifact + "'", ex);
        }
    }

    public Collection<Path> resolveDependencyTreePaths(MavenSession session, Set<String> allowedScopes, DependableCoordinate dependency) throws ResolutionException {
        log.debug("Resolving dependency '{}'", (Object)dependency);
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        artifactCoordinate.setGroupId(dependency.getGroupId());
        artifactCoordinate.setArtifactId(dependency.getArtifactId());
        artifactCoordinate.setVersion(dependency.getVersion());
        artifactCoordinate.setExtension(dependency.getType());
        artifactCoordinate.setClassifier(dependency.getClassifier());
        ArrayList<Path> allDependencyPaths = new ArrayList<Path>();
        Path artifactPath = this.resolveArtifact(session, (ArtifactCoordinate)artifactCoordinate);
        allDependencyPaths.add(artifactPath);
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        ScopeFilter scopes = ScopeFilter.including(allowedScopes);
        try {
            for (ArtifactResult next : this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)request, dependency, (TransformableFilter)scopes)) {
                allDependencyPaths.add(next.getArtifact().getFile().toPath());
            }
        }
        catch (DependencyResolverException ex) {
            throw new ResolutionException("Failed to resolve dependencies of '" + dependency + "'", ex);
        }
        return allDependencyPaths;
    }
}

