/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.PlatformArtifactFactory;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.dependency.UrlResourceFetcher;
import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import io.github.ascopes.protobufmavenplugin.platform.HostSystem;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtocResolver {
    private static final String EXECUTABLE_NAME = "protoc";
    private static final String GROUP_ID = "com.google.protobuf";
    private static final String ARTIFACT_ID = "protoc";
    private static final Logger log = LoggerFactory.getLogger(ProtocResolver.class);
    private final HostSystem hostSystem;
    private final MavenDependencyPathResolver mavenDependencyPathResolver;
    private final PlatformArtifactFactory platformArtifactFactory;
    private final SystemPathBinaryResolver systemPathResolver;
    private final UrlResourceFetcher urlResourceFetcher;

    @Inject
    public ProtocResolver(HostSystem hostSystem, MavenDependencyPathResolver mavenDependencyPathResolver, PlatformArtifactFactory platformArtifactFactory, SystemPathBinaryResolver systemPathResolver, UrlResourceFetcher urlResourceFetcher) {
        this.hostSystem = hostSystem;
        this.mavenDependencyPathResolver = mavenDependencyPathResolver;
        this.platformArtifactFactory = platformArtifactFactory;
        this.systemPathResolver = systemPathResolver;
        this.urlResourceFetcher = urlResourceFetcher;
    }

    public Path resolve(MavenSession session, String version) throws ResolutionException {
        if (version.equalsIgnoreCase("PATH")) {
            return this.systemPathResolver.resolve("protoc").orElseThrow(() -> new ResolutionException("No protoc executable was found"));
        }
        Path path = version.contains(":") ? this.resolveFromUrl(version) : this.resolveFromMavenRepositories(session, version);
        try {
            FileUtils.makeExecutable(path);
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to set executable bit on protoc binary", ex);
        }
        return path;
    }

    private Path resolveFromUrl(String url) throws ResolutionException {
        try {
            return this.urlResourceFetcher.fetchFileFromUrl(new URL(url), ".exe");
        }
        catch (IOException ex) {
            throw new ResolutionException(ex.getMessage(), ex);
        }
    }

    private Path resolveFromMavenRepositories(MavenSession session, String version) throws ResolutionException {
        if (this.hostSystem.isProbablyAndroidTermux()) {
            log.warn("It looks like you are using Termux on Android. You may encounter issues running the detected protoc binary from Maven central. If this is an issue, install the protoc compiler manually from your package manager (apt update && apt install protobuf), and then invoke Maven with the -Dprotoc.version=PATH flag.");
        }
        ArtifactCoordinate coordinate = this.platformArtifactFactory.createArtifact(GROUP_ID, "protoc", version, null, null);
        return this.mavenDependencyPathResolver.resolveArtifact(session, coordinate);
    }
}

