/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generate.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.platform.Digests;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.Maven;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class UrlResourceFetcher {
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    private static final String USER_AGENT = "User-Agent";
    private static final Logger log = LoggerFactory.getLogger(UrlResourceFetcher.class);
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(CONNECT_TIMEOUT).followRedirects(HttpClient.Redirect.NORMAL).build();
    private final TemporarySpace temporarySpace;

    @Inject
    public UrlResourceFetcher(TemporarySpace temporarySpace) {
        this.temporarySpace = temporarySpace;
    }

    public Path fetchFileFromUrl(URL url, String defaultExtension) throws ResolutionException {
        switch (url.getProtocol().toLowerCase()) {
            case "file": {
                return this.handleFileSystemUrl(url);
            }
            case "http": 
            case "https": {
                return this.handleHttpRequest(url, defaultExtension);
            }
        }
        return this.handleOtherUrl(url, defaultExtension);
    }

    private Path handleFileSystemUrl(URL url) throws ResolutionException {
        try {
            return Path.of(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new ResolutionException("Failed to resolve '" + url + "' due to malformed syntax", ex);
        }
    }

    private Path handleHttpRequest(URL url, String extension) throws ResolutionException {
        Path targetFile = this.targetFile(url, extension);
        try {
            URI uri = url.toURI();
            HttpRequest req = HttpRequest.newBuilder().GET().uri(uri).header(USER_AGENT, this.userAgent()).build();
            log.info("Performing HTTP request to {} to download resources into {}", (Object)url, (Object)targetFile);
            HttpResponse<InputStream> resp = this.httpClient.send(req, HttpResponse.BodyHandlers.ofInputStream());
            this.handleResponse(resp, targetFile);
        }
        catch (IOException | InterruptedException | URISyntaxException ex) {
            throw this.failedToCopy(url, targetFile, ex);
        }
        return targetFile;
    }

    private void handleResponse(HttpResponse<InputStream> response, Path targetFile) throws IOException, ResolutionException {
        int status = response.statusCode();
        try (InputStream responseBody = response.body();){
            if (status == 200) {
                log.info("{} {} returned {}, streaming response...", new Object[]{response.request().method(), response.request().uri(), response.statusCode()});
                try (BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(targetFile, new OpenOption[0]));){
                    responseBody.transferTo(fileStream);
                }
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                responseBody.transferTo(baos);
                String body = baos.toString(StandardCharsets.ISO_8859_1);
                throw new ResolutionException("Failed to request '" + response.uri() + "', received a " + status + " status with body: " + body);
            }
            catch (Throwable throwable) {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private Path handleOtherUrl(URL url, String extension) throws ResolutionException {
        Path targetFile = this.targetFile(url, extension);
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout((int)CONNECT_TIMEOUT.toMillis());
            conn.setReadTimeout((int)CONNECT_TIMEOUT.toMillis());
            conn.setAllowUserInteraction(false);
            conn.setDoOutput(false);
            conn.setRequestProperty(USER_AGENT, this.userAgent());
            conn.setUseCaches(true);
            log.info("Connecting to '{}' (URLConnection) to copy resourcces to '{}'", (Object)url, (Object)targetFile);
            conn.connect();
            try (InputStream responseBody = conn.getInputStream();){
                this.copyToFile(responseBody, targetFile);
            }
        }
        catch (IOException ex) {
            throw this.failedToCopy(url, targetFile, ex);
        }
        return targetFile;
    }

    private ResolutionException failedToCopy(URL source, Path destination, Exception cause) {
        return new ResolutionException("Failed to copy '" + source + "' to '" + destination + "'", cause);
    }

    private void copyToFile(InputStream inputStream, Path file) throws IOException {
        try (BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            inputStream.transferTo(fileStream);
        }
    }

    private String userAgent() {
        return "protobuf-maven-plugin/" + this.getClass().getPackage().getImplementationVersion() + " Apache-Maven/" + Maven.class.getPackage().getImplementationVersion() + " Java/" + Runtime.version().toString();
    }

    private Path targetFile(URL url, String extension) {
        String digest = Digests.sha1(url.toExternalForm());
        String path = url.getPath();
        int lastSlash = path.lastIndexOf(47);
        String fileName = lastSlash < 0 ? digest : path.substring(lastSlash + 1) + "-" + digest;
        return this.temporarySpace.createTemporarySpace("url", url.getProtocol()).resolve(fileName + extension);
    }
}

