/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.platform;

import java.util.Iterator;
import java.util.function.BiConsumer;

public final class Shlex {
    private Shlex() {
    }

    public static String quoteShellArgs(Iterable<String> args) {
        return Shlex.quote(args, Shlex::quoteShellArg);
    }

    public static String quoteBatchArgs(Iterable<String> args) {
        return Shlex.quote(args, Shlex::quoteBatchArg);
    }

    private static String quote(Iterable<String> args, BiConsumer<StringBuilder, String> quoter) {
        Iterator<String> iter = args.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        quoter.accept(sb, iter.next());
        while (iter.hasNext()) {
            sb.append(' ');
            quoter.accept(sb, iter.next());
        }
        return sb.toString();
    }

    private static void quoteShellArg(StringBuilder sb, String arg) {
        if (Shlex.isSafe(arg)) {
            sb.append(arg);
            return;
        }
        sb.append('\'');
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c == '\'') {
                sb.append("'\"'\"'");
                continue;
            }
            sb.append(c);
        }
        sb.append('\'');
    }

    private static void quoteBatchArg(StringBuilder sb, String arg) {
        if (Shlex.isSafe(arg)) {
            sb.append(arg);
            return;
        }
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\t': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '|': {
                    sb.append('^');
                }
            }
            sb.append(c);
        }
    }

    private static boolean isSafe(String arg) {
        for (int i = 0; i < arg.length(); ++i) {
            boolean safe;
            char c = arg.charAt(i);
            boolean bl = safe = 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-' || c == '/' || c == '_' || c == '.' || c == '=';
            if (safe) continue;
            return false;
        }
        return true;
    }
}

