/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class SystemPathBinaryResolver {
    private static final Logger log = LoggerFactory.getLogger(SystemPathBinaryResolver.class);
    private final HostSystem hostSystem;

    @Inject
    public SystemPathBinaryResolver(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Path> resolve(String name) throws ResolutionException {
        log.debug("Looking for executable matching name '{}' on PATH", (Object)name);
        Predicate<Path> predicate = this.hostSystem.isProbablyWindows() ? this.isWindowsMatch(name) : this.isPosixMatch(name);
        Iterator<Path> iterator = this.hostSystem.getSystemPath().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                log.debug("No match found for '{}' on PATH", (Object)name);
                return Optional.empty();
            }
            Path dir = iterator.next();
            try {
                Stream<Path> files = Files.walk(dir, 1, new FileVisitOption[0]);
                try {
                    Optional<Path> result = files.filter(predicate).findFirst();
                    if (!result.isPresent()) continue;
                    log.debug("Result for lookup of '{}' on PATH was {}", (Object)name, (Object)result.get());
                    Optional<Path> optional = result;
                    return optional;
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            catch (IOException ex) {
                throw new ResolutionException("An exception occurred while scanning the system PATH", ex);
            }
        }
    }

    private Predicate<Path> isWindowsMatch(String name) {
        return path -> {
            boolean matchesName = FileUtils.getFileNameWithoutExtension(path).equalsIgnoreCase(name);
            boolean matchesExtension = FileUtils.getFileExtension(path).filter(this.hostSystem.getSystemPathExtensions()::contains).isPresent();
            log.debug("Path '{}' matches name = {}, matches executable extension = {}", new Object[]{path, matchesName, matchesExtension});
            return matchesName && matchesExtension;
        };
    }

    private Predicate<Path> isPosixMatch(String name) {
        return path -> {
            boolean matchesName = path.getFileName().toString().equals(name);
            boolean matchesExecutableFlag = Files.isExecutable(path);
            log.debug("Path '{}' matches name = {}, matches executable flag = {}", new Object[]{path, matchesName, matchesExecutableFlag});
            return matchesName && matchesExecutableFlag;
        };
    }
}

