/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.plugins.BinaryMavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.JvmMavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.JvmPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.PathProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.UriProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;

@Description(value="Resolves and packages protoc plugins from various remote and local locations")
@MojoExecutionScoped
@Named
public final class ProjectPluginResolver {
    private final BinaryPluginResolver binaryPluginResolver;
    private final JvmPluginResolver jvmPluginResolver;

    @Inject
    ProjectPluginResolver(BinaryPluginResolver binaryPluginResolver, JvmPluginResolver jvmPluginResolver) {
        this.binaryPluginResolver = binaryPluginResolver;
        this.jvmPluginResolver = jvmPluginResolver;
    }

    public Collection<ResolvedProtocPlugin> resolveProjectPlugins(GenerationRequest request) throws ResolutionException {
        ArrayList<ResolvedProtocPlugin> plugins = new ArrayList<ResolvedProtocPlugin>();
        plugins.addAll(this.binaryPluginResolver.resolveMavenPlugins(this.extract(request, BinaryMavenProtocPlugin.class), request.getOutputDirectory()));
        plugins.addAll(this.binaryPluginResolver.resolvePathPlugins(this.extract(request, PathProtocPlugin.class), request.getOutputDirectory()));
        plugins.addAll(this.binaryPluginResolver.resolveUrlPlugins(this.extract(request, UriProtocPlugin.class), request.getOutputDirectory()));
        plugins.addAll(this.jvmPluginResolver.resolveMavenPlugins(this.extract(request, JvmMavenProtocPlugin.class), request.getOutputDirectory()));
        plugins.trimToSize();
        return Collections.unmodifiableList(plugins);
    }

    private <T> Collection<T> extract(GenerationRequest request, Class<T> implementationType) {
        return request.getProtocPlugins().stream().filter(implementationType::isInstance).map(implementationType::cast).toList();
    }
}

