/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.java;

import io.github.ascopes.protobufmavenplugin.fs.FileUtils;
import io.github.ascopes.protobufmavenplugin.fs.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.java.JavaApp;
import io.github.ascopes.protobufmavenplugin.java.JavaAppToExecutableFactory;
import io.github.ascopes.protobufmavenplugin.utils.ArgumentFileBuilder;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import io.github.ascopes.protobufmavenplugin.utils.SystemPathBinaryResolver;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Converts Java applications into native executable formats.")
@MojoExecutionScoped
@Named
final class JavaAppToExecutableScriptFactory
implements JavaAppToExecutableFactory {
    private static final List<String> DEFAULT_ARGS = List.of();
    private static final List<String> DEFAULT_JVM_ARGS = List.of("-Xshare:auto", "-XX:+TieredCompilation", "-XX:TieredStopAtLevel=1");
    private static final Logger log = LoggerFactory.getLogger(JavaAppToExecutableScriptFactory.class);
    private final HostSystem hostSystem;
    private final TemporarySpace temporarySpace;
    private final SystemPathBinaryResolver pathResolver;

    @Inject
    JavaAppToExecutableScriptFactory(HostSystem hostSystem, TemporarySpace temporarySpace, SystemPathBinaryResolver pathResolver) {
        this.hostSystem = hostSystem;
        this.temporarySpace = temporarySpace;
        this.pathResolver = pathResolver;
    }

    @Override
    public Path toExecutable(JavaApp app) throws ResolutionException {
        ArgumentFileBuilder argLine = this.buildArgLine(app);
        Path javaPath = this.hostSystem.getJavaExecutablePath();
        Path scratchDir = this.temporarySpace.createTemporarySpace("java-apps", app.getUniqueName());
        log.debug("Arguments for JVM app \"{}\" are:\n{}", (Object)app, (Object)argLine);
        return this.hostSystem.isProbablyWindows() ? this.writeWindowsScripts(javaPath, scratchDir, argLine) : this.writePosixScripts(javaPath, scratchDir, argLine);
    }

    private ArgumentFileBuilder buildArgLine(JavaApp app) throws ResolutionException {
        ArgumentFileBuilder args = new ArgumentFileBuilder();
        args.add("-classpath");
        args.add(this.buildJavaPath(app.getDependencies()));
        List<Path> modules = this.findJavaModules(app.getDependencies());
        if (!modules.isEmpty()) {
            args.add("--module-path");
            args.add(this.buildJavaPath(modules));
        }
        Objects.requireNonNullElse(app.getJvmConfigArgs(), DEFAULT_JVM_ARGS).stream().filter(this.checkValidJvmConfigArg(app)).forEach(args::add);
        args.add(this.determineMainClass(app));
        Objects.requireNonNullElse(app.getJvmArgs(), DEFAULT_ARGS).forEach(args::add);
        return args;
    }

    private Predicate<String> checkValidJvmConfigArg(JavaApp app) {
        return arg -> {
            if (arg.startsWith("-") && arg.length() > 1) {
                return true;
            }
            log.warn("Dropping illegal JVM argument \"{}\" for app \"{}\"", arg, (Object)app);
            return false;
        };
    }

    private String determineMainClass(JavaApp app) throws ResolutionException {
        if (app.getMainClass() != null) {
            log.debug("Using user-provided main class for app \"{}\": {}", (Object)app, (Object)app.getMainClass());
            return app.getMainClass();
        }
        Path firstPath = app.getDependencies().iterator().next();
        if (!Files.isDirectory(firstPath, new LinkOption[0])) {
            String mainClass = this.tryToDetermineMainClassFromJarManifest(firstPath);
            if (mainClass == null) {
                log.warn("No Main-Class manifest attribute found in \"{}\", this is probably a bug with how that JAR was built", (Object)firstPath);
            } else {
                log.debug("Determined main class to be \"{}\" from manifest for \"{}\"", (Object)mainClass, (Object)firstPath);
                return mainClass;
            }
        }
        throw new ResolutionException("No main class was described for \"" + String.valueOf(firstPath) + "\", please provide an explicit 'mainClass' attribute when configuring this component.");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private @Nullable String tryToDetermineMainClassFromJarManifest(Path pluginPath) throws ResolutionException {
        try (FileSystem zip = FileUtils.openZipAsFileSystem(pluginPath);){
            String string;
            block14: {
                InputStream manifestInputStream = FileUtils.newBufferedInputStream(zip.getPath("META-INF", "MANIFEST.MF"), new OpenOption[0]);
                try {
                    string = new Manifest(manifestInputStream).getMainAttributes().getValue("Main-Class");
                    if (manifestInputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (manifestInputStream != null) {
                        try {
                            manifestInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                manifestInputStream.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to determine the main class in the MANIFEST.MF for JAR corresponding to \"" + String.valueOf(pluginPath) + "\":" + String.valueOf(ex), ex);
        }
    }

    private String buildJavaPath(Iterable<Path> iterable) {
        Iterator<Path> iterator = iterable.iterator();
        StringBuilder sb = new StringBuilder().append(iterator.next());
        while (iterator.hasNext()) {
            sb.append(this.hostSystem.getPathSeparator()).append(iterator.next());
        }
        return sb.toString();
    }

    private List<Path> findJavaModules(List<Path> paths) {
        return ModuleFinder.of((Path[])paths.toArray(Path[]::new)).findAll().stream().map(ModuleReference::location).flatMap(Optional::stream).map(Path::of).map(FileUtils::normalize).sorted(Comparator.comparing(Path::toString)).toList();
    }

    private Path writePosixScripts(Path javaExecutable, Path scratchDir, ArgumentFileBuilder argFileBuilder) throws ResolutionException {
        Path sh = this.pathResolver.resolve("sh").orElseThrow();
        Path argumentFile = this.writeArgumentFile(StandardCharsets.UTF_8, scratchDir, argFileBuilder);
        Path script = scratchDir.resolve("invoke.sh");
        JavaAppToExecutableScriptFactory.writeAndPropagateExceptions(script, StandardCharsets.UTF_8, true, writer -> {
            writer.append("#!").append(sh.toString()).append('\n').append("set -o errexit\n");
            this.quoteShellArg(writer, javaExecutable.toString());
            writer.append(' ');
            this.quoteShellArg(writer, "@" + String.valueOf(argumentFile));
            writer.append('\n');
        });
        return script;
    }

    private Path writeWindowsScripts(Path javaExecutable, Path scratchDir, ArgumentFileBuilder argFileBuilder) throws ResolutionException {
        Path argumentFile = this.writeArgumentFile(StandardCharsets.ISO_8859_1, scratchDir, argFileBuilder);
        Path script = scratchDir.resolve("invoke.bat");
        JavaAppToExecutableScriptFactory.writeAndPropagateExceptions(script, StandardCharsets.ISO_8859_1, false, writer -> {
            writer.append("@echo off\r\n");
            this.quoteBatchArg(writer, javaExecutable.toString());
            writer.append(" ");
            this.quoteBatchArg(writer, "@" + String.valueOf(argumentFile));
            writer.append("\r\n");
        });
        return script;
    }

    private Path writeArgumentFile(Charset charset, Path scratchDir, ArgumentFileBuilder argumentFileBuilder) throws ResolutionException {
        Path argumentFile = scratchDir.resolve("args.txt");
        JavaAppToExecutableScriptFactory.writeAndPropagateExceptions(argumentFile, charset, false, argumentFileBuilder::writeToJavaArgumentFile);
        return argumentFile;
    }

    private void quoteShellArg(Appendable appendable, String arg) throws IOException {
        appendable.append('\'');
        block7: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\\': {
                    appendable.append("\\\\");
                    continue block7;
                }
                case '\'': {
                    appendable.append("'\"'\"'");
                    continue block7;
                }
                case '\n': {
                    appendable.append("'$'\\n''");
                    continue block7;
                }
                case '\r': {
                    appendable.append("'$'\\r''");
                    continue block7;
                }
                case '\t': {
                    appendable.append("'$'\\t''");
                    continue block7;
                }
                default: {
                    appendable.append(c);
                }
            }
        }
        appendable.append('\'');
    }

    private void quoteBatchArg(Appendable appendable, String arg) throws IOException {
        appendable.append("\"").append(arg.replaceAll("\"", "\"\"\"")).append("\"");
    }

    private static void writeAndPropagateExceptions(Path file, Charset charset, boolean makeExecutable, WriteOperation writeOperation) throws ResolutionException {
        try {
            try (BufferedWriter writer = Files.newBufferedWriter(file, charset, new OpenOption[0]);){
                writeOperation.writeTo(writer);
            }
            if (makeExecutable) {
                FileUtils.makeExecutable(file);
            }
        }
        catch (IOException ex) {
            throw new ResolutionException("An unexpected IO error occurred while writing to " + String.valueOf(file), ex);
        }
    }

    @FunctionalInterface
    private static interface WriteOperation {
        public void writeTo(BufferedWriter var1) throws IOException;
    }
}

