/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plexus;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.basic.AbstractBasicConverter;
import org.eclipse.sisu.Description;

@Description(value="A polyfill for Maven <3.9.8 to support parsing URI objects")
@Named
@Singleton
final class UriPlexusConverter
extends AbstractBasicConverter {
    UriPlexusConverter() {
    }

    public boolean canConvert(Class<?> type) {
        return URI.class.equals(type);
    }

    protected Object fromString(String str) throws ComponentConfigurationException {
        try {
            return new URI(str);
        }
        catch (URISyntaxException ex) {
            throw new ComponentConfigurationException("Cannot convert '" + str + "' to URI", (Throwable)ex);
        }
    }
}

