/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.versions;

import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private Shell() {
        throw new IllegalStateException("Utility class");
    }

    public static String runAndWait(String ... command) {
        return Shell.runAndWait(true, command);
    }

    public static String runAndWait(File folder, String ... command) {
        return Shell.runAndWaitArray(true, folder, command);
    }

    public static String runAndWait(boolean logCommand, String ... command) {
        return Shell.runAndWaitArray(logCommand, new File("."), command);
    }

    public static String runAndWait(boolean logCommand, File folder, String ... command) {
        return Shell.runAndWaitArray(logCommand, folder, command);
    }

    public static String runAndWaitArray(boolean logCommand, File folder, String[] command) {
        String commandStr = Arrays.toString(command);
        if (logCommand) {
            log.debug("Running command on the shell: {}", (Object)commandStr);
        }
        String result = Shell.runAndWaitNoLog(folder, command);
        if (logCommand) {
            log.debug("Result: {}", (Object)result);
        }
        return result;
    }

    public static String runAndWaitNoLog(File folder, String ... command) {
        String output;
        block2: {
            output = "";
            try {
                Process process = new ProcessBuilder(command).directory(folder).redirectErrorStream(false).start();
                process.waitFor();
                output = IOUtils.toString((InputStream)process.getInputStream(), (String)StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("There was a problem executing command <{}> on the shell: {}", (Object)String.join((CharSequence)" ", command), (Object)e.getMessage());
            }
        }
        return output.trim();
    }
}

