/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.webdriver;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Recording {
    public static final String DOCKER_RECORDING_EXT = ".mp4";
    public static final String EXTENSION_RECORDING_EXT = ".webm";
    private static final String SEPARATOR = "_";
    private static final String DATE_FORMAT = "yyyy.MM.dd_HH.mm.ss.SSS";

    private Recording() {
        throw new IllegalStateException("Utility class");
    }

    public static String getRecordingName(String browserName, String sessionId) {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        return browserName + SEPARATOR + dateFormat.format(now) + SEPARATOR + sessionId;
    }

    public static String getRecordingNameForDocker(String browserName, String sessionId) {
        return Recording.getRecordingName(browserName, sessionId) + DOCKER_RECORDING_EXT;
    }

    public static String getRecordingNameForBrowserWatcher(String browserName, String sessionId) {
        return Recording.getRecordingName(browserName, sessionId) + EXTENSION_RECORDING_EXT;
    }
}

