/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.webdriver.OptionsWithArguments;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.net.URIBuilder;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.edge.EdgeOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EdgeDriverManager
extends WebDriverManager {
    protected static final String LATEST_STABLE = "LATEST_STABLE";
    protected static final String STORAGE_QUERY = "?restype=container&comp=list";

    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.EDGE;
    }

    @Override
    protected String getDriverName() {
        return "msedgedriver";
    }

    @Override
    protected String getShortDriverName() {
        return "edgedriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getEdgeDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getEdgeVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setEdgeDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setEdgeVersion(browserVersion);
    }

    @Override
    protected String getBrowserBinary() {
        return this.config().getEdgeBinary();
    }

    @Override
    protected void setBrowserBinary(String browserBinary) {
        this.config().setEdgeBinary(browserBinary);
    }

    @Override
    protected URL getDriverUrl() {
        return this.config().getEdgeDriverUrl();
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getEdgeDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setEdgeDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls(String driverVersion) throws IOException {
        return this.getDriversFromXml(new URL(this.getDriverUrl() + STORAGE_QUERY), "//Blob/Name", Optional.empty());
    }

    @Override
    protected List<File> postDownload(File archive) {
        Collection listFiles = FileUtils.listFiles((File)new File(archive.getParent()), null, (boolean)true);
        Iterator iterator = listFiles.iterator();
        File file = null;
        ArrayList<File> files = new ArrayList<File>();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            String fileName = file.getName();
            if (fileName.contains(this.getDriverName())) {
                log.trace("Adding {} at the begining of the resulting file list", (Object)fileName);
                files.add(0, file);
                continue;
            }
            if (!fileName.toLowerCase(Locale.ROOT).endsWith(".dylib")) continue;
            log.trace("Adding {} to the resulting file list", (Object)fileName);
            files.add(file);
        }
        return files;
    }

    @Override
    protected Optional<String> getLatestDriverVersionFromRepository() {
        if (this.config().isUseBetaVersions()) {
            return Optional.empty();
        }
        return this.getDriverVersionFromRepository(Optional.empty());
    }

    @Override
    protected Charset getVersionCharset() {
        return StandardCharsets.UTF_16;
    }

    @Override
    protected String getLatestVersionLabel() {
        return LATEST_STABLE;
    }

    @Override
    protected Optional<String> getOsLabel() {
        String label = "_";
        switch (this.config().getOperatingSystem()) {
            case WIN: {
                label = label + "WINDOWS";
                break;
            }
            case MAC: {
                label = label + "MACOS";
                break;
            }
            default: {
                label = label + this.config().getOs();
            }
        }
        return Optional.of(label);
    }

    @Override
    protected Optional<URL> buildUrl(String driverVersion) {
        return this.buildUrl(driverVersion, this.config());
    }

    Optional<URL> buildUrl(String driverVersion, Config config) {
        Optional<URL> optionalUrl = Optional.empty();
        if (!config.isUseMirror()) {
            String archLabel;
            String downloadUrlPattern = config.getEdgeDownloadUrlPattern();
            OperatingSystem os = config.getOperatingSystem();
            Architecture arch = config.getArchitecture();
            String string = archLabel = os.isWin() ? arch.toString() : "64";
            if (arch == Architecture.ARM64) {
                archLabel = "64";
            }
            String osName = arch != Architecture.ARM64 ? os.getName() : "arm";
            String builtUrl = os == OperatingSystem.MAC && arch == Architecture.ARM64 ? String.format(downloadUrlPattern, driverVersion, "mac", "64_m1") : String.format(downloadUrlPattern, driverVersion, osName, archLabel);
            log.debug("Using URL built from repository pattern: {}", (Object)builtUrl);
            try {
                optionalUrl = Optional.of(new URL(builtUrl));
            }
            catch (MalformedURLException e) {
                log.warn("Error building URL from pattern {} {}", (Object)builtUrl, (Object)e.getMessage());
            }
        }
        return optionalUrl;
    }

    @Override
    protected Capabilities getCapabilities() {
        Object options = new EdgeOptions();
        try {
            this.addDefaultArgumentsForDocker((Capabilities)options);
        }
        catch (Exception e) {
            log.error("Exception adding default arguments for Docker, retyring with custom class");
            options = new OptionsWithArguments("MicrosoftEdge", "ms:edgeOptions");
            try {
                this.addDefaultArgumentsForDocker((Capabilities)options);
            }
            catch (Exception e1) {
                log.error("Exception getting default capabilities", (Throwable)e);
            }
        }
        return options;
    }

    @Override
    public WebDriverManager exportParameter(String exportParameter) {
        this.config().setEdgeDriverExport(exportParameter);
        return this;
    }

    protected List<URL> getDriversFromXml(URL driverUrl, String xpath, Optional<NamespaceContext> namespaceContext) throws IOException {
        this.logSeekRepo(driverUrl);
        ArrayList<URL> urls = new ArrayList<URL>();
        try (ClassicHttpResponse response = this.getHttpClient().execute((ClassicHttpRequest)this.getHttpClient().createHttpGet(driverUrl));){
            Document xml = EdgeDriverManager.loadXML(response.getEntity().getContent());
            XPath xPath = XPathFactory.newInstance().newXPath();
            if (namespaceContext.isPresent()) {
                xPath.setNamespaceContext(namespaceContext.get());
            }
            NodeList nodes = (NodeList)xPath.evaluate(xpath, xml.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e = (Element)nodes.item(i);
                urls.add(new URL(driverUrl.toURI().resolve(".") + e.getChildNodes().item(0).getNodeValue()));
            }
            NodeList nextMarkerNodes = (NodeList)xPath.evaluate("/EnumerationResults/NextMarker", xml.getDocumentElement(), XPathConstants.NODESET);
            if (nextMarkerNodes.getLength() > 0) {
                String marker;
                String containerName = String.format("%s://%s/", driverUrl.getProtocol(), driverUrl.getAuthority());
                Element e = (Element)nextMarkerNodes.item(0);
                if (e.hasChildNodes() && StringUtils.isNotEmpty((CharSequence)(marker = e.getFirstChild().getNodeValue()))) {
                    urls.addAll(this.getDriversFromXml(new URIBuilder(containerName + STORAGE_QUERY).setParameter("marker", marker).build().toURL(), xpath, namespaceContext));
                }
            }
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        return urls;
    }
}

