/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.localdate;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class LocalDateAsDocumentCodec
implements Codec<LocalDate> {
    private static final Map<String, Decoder<?>> FIELD_DECODERS;

    public void encode(BsonWriter writer, LocalDate value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeStartDocument();
        writer.writeInt32("year", value.getYear());
        writer.writeInt32("month", value.getMonthValue());
        writer.writeInt32("day", value.getDayOfMonth());
        writer.writeEndDocument();
    }

    public LocalDate decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> CodecsUtil.readDocument(reader, decoderContext, FIELD_DECODERS), val -> LocalDate.of((int)CodecsUtil.getFieldValue(val, "year", Integer.class), CodecsUtil.getFieldValue(val, "month", Integer.class), (int)CodecsUtil.getFieldValue(val, "day", Integer.class)));
    }

    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }

    static {
        HashMap<String, Decoder> fd = new HashMap<String, Decoder>();
        fd.put("year", (r, dc) -> r.readInt32());
        fd.put("month", (r, dc) -> r.readInt32());
        fd.put("day", (r, dc) -> r.readInt32());
        FIELD_DECODERS = Collections.unmodifiableMap(fd);
    }
}

