/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.localdate;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.LocalDate;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class LocalDateAsStringCodec
implements Codec<LocalDate> {
    public void encode(BsonWriter writer, LocalDate value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeString(value.toString());
    }

    public LocalDate decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readString(), LocalDate::parse);
    }

    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }
}

