/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.localdatetime;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import io.github.cbartosiak.bson.codecs.jsr310.localdate.LocalDateAsDocumentCodec;
import io.github.cbartosiak.bson.codecs.jsr310.localtime.LocalTimeAsDocumentCodec;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class LocalDateTimeAsDocumentCodec
implements Codec<LocalDateTime> {
    private final Codec<LocalDate> localDateCodec;
    private final Codec<LocalTime> localTimeCodec;
    private final Map<String, Decoder<?>> fieldDecoders;

    public LocalDateTimeAsDocumentCodec() {
        this(new LocalDateAsDocumentCodec(), new LocalTimeAsDocumentCodec());
    }

    public LocalDateTimeAsDocumentCodec(Codec<LocalDate> localDateCodec, Codec<LocalTime> localTimeCodec) {
        this.localDateCodec = Objects.requireNonNull(localDateCodec, "localDateCodec is null");
        this.localTimeCodec = Objects.requireNonNull(localTimeCodec, "localTimeCodec is null");
        HashMap<String, Decoder> fd = new HashMap<String, Decoder>();
        fd.put("date", (arg_0, arg_1) -> localDateCodec.decode(arg_0, arg_1));
        fd.put("time", (arg_0, arg_1) -> localTimeCodec.decode(arg_0, arg_1));
        this.fieldDecoders = Collections.unmodifiableMap(fd);
    }

    public void encode(BsonWriter writer, LocalDateTime value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeStartDocument();
        writer.writeName("date");
        this.localDateCodec.encode(writer, (Object)value.toLocalDate(), encoderContext);
        writer.writeName("time");
        this.localTimeCodec.encode(writer, (Object)value.toLocalTime(), encoderContext);
        writer.writeEndDocument();
    }

    public LocalDateTime decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> CodecsUtil.readDocument(reader, decoderContext, this.fieldDecoders), val -> LocalDateTime.of(CodecsUtil.getFieldValue(val, "date", LocalDate.class), CodecsUtil.getFieldValue(val, "time", LocalTime.class)));
    }

    public Class<LocalDateTime> getEncoderClass() {
        return LocalDateTime.class;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalDateTimeAsDocumentCodec rhs = (LocalDateTimeAsDocumentCodec)obj;
        return this.localDateCodec.equals(rhs.localDateCodec) && this.localTimeCodec.equals(rhs.localTimeCodec) && this.fieldDecoders.equals(rhs.fieldDecoders);
    }

    public int hashCode() {
        int result = this.localDateCodec.hashCode();
        result = 31 * result + this.localTimeCodec.hashCode();
        result = 31 * result + this.fieldDecoders.hashCode();
        return result;
    }

    public String toString() {
        return "LocalDateTimeAsDocumentCodec[localDateCodec=" + this.localDateCodec + ",localTimeCodec=" + this.localTimeCodec + ",fieldDecoders=" + this.fieldDecoders + ']';
    }
}

