/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.localtime;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.LocalTime;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class LocalTimeAsInt64Codec
implements Codec<LocalTime> {
    public void encode(BsonWriter writer, LocalTime value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeInt64(value.toNanoOfDay());
    }

    public LocalTime decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readInt64(), LocalTime::ofNanoOfDay);
    }

    public Class<LocalTime> getEncoderClass() {
        return LocalTime.class;
    }
}

