/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.monthday;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.math.BigDecimal;
import java.time.MonthDay;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.types.Decimal128;

public final class MonthDayAsDecimal128Codec
implements Codec<MonthDay> {
    public void encode(BsonWriter writer, MonthDay value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        CodecsUtil.translateEncodeExceptions(() -> value, val -> writer.writeDecimal128(Decimal128.parse((String)String.format("%d.%02d", val.getMonthValue(), val.getDayOfMonth()))));
    }

    public MonthDay decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readDecimal128(), val -> {
            BigDecimal bigDecimal = val.bigDecimalValue();
            int month = bigDecimal.intValue();
            int day = bigDecimal.subtract(new BigDecimal(month)).scaleByPowerOfTen(2).intValue();
            return MonthDay.of(month, day);
        });
    }

    public Class<MonthDay> getEncoderClass() {
        return MonthDay.class;
    }
}

