/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.offsettime;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import io.github.cbartosiak.bson.codecs.jsr310.localtime.LocalTimeAsDocumentCodec;
import io.github.cbartosiak.bson.codecs.jsr310.zoneoffset.ZoneOffsetAsInt32Codec;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class OffsetTimeAsDocumentCodec
implements Codec<OffsetTime> {
    private final Codec<LocalTime> localTimeCodec;
    private final Codec<ZoneOffset> zoneOffsetCodec;
    private final Map<String, Decoder<?>> fieldDecoders;

    public OffsetTimeAsDocumentCodec() {
        this(new LocalTimeAsDocumentCodec(), new ZoneOffsetAsInt32Codec());
    }

    public OffsetTimeAsDocumentCodec(Codec<LocalTime> localTimeCodec, Codec<ZoneOffset> zoneOffsetCodec) {
        this.localTimeCodec = Objects.requireNonNull(localTimeCodec, "localTimeCodec is null");
        this.zoneOffsetCodec = Objects.requireNonNull(zoneOffsetCodec, "zoneOffsetCodec is null");
        HashMap<String, Decoder> fd = new HashMap<String, Decoder>();
        fd.put("time", (arg_0, arg_1) -> localTimeCodec.decode(arg_0, arg_1));
        fd.put("offset", (arg_0, arg_1) -> zoneOffsetCodec.decode(arg_0, arg_1));
        this.fieldDecoders = Collections.unmodifiableMap(fd);
    }

    public void encode(BsonWriter writer, OffsetTime value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeStartDocument();
        writer.writeName("time");
        this.localTimeCodec.encode(writer, (Object)value.toLocalTime(), encoderContext);
        writer.writeName("offset");
        this.zoneOffsetCodec.encode(writer, (Object)value.getOffset(), encoderContext);
        writer.writeEndDocument();
    }

    public OffsetTime decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> CodecsUtil.readDocument(reader, decoderContext, this.fieldDecoders), val -> OffsetTime.of(CodecsUtil.getFieldValue(val, "time", LocalTime.class), CodecsUtil.getFieldValue(val, "offset", ZoneOffset.class)));
    }

    public Class<OffsetTime> getEncoderClass() {
        return OffsetTime.class;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OffsetTimeAsDocumentCodec rhs = (OffsetTimeAsDocumentCodec)obj;
        return this.localTimeCodec.equals(rhs.localTimeCodec) && this.zoneOffsetCodec.equals(rhs.zoneOffsetCodec) && this.fieldDecoders.equals(rhs.fieldDecoders);
    }

    public int hashCode() {
        int result = this.localTimeCodec.hashCode();
        result = 31 * result + this.zoneOffsetCodec.hashCode();
        result = 31 * result + this.fieldDecoders.hashCode();
        return result;
    }

    public String toString() {
        return "OffsetTimeAsDocumentCodec[localTimeCodec=" + this.localTimeCodec + ",zoneOffsetCodec=" + this.zoneOffsetCodec + ",fieldDecoders=" + this.fieldDecoders + ']';
    }
}

