/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.yearmonth;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.YearMonth;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class YearMonthAsStringCodec
implements Codec<YearMonth> {
    public void encode(BsonWriter writer, YearMonth value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeString((value.getYear() > 9999 ? "+" : "") + value);
    }

    public YearMonth decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readString(), YearMonth::parse);
    }

    public Class<YearMonth> getEncoderClass() {
        return YearMonth.class;
    }
}

