/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.cdb;

import io.github.duckasteroid.cdb.CdbElementEnumeration;
import io.github.duckasteroid.cdb.CdbHash;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class Cdb
implements AutoCloseable {
    public static final int HASHTABLE_LENGTH = 2048;
    private final FileChannel fileChannel;
    private SlotEntry[] slotTable;
    private RandomAccessFile file;
    private int loop = 0;
    private long khash = 0L;
    private int hslots = 0;
    private long hpos = 0L;
    private long kpos = 0L;

    public Cdb(String filepath) throws IOException {
        this(new File(filepath));
    }

    public Cdb(File cdbFile) throws IOException {
        this.file = new RandomAccessFile(cdbFile, "r");
        this.fileChannel = this.file.getChannel();
        if (this.fileChannel.size() > 2048L) {
            ByteBuffer slotTableBuffer = ByteBuffer.allocateDirect(2048).order(ByteOrder.LITTLE_ENDIAN);
            int read = this.fileChannel.read(slotTableBuffer);
            if (read < 2048) {
                throw new IOException("Unable to read slot table");
            }
            slotTableBuffer.flip();
            this.slotTable = new SlotEntry[256];
            for (int i = 0; i < this.slotTable.length; ++i) {
                this.slotTable[i] = new SlotEntry(slotTableBuffer);
            }
        }
    }

    @Deprecated
    public static long hash(byte[] key) {
        return Cdb.hash(ByteBuffer.wrap(key));
    }

    public static long hash(ByteBuffer key) {
        return CdbHash.hash(key);
    }

    public static CdbElementEnumeration elements(SeekableByteChannel input) throws IOException {
        ByteBuffer eodBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        int read = input.read(eodBuffer);
        eodBuffer.flip();
        int eod = eodBuffer.getInt();
        long skipped = 2044L;
        input.position(input.position() + skipped);
        return new CdbElementEnumeration(input, eod);
    }

    public static CdbElementEnumeration elements(String filepath) throws IOException {
        return Cdb.elements(Files.newByteChannel(Paths.get(filepath, new String[0]), new OpenOption[0]));
    }

    @Override
    public final void close() throws IOException {
        try {
            this.file.close();
        }
        finally {
            this.file = null;
        }
    }

    public final synchronized void findstart() {
        this.loop = 0;
    }

    public final synchronized ByteBuffer find(ByteBuffer key) {
        this.findstart();
        return this.findnext(key);
    }

    public final synchronized ByteBuffer findnext(ByteBuffer key) {
        if (this.slotTable == null) {
            return null;
        }
        if (this.loop == 0) {
            long u = CdbHash.hash(key);
            key.clear();
            int index = (int)(u % 256L);
            SlotEntry slot = this.slotTable[index];
            this.hslots = slot.length;
            if (this.hslots == 0) {
                return null;
            }
            this.hpos = slot.position;
            this.khash = u;
            u >>>= 8;
            u %= (long)this.hslots;
            this.kpos = this.hpos + (u <<= 3);
        }
        try {
            ByteBuffer local = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            while (this.loop < this.hslots) {
                this.fileChannel.position(this.kpos);
                local.clear();
                this.fileChannel.read(local);
                local.flip();
                int h = local.getInt();
                int pos = local.getInt();
                if (pos == 0) {
                    return null;
                }
                ++this.loop;
                this.kpos += 8L;
                if (this.kpos == this.hpos + (long)(this.hslots << 3)) {
                    this.kpos = this.hpos;
                }
                if (h != (int)this.khash) continue;
                this.fileChannel.position(pos);
                local.clear();
                this.fileChannel.read(local);
                local.flip();
                int klen = local.getInt();
                if (klen != key.remaining()) continue;
                int dlen = local.getInt();
                ByteBuffer k = ByteBuffer.allocate(klen);
                this.fileChannel.read(k);
                k.flip();
                if (!key.equals(k)) continue;
                ByteBuffer d = ByteBuffer.allocate(dlen);
                this.fileChannel.read(d);
                d.flip();
                return d;
            }
        }
        catch (IOException ignored) {
            return null;
        }
        return null;
    }

    static class SlotEntry {
        public final int position;
        public final int length;

        SlotEntry(ByteBuffer byteBuffer) {
            this.position = byteBuffer.getInt();
            this.length = byteBuffer.getInt();
        }
    }
}

