/*
 * Decompiled with CFR 0.152.
 */
package io.github.etuzon.unit.tests.asserts;

import java.util.logging.Logger;
import org.testng.Assert;

public class SoftAssertUnitTest {
    private static final Logger logger = Logger.getLogger(SoftAssertUnitTest.class.getName());
    private static String errors = "";
    private static InfoMessageLogLevelEnum infoMessageLevel = InfoMessageLogLevelEnum.INFO;

    public static void assertTrueNow(boolean condition, String errorMessage) {
        SoftAssertUnitTest.assertTrue(condition, errorMessage);
        SoftAssertUnitTest.assertAll();
    }

    public static void assertTrueNow(boolean condition, String errorMessage, String infoMessage) {
        SoftAssertUnitTest.assertTrue(condition, errorMessage, infoMessage);
        SoftAssertUnitTest.assertAll();
    }

    public static void assertNotNullNow(Object object, String errorMessage) {
        SoftAssertUnitTest.assertNotNullNow(object, errorMessage, null);
    }

    public static void assertNotNullNow(Object object, String errorMessage, String infoMessage) {
        SoftAssertUnitTest.assertNotNull(object, errorMessage, infoMessage);
        SoftAssertUnitTest.assertAll();
    }

    public static void failNow(String errorMessage) {
        SoftAssertUnitTest.assertTrueNow(false, errorMessage);
    }

    public static boolean assertNotNull(Object object, String errorMessage) {
        return SoftAssertUnitTest.assertNotNull(object, errorMessage, null);
    }

    public static boolean assertNotNull(Object object, String errorMessage, String infoMessage) {
        return SoftAssertUnitTest.assertTrue(object != null, errorMessage, infoMessage);
    }

    public static boolean assertTrue(boolean condition, String errorMessage) {
        return SoftAssertUnitTest.assertTrue(condition, errorMessage, null);
    }

    public static boolean assertTrue(boolean condition, String errorMessage, String infoMessage) {
        if (infoMessage != null) {
            SoftAssertUnitTest.printInfoMessage(infoMessage);
        }
        if (!condition) {
            errorMessage = "[Assertion Error] " + (String)errorMessage;
            logger.severe((String)errorMessage);
            if (!errors.isEmpty()) {
                errors = errors + "\n";
            }
            errors = errors + (String)errorMessage;
        }
        return condition;
    }

    public static void fail(String errorMessage) {
        SoftAssertUnitTest.assertTrue(false, errorMessage);
    }

    public static void assertAll() {
        String temp = errors;
        errors = "";
        Assert.assertTrue((boolean)temp.isEmpty(), (String)temp);
    }

    public static String getCurrentErrors() {
        return errors;
    }

    public static String emptyErrors() {
        String temp = errors;
        errors = "";
        return temp;
    }

    public static void setInfoMessageLogLevel(InfoMessageLogLevelEnum level) {
        infoMessageLevel = level;
    }

    private static void printInfoMessage(String message) {
        if (infoMessageLevel == InfoMessageLogLevelEnum.TRACE) {
            logger.fine(message);
        } else if (infoMessageLevel == InfoMessageLogLevelEnum.DEBUG) {
            logger.fine(message);
        } else if (infoMessageLevel == InfoMessageLogLevelEnum.INFO) {
            logger.info(message);
        }
    }

    public static enum InfoMessageLogLevelEnum {
        TRACE,
        DEBUG,
        INFO;

    }
}

