/*
 * Decompiled with CFR 0.152.
 */
package io.github.etuzon.unit.tests.base;

import io.github.etuzon.unit.tests.asserts.SoftAssertUnitTest;
import io.github.etuzon.unit.tests.exceptions.InvalidUnitTestException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class BaseUnitTest {
    public static final String CLASS_SEPARATOR = "================================================================";
    private final Logger logger = Logger.getLogger(BaseUnitTest.class.getName());

    protected BaseUnitTest() {
    }

    @BeforeClass
    public void beforeClassBaseTest() {
        this.logger.info("\n================================================================\nStarting Class [" + super.getClass().getSimpleName() + "]\n================================================================");
    }

    @BeforeMethod
    public void beforeMethodBaseTest(Method method) {
        this.logger.info("Starting Test [" + super.getClass().getSimpleName() + "." + method.getName() + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AfterMethod
    public void afterMethodBaseTest(ITestResult result) throws InvalidUnitTestException {
        String errors = SoftAssertUnitTest.emptyErrors();
        if (result.isSuccess()) {
            if (!errors.isEmpty()) throw new InvalidUnitTestException(this.getInvalidTestExceptionMessage(result, errors));
            this.logger.info("Test [" + super.getClass().getSimpleName() + "." + result.getName() + "] PASSED");
            return;
        } else {
            this.logger.info("Test [" + super.getClass().getSimpleName() + "." + result.getTestName() + "] FAILED");
            if (SoftAssertUnitTest.emptyErrors().isEmpty()) return;
            throw new InvalidUnitTestException(this.getInvalidTestExceptionMessage(result, errors));
        }
    }

    private String getInvalidTestExceptionMessage(ITestResult result, String errors) {
        return "Missing SoftAssert.assertAll() in test [" + super.getClass().getSimpleName() + "." + result.getName() + "]\nAssert error list:\n" + errors;
    }
}

