/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log.util;

import nl.altindag.log.exception.LogCaptorException;
import org.slf4j.Logger;

final class ValidationUtils {
    private ValidationUtils() {
    }

    static <T extends Logger, U extends Logger> void requireLoggerOfType(T actualLogger, Class<U> requiredLogger) {
        if (actualLogger == null || !requiredLogger.getCanonicalName().equals(actualLogger.getClass().getCanonicalName())) {
            String actualLoggerType = actualLogger != null ? actualLogger.getClass().getName() : "nothing";
            throw new LogCaptorException(String.format("SLF4J Logger implementation should be of the type [%s] but found [%s].", requiredLogger.getName(), actualLoggerType));
        }
        if (!requiredLogger.isInstance(actualLogger)) {
            throw new LogCaptorException(String.format("Multiple classloaders are being used. The Logging API is created by the following classloader: [%s], while it should have been created by the following classloader: [%s].", actualLogger.getClass().getClassLoader().getClass().getName(), requiredLogger.getClassLoader().getClass().getName()));
        }
    }
}

