/*
 * Decompiled with CFR 0.152.
 */
package io.github.hzpz.spring.boot.autoconfigure.mongeez;

import com.mongodb.Mongo;
import io.github.hzpz.spring.boot.autoconfigure.mongeez.MongeezProperties;
import io.github.hzpz.spring.boot.autoconfigure.mongeez.MongoDbFactoryDependsOnPostProcessor;
import javax.annotation.PostConstruct;
import org.mongeez.Mongeez;
import org.mongeez.MongeezRunner;
import org.mongeez.MongoAuth;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Mongeez.class})
@ConditionalOnBean(value={Mongo.class})
@ConditionalOnProperty(prefix="mongeez", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MongoProperties.class, MongeezProperties.class})
@AutoConfigureAfter(value={MongoAutoConfiguration.class})
@AutoConfigureBefore(name={"org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration", "org.springframework.boot.autoconfigure.mongo.MongoDataAutoConfiguration"})
public class MongeezAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={MongoDbFactory.class})
    protected static class MongeezDataMongoDependencyConfiguration {
        protected MongeezDataMongoDependencyConfiguration() {
        }

        @Bean
        public static BeanFactoryPostProcessor mongoDbFactoryDependsOnPostProcessor() {
            return new MongoDbFactoryDependsOnPostProcessor("mongeez");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={MongeezRunner.class})
    @EnableConfigurationProperties(value={MongeezProperties.class})
    @Import(value={MongeezDataMongoDependencyConfiguration.class})
    public static class MongeezConfiguration {
        @Autowired
        private MongeezProperties mongeezProperties = new MongeezProperties();
        private ResourceLoader resourceLoader = new DefaultResourceLoader();

        @PostConstruct
        public void checkLocationExists() {
            Resource resource = this.resourceLoader.getResource(this.mongeezProperties.getLocation());
            Assert.state((boolean)resource.exists(), (String)("Cannot find Mongeez migration script at '" + this.mongeezProperties.getLocation() + "'"));
        }

        @Bean(initMethod="process")
        public Mongeez mongeez(MongoProperties mongoProperties, Mongo mongo) {
            Mongeez mongeez = new Mongeez();
            mongeez.setMongo(mongo);
            this.copyMissingProperties(mongoProperties, this.mongeezProperties);
            mongeez.setDbName(this.mongeezProperties.getDatabase());
            if (this.mongeezProperties.hasCredentials()) {
                MongoAuth auth = this.mongeezProperties.createMongoAuth();
                mongeez.setAuth(auth);
            }
            mongeez.setFile(this.resourceLoader.getResource(this.mongeezProperties.getLocation()));
            return mongeez;
        }

        private void copyMissingProperties(MongoProperties mongoProperties, MongeezProperties mongeezProperties) {
            if (StringUtils.isEmpty((Object)mongeezProperties.getDatabase())) {
                mongeezProperties.setDatabase(mongoProperties.getMongoClientDatabase());
            }
            if (StringUtils.isEmpty((Object)mongeezProperties.getAuthenticationDatabase())) {
                mongeezProperties.setAuthenticationDatabase(mongoProperties.getAuthenticationDatabase());
            }
            if (!mongeezProperties.hasCredentials() && this.hasCredentials(mongoProperties)) {
                String msg = "Found credentials for Spring Data MongoDB but no credentials for Mongeez. You need to define both for authentication to work.";
                throw new BeanCreationException(msg);
            }
        }

        private boolean hasCredentials(MongoProperties properties) {
            return properties.getUsername() != null && properties.getPassword() != null;
        }
    }
}

