/*
 * Decompiled with CFR 0.152.
 */
package io.github.hzpz.spring.boot.autoconfigure.mongeez;

import java.lang.reflect.Constructor;
import org.mongeez.MongoAuth;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.util.ReflectionUtils;

@ConfigurationProperties(prefix="mongeez", ignoreUnknownFields=true)
public class MongeezProperties {
    private String location = "db/mongeez.xml";
    private boolean enabled = true;
    private String username;
    private char[] password;
    private String database;
    private String authenticationDatabase;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getAuthenticationDatabase() {
        return this.authenticationDatabase;
    }

    public void setAuthenticationDatabase(String authenticationDatabase) {
        this.authenticationDatabase = authenticationDatabase;
    }

    public boolean hasCredentials() {
        return this.username != null && this.password != null;
    }

    public void clearPassword() {
        if (this.password == null) {
            return;
        }
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
    }

    public MongoAuth createMongoAuth() {
        String authDb = this.authenticationDatabase == null ? this.database : this.authenticationDatabase;
        try {
            MongoAuth mongoAuth = this.instantiateMongoAuth(this.username, String.valueOf(this.password), authDb);
            return mongoAuth;
        }
        finally {
            this.clearPassword();
        }
    }

    private MongoAuth instantiateMongoAuth(String username, String password, String authDb) {
        Constructor constructor = ReflectionUtils.findConstructor(MongoAuth.class, (Object[])new Object[]{username, password, authDb});
        if (constructor != null) {
            return (MongoAuth)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{username, password, authDb});
        }
        constructor = ReflectionUtils.findConstructor(MongoAuth.class, (Object[])new Object[]{username, password});
        if (constructor != null) {
            return (MongoAuth)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{username, password});
        }
        throw new IllegalStateException("No suitable constructor found to instantiate MongoAuth. Are you using a supported Mongeez version?");
    }
}

