/*
 * Decompiled with CFR 0.152.
 */
package io.github.hzpz.spring.boot.autoconfigure.mongeez;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.util.StringUtils;

public class MongoDbFactoryDependsOnPostProcessor
implements BeanFactoryPostProcessor {
    private final String dependsOn;

    public MongoDbFactoryDependsOnPostProcessor(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        for (String beanName : this.getMongoDbFactoryBeanNames((ListableBeanFactory)beanFactory)) {
            BeanDefinition definition = MongoDbFactoryDependsOnPostProcessor.getBeanDefinition(beanName, beanFactory);
            definition.setDependsOn(StringUtils.addStringToArray((String[])definition.getDependsOn(), (String)this.dependsOn));
        }
    }

    private static BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
            if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                return MongoDbFactoryDependsOnPostProcessor.getBeanDefinition(beanName, (ConfigurableListableBeanFactory)parentBeanFactory);
            }
            throw ex;
        }
    }

    private String[] getMongoDbFactoryBeanNames(ListableBeanFactory beanFactory) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, MongoDbFactory.class, (boolean)true, (boolean)false);
    }
}

