/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration;

import io.github.kbuntrock.configuration.CommonApiConfiguration;
import io.github.kbuntrock.configuration.OperationIdHelper;
import io.github.kbuntrock.configuration.library.Library;
import io.github.kbuntrock.configuration.library.TagAnnotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class ApiConfiguration
extends CommonApiConfiguration {
    private static final String DEFAULT_FILENAME = "spec-open-api.yml";
    @Parameter(required=true)
    private List<String> locations;
    @Parameter
    private String filename = "spec-open-api.yml";
    protected String baseFreeField;
    @Parameter
    private boolean mergeFreeFields;
    private OperationIdHelper operationIdHelper;

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public OperationIdHelper getOperationIdHelper() {
        return this.operationIdHelper;
    }

    public void setOperationIdHelper(OperationIdHelper operationIdHelper) {
        this.operationIdHelper = operationIdHelper;
    }

    public boolean isMergeFreeFields() {
        return this.mergeFreeFields;
    }

    public void setMergeFreeFields(boolean mergeFreeFields) {
        this.mergeFreeFields = mergeFreeFields;
    }

    public String getBaseFreeField() {
        return this.baseFreeField;
    }

    public ApiConfiguration mergeWithCommonApiConfiguration(CommonApiConfiguration commonApiConfiguration) {
        CommonApiConfiguration copy = new CommonApiConfiguration(commonApiConfiguration);
        ApiConfiguration merged = new ApiConfiguration();
        merged.tag = copy.tag;
        merged.operation = copy.operation;
        merged.attachArtifact = copy.attachArtifact;
        merged.defaultSuccessfulOperationDescription = copy.defaultSuccessfulOperationDescription;
        merged.defaultProduceConsumeGuessing = copy.defaultProduceConsumeGuessing;
        merged.pathEnhancement = copy.pathEnhancement;
        merged.pathPrefix = copy.pathPrefix;
        merged.fileFormat = copy.fileFormat;
        merged.loopbackOperationName = copy.loopbackOperationName;
        merged.operationId = copy.operationId;
        merged.freeFields = copy.freeFields;
        merged.library = copy.library;
        merged.tagAnnotations = copy.tagAnnotations;
        merged.whiteList = copy.whiteList;
        merged.blackList = copy.blackList;
        merged.enumConfigList = copy.enumConfigList;
        merged.extraSchemaClasses = copy.extraSchemaClasses;
        merged.customResponseTypeAnnotation = copy.customResponseTypeAnnotation;
        merged.defaultErrors = copy.defaultErrors;
        merged.openapiModels = copy.openapiModels;
        merged.modelsAssociations = copy.modelsAssociations;
        merged.defaultNonNullableFields = copy.defaultNonNullableFields;
        merged.nonNullableAnnotation = copy.nonNullableAnnotation;
        merged.nullableAnnotation = copy.nullableAnnotation;
        merged.nonDocumentableParameterClasses = copy.nonDocumentableParameterClasses;
        merged.setLocations(this.locations);
        merged.setFilename(this.filename);
        merged.setMergeFreeFields(this.mergeFreeFields);
        if (!this.tag.getSubstitutions().isEmpty()) {
            merged.getTag().setSubstitutions(this.tag.getSubstitutions());
        }
        if (!this.operation.getSubstitutions().isEmpty()) {
            merged.getOperation().setSubstitutions(this.operation.getSubstitutions());
        }
        if (this.attachArtifact != null) {
            merged.setAttachArtifact(this.attachArtifact);
        }
        if (this.defaultSuccessfulOperationDescription != null) {
            merged.setDefaultSuccessfulOperationDescription(this.defaultSuccessfulOperationDescription);
        }
        if (this.defaultProduceConsumeGuessing != null) {
            merged.setDefaultProduceConsumeGuessing(this.defaultProduceConsumeGuessing);
        }
        if (this.pathEnhancement != null) {
            merged.setPathEnhancement(this.pathEnhancement);
        }
        if (this.pathPrefix != null) {
            merged.setPathPrefix(this.pathPrefix);
        }
        if (this.fileFormat != null) {
            merged.setFileFormat(this.fileFormat);
        }
        if ("json".equals(merged.fileFormat) && DEFAULT_FILENAME.equals(merged.filename)) {
            merged.filename = DEFAULT_FILENAME.replace(".yml", ".json");
        }
        if (this.loopbackOperationName != null) {
            merged.setLoopbackOperationName(this.loopbackOperationName);
        }
        if (this.operationId != null) {
            merged.setOperationId(this.operationId);
        }
        if (this.library != null) {
            merged.setLibrary(this.library);
        }
        if (this.tagAnnotations != null && !this.tagAnnotations.isEmpty()) {
            merged.setTagAnnotations(this.tagAnnotations);
        } else if (Library.JAVAX_RS.name().equals(merged.getLibrary().toString().toUpperCase())) {
            merged.setTagAnnotations(new ArrayList<String>());
            merged.getTagAnnotations().add(TagAnnotation.JAVAX_RS_PATH.getAnnotationClassName());
        } else if (Library.JAKARTA_RS.name().equals(merged.getLibrary().toString().toUpperCase())) {
            merged.setTagAnnotations(new ArrayList<String>());
            merged.getTagAnnotations().add(TagAnnotation.JAKARTA_RS_PATH.getAnnotationClassName());
        }
        if (this.freeFields != null) {
            merged.setFreeFields(this.freeFields);
            if (this.mergeFreeFields && commonApiConfiguration.freeFields != null) {
                merged.baseFreeField = commonApiConfiguration.freeFields;
            }
        }
        if (this.whiteList != null) {
            merged.setWhiteList(this.whiteList);
        }
        if (this.blackList != null) {
            merged.setBlackList(this.blackList);
        }
        if (this.extraSchemaClasses != null && !this.extraSchemaClasses.isEmpty()) {
            merged.setExtraSchemaClasses(this.extraSchemaClasses);
        }
        if (this.customResponseTypeAnnotation != null) {
            merged.setCustomResponseTypeAnnotation(this.customResponseTypeAnnotation);
        }
        if (this.defaultErrors != null) {
            merged.setDefaultErrors(this.defaultErrors);
        }
        if (this.openapiModels != null) {
            merged.setOpenapiModels(this.openapiModels);
        }
        if (this.modelsAssociations != null) {
            merged.setModelsAssociations(this.modelsAssociations);
        }
        if (this.defaultNonNullableFields != null) {
            merged.setDefaultNonNullableFields(this.defaultNonNullableFields);
        }
        if (this.nonNullableAnnotation != null) {
            merged.setNonNullableAnnotation(this.nonNullableAnnotation);
        }
        if (this.nullableAnnotation != null) {
            merged.setNullableAnnotation(this.nullableAnnotation);
        }
        merged.operationIdHelper = new OperationIdHelper(merged.operationId);
        for (int i = 0; i < merged.tagAnnotations.size(); ++i) {
            if ("requestmapping".equals(((String)merged.tagAnnotations.get(i)).toLowerCase())) {
                merged.tagAnnotations.set(i, TagAnnotation.SPRING_MVC_REQUEST_MAPPING.getAnnotationClassName());
                continue;
            }
            if (!"restcontroller".equals(((String)merged.tagAnnotations.get(i)).toLowerCase())) continue;
            merged.tagAnnotations.set(i, TagAnnotation.SPRING_REST_CONTROLLER.getAnnotationClassName());
        }
        if (this.nonDocumentableParameterClasses != null) {
            merged.setNonDocumentableParameterClasses(this.nonDocumentableParameterClasses);
        }
        return merged;
    }
}

