/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.GenericityResolver;
import io.github.kbuntrock.utils.Logger;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import io.github.kbuntrock.utils.UnwrappingType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;

public abstract class AstractLibraryReader {
    protected final Log logger = Logger.INSTANCE.getLogger();
    protected final ApiConfiguration apiConfiguration;
    protected final GenericityResolver genericityResolver = new GenericityResolver();

    public AstractLibraryReader(ApiConfiguration apiConfiguration) {
        this.apiConfiguration = apiConfiguration;
    }

    protected static String concatenateBasePathAndMethodPath(String basePath, String methodPath, boolean automaticSeparator) {
        String result = basePath + methodPath;
        if (automaticSeparator) {
            if (!(methodPath.isEmpty() || methodPath.startsWith("/") || basePath.endsWith("/"))) {
                result = basePath + "/" + methodPath;
            }
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
        }
        return result;
    }

    protected DataObject readResponseObject(Class clazz, Method method, MergedAnnotations mergedAnnotations) {
        Class<?> returnType = method.getReturnType();
        if (Void.class == returnType || Void.TYPE == returnType) {
            return null;
        }
        DataObject dataObject = new DataObject(this.genericityResolver.resolve(clazz, this.readResponseMethodType(method, mergedAnnotations)));
        dataObject = this.computeFrameworkReturnObject(dataObject);
        this.logger.debug((CharSequence)dataObject.toString());
        return dataObject;
    }

    protected Type readResponseMethodType(Method method, MergedAnnotations mergedAnnotations) {
        return method.getGenericReturnType();
    }

    private DataObject computeFrameworkReturnObject(DataObject dataObject) {
        return OpenApiTypeResolver.INSTANCE.unwrapDataObject(dataObject, UnwrappingType.RESPONSE);
    }

    protected boolean isDeprecated(Method originalMethod) {
        Set overridenMethods = MethodUtils.getOverrideHierarchy((Method)originalMethod, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
        for (Method method : overridenMethods) {
            if (method.getDeclaredAnnotation(Deprecated.class) == null) continue;
            return true;
        }
        return false;
    }

    public abstract List<String> readBasePaths(Class<?> var1, MergedAnnotations var2);

    public abstract void computeAnnotations(Class var1, String var2, Method var3, MergedAnnotations var4, Tag var5) throws MojoFailureException;

    protected abstract List<ParameterObject> readParameters(Class var1, Method var2);

    protected abstract List<String> readEndpointPaths(String var1, MergedAnnotation<? extends Annotation> var2);

    protected abstract void setConsumeProduceProperties(Endpoint var1, MergedAnnotations var2) throws MojoFailureException;

    protected abstract int readResponseCode(MergedAnnotations var1);

    protected ParameterObject unwrapParameterObject(ParameterObject parameterObject) {
        DataObject dataObject = OpenApiTypeResolver.INSTANCE.unwrapDataObject((DataObject)parameterObject, UnwrappingType.PARAMETER);
        if (parameterObject == dataObject) {
            return parameterObject;
        }
        return new ParameterObject(parameterObject.getName(), dataObject);
    }
}

