/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.TagLibrary;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.parser.CommonParserUtils;
import io.github.kbuntrock.configuration.parser.JsonParserUtils;
import io.github.kbuntrock.javadoc.ClassDocumentation;
import io.github.kbuntrock.javadoc.JavadocMap;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.AdditionnalSchemaLibrary;
import io.github.kbuntrock.utils.Logger;
import io.github.kbuntrock.utils.OpenApiConstants;
import io.github.kbuntrock.utils.OpenApiDataType;
import io.github.kbuntrock.utils.ParameterLocation;
import io.github.kbuntrock.utils.ProduceConsumeUtils;
import io.github.kbuntrock.yaml.model.Content;
import io.github.kbuntrock.yaml.model.Info;
import io.github.kbuntrock.yaml.model.Operation;
import io.github.kbuntrock.yaml.model.ParameterElement;
import io.github.kbuntrock.yaml.model.Property;
import io.github.kbuntrock.yaml.model.RequestBody;
import io.github.kbuntrock.yaml.model.Response;
import io.github.kbuntrock.yaml.model.Schema;
import io.github.kbuntrock.yaml.model.Server;
import io.github.kbuntrock.yaml.model.Specification;
import io.github.kbuntrock.yaml.model.TagElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class YamlWriter {
    private static final String SERVERS_FIELD = "servers";
    private static final String SECURITY_FIELD = "security";
    private static final String EXTERNAL_DOC_FIELD = "externalDocs";
    private static final String FILEFORMAT_JSON = "json";
    private final Log logger = Logger.INSTANCE.getLogger();
    private final ObjectMapper om;
    private final ApiConfiguration apiConfiguration;
    private final MavenProject mavenProject;
    private Optional<JsonNode> freefields = Optional.empty();
    private Map<String, JsonNode> defaultErrors;

    public YamlWriter(MavenProject mavenProject, ApiConfiguration apiConfiguration) {
        this.apiConfiguration = apiConfiguration;
        this.mavenProject = mavenProject;
        this.om = FILEFORMAT_JSON.equals(apiConfiguration.getFileFormat()) ? new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT) : new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR));
    }

    private void populateSpecificationFreeFields(Specification specification, Optional<JsonNode> freefields) {
        if (freefields.isPresent() && freefields.get().get(SERVERS_FIELD) != null) {
            specification.setServers(freefields.get().get(SERVERS_FIELD));
        } else {
            Server server = new Server();
            server.setUrl("");
            specification.setServers(Collections.singletonList(server));
        }
        if (freefields.isPresent()) {
            if (freefields.get().get(SECURITY_FIELD) != null) {
                specification.setSecurity(freefields.get().get(SECURITY_FIELD));
            }
            if (freefields.get().get(EXTERNAL_DOC_FIELD) != null) {
                specification.setExternalDocs(freefields.get().get(EXTERNAL_DOC_FIELD));
            }
        }
    }

    private String computeFreeFields(MavenProject mavenProject, ApiConfiguration apiConfiguration) {
        if (apiConfiguration.isMergeFreeFields() && apiConfiguration.getBaseFreeField() != null) {
            String baseContent = CommonParserUtils.getContentFromFileOrText(mavenProject, apiConfiguration.getBaseFreeField());
            String mergingContent = CommonParserUtils.getContentFromFileOrText(mavenProject, apiConfiguration.getFreeFields());
            return JsonParserUtils.merge(baseContent, mergingContent);
        }
        return CommonParserUtils.getContentFromFileOrText(mavenProject, apiConfiguration.getFreeFields());
    }

    public void write(File file, TagLibrary tagLibrary) throws IOException {
        this.freefields = JsonParserUtils.parse(this.computeFreeFields(this.mavenProject, this.apiConfiguration));
        Optional<JsonNode> defaultErrorsNode = JsonParserUtils.parse(CommonParserUtils.getContentFromFileOrText(this.mavenProject, this.apiConfiguration.getDefaultErrors()));
        if (defaultErrorsNode.isPresent()) {
            this.defaultErrors = new LinkedHashMap<String, JsonNode>();
            Iterator iterator = defaultErrorsNode.get().fields();
            iterator.forEachRemaining(entry -> this.defaultErrors.put((String)entry.getKey(), (JsonNode)entry.getValue()));
        }
        Specification specification = new Specification();
        Info info = new Info(this.mavenProject.getName(), this.mavenProject.getVersion(), this.freefields);
        specification.setInfo(info);
        this.populateSpecificationFreeFields(specification, this.freefields);
        specification.setTags(tagLibrary.getSortedTags().stream().map(x -> {
            if (JavadocMap.INSTANCE.isPresent()) {
                ClassDocumentation classDocumentation = JavadocMap.INSTANCE.getJavadocMap().get(x.getClazz().getCanonicalName());
                if (classDocumentation == null) {
                    classDocumentation = new ClassDocumentation(x.getClazz().getCanonicalName(), x.getClazz().getSimpleName());
                    JavadocMap.INSTANCE.getJavadocMap().put(x.getClazz().getCanonicalName(), classDocumentation);
                }
                this.logger.debug((CharSequence)("Class documentation found for tag " + x.getClazz().getSimpleName() + " ? " + (classDocumentation != null)));
                classDocumentation.inheritanceEnhancement(x.getClazz(), ClassDocumentation.EnhancementType.METHODS);
                Optional<String> description = classDocumentation.getDescription();
                if (description.isPresent()) {
                    return new TagElement(x.computeConfiguredName(this.apiConfiguration), description.get());
                }
            }
            return new TagElement(x.computeConfiguredName(this.apiConfiguration), null);
        }).collect(Collectors.toList()));
        specification.setPaths(this.createPaths(tagLibrary));
        Map<String, Object> schemaSection = this.createSchemaSection(tagLibrary);
        boolean schemaSectionCreated = false;
        if (!schemaSection.isEmpty()) {
            specification.getComponents().put("schemas", schemaSection);
            schemaSectionCreated = true;
        }
        if (this.freefields.isPresent() && this.freefields.get().get("components") != null) {
            JsonNode componentsNode = this.freefields.get().get("components");
            if (componentsNode.get("schemas") != null) {
                if (schemaSectionCreated) {
                    Map createdSchema = (Map)specification.getComponents().get("schemas");
                    Iterator iterator = componentsNode.get("schemas").fields();
                    iterator.forEachRemaining(entry -> createdSchema.put((String)entry.getKey(), entry.getValue()));
                } else {
                    specification.getComponents().put("schemas", componentsNode.get("schemas"));
                }
            }
            for (String section : OpenApiConstants.COMPONENTS_STRUCTURE) {
                if (componentsNode.get(section) == null) continue;
                specification.getComponents().put(section, componentsNode.get(section));
            }
        }
        this.om.writeValue(file, (Object)specification);
    }

    private Map<String, Map<String, Operation>> createPaths(TagLibrary tagLibrary) {
        LinkedHashMap<String, Map<String, Operation>> paths = new LinkedHashMap<String, Map<String, Operation>>();
        HashSet<String> operationIds = new HashSet<String>();
        for (Tag tag : tagLibrary.getSortedTags()) {
            ClassDocumentation classDocumentation = JavadocMap.INSTANCE.isPresent() ? JavadocMap.INSTANCE.getJavadocMap().get(tag.getClazz().getCanonicalName()) : null;
            this.logger.debug((CharSequence)("Class documentation found for tag paths section " + tag.getClazz().getSimpleName() + " ? " + (classDocumentation != null)));
            ArrayList<Operation> operations = new ArrayList<Operation>();
            for (Endpoint endpoint : tag.getSortedEndpoints()) {
                Object requestBodyContent;
                Iterator<String> queryParamBindingClassDoc;
                String description;
                Optional<JavadocBlockTag> parameterDoc;
                String enhancedPath = this.apiConfiguration.getPathPrefix() + endpoint.getPath();
                paths.computeIfAbsent(enhancedPath, k -> new LinkedHashMap());
                Operation operation = new Operation();
                operations.add(operation);
                operation.setName(endpoint.getType().name());
                operation.setPath(enhancedPath);
                String computedTagName = tag.computeConfiguredName(this.apiConfiguration);
                operation.getTags().add(computedTagName);
                operation.setOperationId(this.apiConfiguration.getOperationIdHelper().toOperationId(tag.getName(), computedTagName, endpoint.getName()));
                if (this.apiConfiguration.isLoopbackOperationName()) {
                    operation.setLoopbackOperationName(endpoint.getName());
                }
                operation.setDeprecated(endpoint.isDeprecated());
                JavadocWrapper methodJavadoc = null;
                if (classDocumentation != null) {
                    methodJavadoc = classDocumentation.getMethodsJavadoc().get(endpoint.getIdentifier());
                    if (methodJavadoc != null) {
                        methodJavadoc.sortTags();
                        operation.setDescription(methodJavadoc.getJavadoc().getDescription().toText());
                    }
                    this.logger.debug((CharSequence)("Method documentation found for endpoint method " + endpoint.getIdentifier() + " ? " + (methodJavadoc != null)));
                }
                if (!operation.getPath().startsWith("/")) {
                    Logger.INSTANCE.getLogger().warn((CharSequence)("Operation " + operation.getOperationId() + " path should start with a \"/\" (" + operation.getPath() + ")"));
                }
                if (!operationIds.add(operation.getOperationId())) {
                    Logger.INSTANCE.getLogger().warn((CharSequence)("Operation id \"" + operation.getOperationId() + "\" (" + tag.getName() + ") should be unique"));
                }
                for (ParameterObject parameter : endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY != x.getLocation()).collect(Collectors.toList())) {
                    ParameterElement parameterElement = new ParameterElement();
                    parameterElement.setName(parameter.getName());
                    parameterElement.setIn(parameter.getLocation().toString().toLowerCase(Locale.ENGLISH));
                    parameterElement.setRequired(parameter.isRequired());
                    Property schema = new Property(Content.fromDataObject(parameter).getSchema());
                    if (OpenApiDataType.ARRAY == parameter.getOpenApiResolvedType().getType() && ParameterLocation.PATH == parameter.getLocation()) {
                        this.logger.warn((CharSequence)("Array types in path or query parameter are not allowed : " + endpoint.getPath() + " - " + (Object)((Object)endpoint.getType())));
                    }
                    parameterElement.setSchema(schema);
                    if (methodJavadoc != null) {
                        parameterDoc = methodJavadoc.getParamBlockTagByName(parameter.getJavadocFieldName());
                        if (parameterDoc.isPresent() && !(description = parameterDoc.get().getContent().toText()).isEmpty()) {
                            parameterElement.setDescription(parameterDoc.get().getContent().toText());
                        }
                        this.logger.debug((CharSequence)("Parameter documentation found for endpoint parameter " + parameterElement.getName() + " ? " + parameterDoc.isPresent()));
                    }
                    if (parameter.getJavadocFieldClassName() != null) {
                        Iterator<String> iterator = queryParamBindingClassDoc = JavadocMap.INSTANCE.isPresent() ? JavadocMap.INSTANCE.getJavadocMap().get(parameter.getJavadocFieldClassName()) : null;
                        if (queryParamBindingClassDoc != null) {
                            ((ClassDocumentation)((Object)queryParamBindingClassDoc)).inheritanceEnhancement(parameter.getJavaClass(), ClassDocumentation.EnhancementType.BOTH);
                            JavadocWrapper javadocParamWrapper = ((ClassDocumentation)((Object)queryParamBindingClassDoc)).getFieldsJavadoc().get(parameterElement.getName());
                            if (javadocParamWrapper != null) {
                                Optional<String> desc = javadocParamWrapper.getDescription();
                                parameterElement.setDescription(desc.get());
                            }
                        }
                    }
                    operation.getParameters().add(parameterElement);
                }
                List<ParameterObject> bodies = endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY == x.getLocation()).collect(Collectors.toList());
                if (bodies.size() > 1 && !YamlWriter.isFormData(bodies)) {
                    this.logger.warn((CharSequence)("More than one body is not allowed : " + endpoint.getPath() + " - " + (Object)((Object)endpoint.getType())));
                }
                if (!bodies.isEmpty()) {
                    RequestBody requestBody = new RequestBody();
                    operation.setRequestBody(requestBody);
                    ParameterObject body = bodies.get(0);
                    Object object = requestBodyContent = YamlWriter.isFormData(bodies) ? Content.fromMultipartBodies(bodies) : Content.fromDataObject(body);
                    if (body.getFormats() != null) {
                        queryParamBindingClassDoc = body.getFormats().iterator();
                        while (queryParamBindingClassDoc.hasNext()) {
                            String format = queryParamBindingClassDoc.next();
                            requestBody.getContent().put(format, (Content)requestBodyContent);
                        }
                    } else if (this.apiConfiguration.isDefaultProduceConsumeGuessing()) {
                        requestBody.getContent().put(ProduceConsumeUtils.getDefaultValue(body), (Content)requestBodyContent);
                    } else {
                        requestBody.getContent().put("*/*", (Content)requestBodyContent);
                    }
                    if (methodJavadoc != null) {
                        parameterDoc = methodJavadoc.getParamBlockTagByName(body.getName());
                        if (parameterDoc.isPresent() && !(description = parameterDoc.get().getContent().toText()).isEmpty()) {
                            requestBody.setDescription(parameterDoc.get().getContent().toText());
                        }
                        this.logger.debug((CharSequence)("Parameter documentation found for endpoint body " + body.getName() + " ? " + parameterDoc.isPresent()));
                    }
                }
                Response response = new Response();
                response.setCode(endpoint.getResponseCode(), this.apiConfiguration.getDefaultSuccessfulOperationDescription());
                if (endpoint.getResponseObject() != null) {
                    Content responseContent = Content.fromDataObject(endpoint.getResponseObject());
                    if (endpoint.getResponseFormats() != null) {
                        requestBodyContent = endpoint.getResponseFormats().iterator();
                        while (requestBodyContent.hasNext()) {
                            String format = (String)requestBodyContent.next();
                            response.getContent().put(format, responseContent);
                        }
                    } else if (this.apiConfiguration.isDefaultProduceConsumeGuessing()) {
                        response.getContent().put(ProduceConsumeUtils.getDefaultValue(endpoint.getResponseObject()), responseContent);
                    } else {
                        response.getContent().put("*/*", responseContent);
                    }
                }
                if (methodJavadoc != null) {
                    String description2;
                    Optional<JavadocBlockTag> returnDoc = methodJavadoc.getReturnBlockTag();
                    if (returnDoc.isPresent() && !(description2 = returnDoc.get().getContent().toText()).isEmpty()) {
                        response.setDescription(returnDoc.get().getContent().toText());
                    }
                    this.logger.debug((CharSequence)("Return documentation found ? " + returnDoc.isPresent()));
                }
                operation.getResponses().put(response.getCode(), response);
                if (this.defaultErrors == null) continue;
                this.defaultErrors.entrySet().forEach(entry -> operation.getResponses().put(entry.getKey(), entry.getValue()));
            }
            for (Operation operation : operations) {
                Operation previousOperation = ((Map)paths.get(operation.getPath())).put(operation.getName().toLowerCase(), operation);
                if (previousOperation == null) continue;
                throw new MojoRuntimeException("More than one operation mapped on " + operation.getName() + " : " + operation.getPath() + " in tag " + tag.getName());
            }
        }
        return paths;
    }

    private static boolean isFormData(List<ParameterObject> bodies) {
        return bodies.stream().allMatch(ParameterObject::isMultipartFile);
    }

    private Map<String, Object> createSchemaSection(TagLibrary library) {
        Schema schema;
        HashSet<String> exploredSignatures;
        List ordered = library.getSchemaObjects().stream().sorted(Comparator.comparing(p -> p.getOpenApiResolvedType().isCompleteNode() ? p.getOpenApiResolvedType().getModelName() : p.getSchemaReferenceName())).collect(Collectors.toList());
        LinkedHashMap<String, Object> schemas = new LinkedHashMap<String, Object>();
        for (DataObject dataObject : ordered) {
            exploredSignatures = new HashSet<String>();
            schema = new Schema(dataObject, true, exploredSignatures, null, null);
            schemas.put(dataObject.getOpenApiResolvedType().isCompleteNode() ? dataObject.getOpenApiResolvedType().getModelName() : dataObject.getSchemaReferenceName(), schema);
        }
        for (Map.Entry entry : AdditionnalSchemaLibrary.getMap().entrySet()) {
            exploredSignatures = new HashSet();
            schema = new Schema((DataObject)entry.getValue(), true, exploredSignatures, null, null);
            schemas.put((String)entry.getKey(), schema);
        }
        return schemas;
    }
}

