/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock;

import io.github.kbuntrock.ApiResourceScanner;
import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.TagLibrary;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.CommonApiConfiguration;
import io.github.kbuntrock.configuration.EnumConfigHolder;
import io.github.kbuntrock.configuration.JavadocConfiguration;
import io.github.kbuntrock.configuration.NullableConfigurationHolder;
import io.github.kbuntrock.javadoc.JavadocMap;
import io.github.kbuntrock.javadoc.JavadocParser;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.AdditionnalSchemaLibrary;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import io.github.kbuntrock.utils.FileUtils;
import io.github.kbuntrock.utils.Logger;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import io.github.kbuntrock.yaml.YamlWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

@Mojo(name="documentation", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class DocumentationMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter
    private CommonApiConfiguration apiConfiguration = new CommonApiConfiguration();
    @Parameter(required=true)
    private List<ApiConfiguration> apis;
    @Parameter
    private JavadocConfiguration javadocConfiguration;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Component
    private MavenProjectHelper projectHelper;
    private ClassLoader projectClassLoader;
    private boolean testMode = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            long debut = System.currentTimeMillis();
            Logger.INSTANCE.setLogger(this.getLog());
            this.projectClassLoader = this.createProjectDependenciesClassLoader();
            ReflectionsUtils.initiate(this.projectClassLoader);
            this.documentProject();
            this.getLog().info((CharSequence)("Openapi spec generation took " + (System.currentTimeMillis() - debut) + "ms."));
        }
        catch (MojoRuntimeException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }

    public List<File> documentProject() throws MojoFailureException, MojoExecutionException {
        String version = System.getProperty("java.version");
        this.getLog().debug((CharSequence)("Running on java " + version));
        this.validateConfiguration();
        this.scanJavadoc();
        return this.scanProjectResourcesAndWriteSpec();
    }

    private void validateConfiguration() throws MojoFailureException {
        if (this.apis == null || this.apis.isEmpty()) {
            throw new MojoFailureException("At least one api configuration element should be configured");
        }
        this.getApiConfiguration().initDefaultValues();
        EnumConfigHolder.storeConfig(this.getApiConfiguration().getEnumConfigList());
        if (this.apis.stream().map(ApiConfiguration::getLocations).anyMatch(locations -> locations == null || locations.isEmpty())) {
            throw new MojoFailureException("At least one location element should be configured");
        }
    }

    private List<File> scanProjectResourcesAndWriteSpec() throws MojoFailureException {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ApiConfiguration initialApiConfiguration : this.apis) {
            AdditionnalSchemaLibrary.reset();
            ApiConfiguration apiConfig = initialApiConfiguration.mergeWithCommonApiConfiguration(this.apiConfiguration);
            OpenApiTypeResolver openApiTypeResolver = this.initObjectMapperFactory(apiConfig);
            NullableConfigurationHolder.storeConfig(apiConfig);
            ApiResourceScanner apiResourceScanner = new ApiResourceScanner(apiConfig);
            this.getLog().debug((CharSequence)"Prepare to scan");
            TagLibrary tagLibrary = apiResourceScanner.scanRestControllers();
            this.getLog().debug((CharSequence)"Scan done");
            File generatedFile = null;
            try {
                generatedFile = this.testMode ? Files.createTempFile(apiConfig.getFilename().substring(0, apiConfig.getFilename().length() - ".yml".length()) + "_", ".yml", new FileAttribute[0]).toFile() : new File(this.outputDirectory, apiConfig.getFilename());
                this.getLog().debug((CharSequence)("Prepared to write : " + generatedFile.getAbsolutePath()));
                new YamlWriter(this.project, apiConfig, openApiTypeResolver).write(generatedFile, tagLibrary);
                if (apiConfig.isAttachArtifact()) {
                    String fileExtension = com.google.common.io.Files.getFileExtension((String)apiConfig.getFilename());
                    int extensionSize = fileExtension.isEmpty() ? 0 : fileExtension.length() + 1;
                    String fileNameWithoutExtension = apiConfig.getFilename().substring(0, apiConfig.getFilename().length() - extensionSize);
                    this.projectHelper.attachArtifact(this.project, fileExtension, fileNameWithoutExtension, generatedFile);
                }
                generatedFiles.add(generatedFile);
                int nbTagsGenerated = tagLibrary.getTags().size();
                if (nbTagsGenerated == 0) {
                    throw new MojoFailureException("There is nothing to document. Please check if you have correctly configured the plugin or if the java version used by maven is high enough to read the compiled project classes (maven toolchain is not supported yet)");
                }
                int nbOperationsGenerated = tagLibrary.getTags().stream().map(Tag::getEndpoints).map(Collection::size).mapToInt(Integer::intValue).sum();
                this.getLog().info((CharSequence)(apiConfig.getFilename() + " : " + nbTagsGenerated + " tags and " + nbOperationsGenerated + " operations generated."));
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot write file specification file : " + (generatedFile == null ? "temporary test file" : generatedFile.getAbsolutePath()), (Throwable)e);
            }
        }
        return generatedFiles;
    }

    private OpenApiTypeResolver initObjectMapperFactory(ApiConfiguration apiConfig) {
        OpenApiTypeResolver.INSTANCE.init(this.project, apiConfig);
        return OpenApiTypeResolver.INSTANCE;
    }

    private ClassLoader createProjectDependenciesClassLoader() throws MojoExecutionException {
        try {
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String compileClasspathElements : this.project.getCompileClasspathElements()) {
                pathUrls.add(new File(compileClasspathElements).toURI().toURL());
            }
            for (String runtimeClasspathElement : this.project.getRuntimeClasspathElements()) {
                pathUrls.add(new File(runtimeClasspathElement).toURI().toURL());
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            this.getLog().debug((CharSequence)("urls for URLClassLoader: " + Arrays.asList(urlsForClassLoader)));
            ClassRealm classRealm = (ClassRealm)DocumentationMojo.class.getClassLoader();
            for (URL url : urlsForClassLoader) {
                classRealm.addURL(url);
            }
            return classRealm;
        }
        catch (MalformedURLException | DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Cannot create project dependencies classloader", (Exception)ex);
        }
    }

    private void scanJavadoc() {
        if (this.javadocConfiguration == null || this.javadocConfiguration.getScanLocations() == null || this.javadocConfiguration.getScanLocations().isEmpty()) {
            this.getLog().info((CharSequence)"No javadoc configuration found: scan of javadoc skipped.");
            return;
        }
        long debutJavadoc = System.currentTimeMillis();
        List<File> filesToScan = this.javadocConfiguration.getScanLocations().stream().map(path -> FileUtils.toFile(this.project.getBasedir().getAbsolutePath(), path)).collect(Collectors.toList());
        JavadocParser javadocParser = new JavadocParser(filesToScan, this.javadocConfiguration);
        javadocParser.scan();
        JavadocMap.INSTANCE.setJavadocMap(javadocParser.getJavadocMap());
        if (!JavadocConfiguration.DISABLED_EOF_REPLACEMENT.equals(this.javadocConfiguration.getEndOfLineReplacement())) {
            JavadocWrapper.setEndOfLineReplacement(this.javadocConfiguration.getEndOfLineReplacement());
        }
        this.getLog().info((CharSequence)("Javadoc parsing took " + (System.currentTimeMillis() - debutJavadoc) + "ms."));
    }

    public List<ApiConfiguration> getApis() {
        return this.apis;
    }

    public void setApis(List<ApiConfiguration> apis) {
        this.apis = apis;
    }

    public JavadocConfiguration getJavadocConfiguration() {
        return this.javadocConfiguration;
    }

    public void setJavadocConfiguration(JavadocConfiguration javadocConfiguration) {
        this.javadocConfiguration = javadocConfiguration;
    }

    public CommonApiConfiguration getApiConfiguration() {
        return this.apiConfiguration;
    }

    public void setApiConfiguration(CommonApiConfiguration apiConfiguration) {
        this.apiConfiguration = apiConfiguration;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }
}

