/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.model;

import com.google.common.reflect.TypeToken;
import io.github.kbuntrock.configuration.EnumConfigHolder;
import io.github.kbuntrock.reflection.GenericArrayTypeImpl;
import io.github.kbuntrock.reflection.ParameterizedTypeImpl;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import io.github.kbuntrock.utils.OpenApiDataType;
import io.github.kbuntrock.utils.OpenApiResolvedType;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.ReflectionUtils;

public class DataObject {
    private DataObject[] mapKeyValueDataObjects = new DataObject[2];
    private final Class<?> javaClass;
    private final Type javaType;
    private OpenApiResolvedType openApiResolvedType;
    private DataObject arrayItemDataObject;
    private Boolean uniqueItems;
    private List<String> enumItemValues;
    private List<String> enumItemNames;
    private boolean genericallyTyped;
    private Map<String, Type> genericNameToTypeMap;
    private String schemaReferenceName;
    private Boolean classRequired;

    public DataObject(DataObject dataObject) {
        this.mapKeyValueDataObjects = dataObject.mapKeyValueDataObjects;
        this.javaClass = dataObject.javaClass;
        this.javaType = dataObject.javaType;
        this.openApiResolvedType = dataObject.openApiResolvedType;
        this.arrayItemDataObject = dataObject.arrayItemDataObject;
        this.enumItemValues = dataObject.enumItemValues;
        this.enumItemNames = dataObject.enumItemNames;
        this.genericallyTyped = dataObject.genericallyTyped;
        this.genericNameToTypeMap = dataObject.genericNameToTypeMap;
        this.schemaReferenceName = dataObject.schemaReferenceName;
        this.classRequired = dataObject.classRequired;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataObject(Type originalType) {
        Type type = originalType;
        try {
            WildcardType wt;
            if (type instanceof WildcardType && (wt = (WildcardType)originalType).getLowerBounds().length == 0 && wt.getUpperBounds().length == 1) {
                type = wt.getUpperBounds()[0];
            }
            this.javaType = type;
            if (type instanceof ParameterizedType) {
                this.genericallyTyped = true;
                ParameterizedType pt = (ParameterizedType)type;
                this.javaClass = Class.forName(ReflectionsUtils.getClassNameFromType(pt.getRawType()), true, ReflectionsUtils.getProjectClassLoader());
                this.genericNameToTypeMap = new HashMap<String, Type>();
                for (int i = 0; i < pt.getActualTypeArguments().length; ++i) {
                    this.genericNameToTypeMap.put(this.javaClass.getTypeParameters()[i].getTypeName(), pt.getActualTypeArguments()[i]);
                }
                if (Map.class.isAssignableFrom(this.javaClass)) {
                    this.computeMapTypes();
                } else if (Collection.class.isAssignableFrom(this.javaClass)) {
                    this.computeCollectionType();
                }
            } else if (type instanceof GenericArrayType) {
                this.genericallyTyped = true;
                GenericArrayType gat = (GenericArrayType)type;
                if (gat.getGenericComponentType() instanceof ParameterizedType) {
                    this.genericNameToTypeMap = new HashMap<String, Type>();
                    ParameterizedType gpt = (ParameterizedType)gat.getGenericComponentType();
                    this.javaClass = Class.forName("[L" + ReflectionsUtils.getClassNameFromType(gpt.getRawType()) + ";", true, ReflectionsUtils.getProjectClassLoader());
                    Class<?> rawJavaClass = Class.forName(ReflectionsUtils.getClassNameFromType(gpt.getRawType()), true, ReflectionsUtils.getProjectClassLoader());
                    for (int i = 0; i < gpt.getActualTypeArguments().length; ++i) {
                        this.genericNameToTypeMap.put(rawJavaClass.getTypeParameters()[i].getTypeName(), gpt.getActualTypeArguments()[i]);
                    }
                    this.arrayItemDataObject = new DataObject(gpt);
                } else {
                    if (!(gat.getGenericComponentType() instanceof Class)) throw new RuntimeException("A GenericArrayType with a " + gat.getGenericComponentType().getClass() + " is not and handled case.");
                    Class clazz = (Class)gat.getGenericComponentType();
                    this.javaClass = Class.forName("[L" + ReflectionsUtils.getClassNameFromType(clazz) + ";", true, ReflectionsUtils.getProjectClassLoader());
                    this.arrayItemDataObject = new DataObject(clazz);
                }
            } else {
                if (!(type instanceof Class)) throw new RuntimeException("Type " + originalType.getTypeName() + " (+" + originalType.getClass().getSimpleName() + ") is not supported yet.");
                this.javaClass = (Class)type;
                if (Map.class.isAssignableFrom((Class)type)) {
                    this.computeMapTypes();
                } else if (Collection.class.isAssignableFrom((Class)type)) {
                    this.computeCollectionType();
                }
            }
            this.openApiResolvedType = OpenApiTypeResolver.INSTANCE.resolveFromJavaClass(this.javaClass);
            if (this.javaClass.isEnum()) {
                ?[] values = this.javaClass.getEnumConstants();
                this.enumItemValues = new ArrayList<String>();
                String valueField = EnumConfigHolder.getValueFieldForEnum(this.javaClass.getCanonicalName());
                if (valueField != null) {
                    this.enumItemNames = new ArrayList<String>();
                    Field field = this.javaClass.getDeclaredField(valueField);
                    ReflectionUtils.makeAccessible((Field)field);
                    this.openApiResolvedType = OpenApiTypeResolver.INSTANCE.resolveFromJavaClass(field.getType(), false);
                    for (Object value : values) {
                        this.enumItemNames.add(((Enum)value).name());
                        this.enumItemValues.add(field.get(value).toString());
                    }
                } else {
                    for (Object value : values) {
                        this.enumItemValues.add(((Enum)value).name());
                    }
                }
            } else if (this.javaClass.isArray() && !this.genericallyTyped && this.javaClass != byte[].class) {
                this.arrayItemDataObject = new DataObject(this.javaClass.getComponentType());
            }
            if (!Set.class.isAssignableFrom(this.javaClass)) return;
            this.uniqueItems = true;
            return;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("ClassNotFound wrapped", ex);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Field not found", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void computeMapTypes() {
        TypeToken token = TypeToken.of((Type)this.javaType);
        TypeToken superType = token.getSupertype(Map.class);
        Type[] resolvedArguments = ((ParameterizedType)superType.getType()).getActualTypeArguments();
        this.mapKeyValueDataObjects[0] = new DataObject(resolvedArguments[0]);
        this.mapKeyValueDataObjects[1] = new DataObject(resolvedArguments[1]);
    }

    private void computeCollectionType() {
        TypeToken token = TypeToken.of((Type)this.javaType);
        TypeToken superType = token.getSupertype(Collection.class);
        Type[] resolvedArguments = ((ParameterizedType)superType.getType()).getActualTypeArguments();
        this.arrayItemDataObject = new DataObject(resolvedArguments[0]);
    }

    public boolean isMap() {
        return this.mapKeyValueDataObjects[0] != null;
    }

    public boolean isEnum() {
        return this.javaClass.isEnum();
    }

    public boolean isReferenceObject() {
        return !this.isMap() && (this.isEnum() || !this.genericallyTyped && OpenApiDataType.OBJECT == this.openApiResolvedType.getType());
    }

    public boolean isGenericallyTypedObject() {
        return OpenApiDataType.OBJECT == this.openApiResolvedType.getType() && this.genericallyTyped;
    }

    public boolean isOpenApiArray() {
        return OpenApiDataType.ARRAY == this.openApiResolvedType.getType();
    }

    public boolean isJavaArray() {
        return this.arrayItemDataObject != null && !this.genericallyTyped;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public OpenApiResolvedType getOpenApiResolvedType() {
        return this.openApiResolvedType;
    }

    public DataObject getArrayItemDataObject() {
        return this.arrayItemDataObject;
    }

    public List<String> getEnumItemValues() {
        return this.enumItemValues;
    }

    public List<String> getEnumItemNames() {
        return this.enumItemNames;
    }

    public DataObject getMapValueType() {
        return this.mapKeyValueDataObjects[1];
    }

    public boolean isGenericallyTyped() {
        return this.genericallyTyped;
    }

    public Map<String, Type> getGenericNameToTypeMap() {
        return this.genericNameToTypeMap;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public Boolean getClassRequired() {
        return this.classRequired;
    }

    public void setClassRequired(Boolean classRequired) {
        this.classRequired = classRequired;
    }

    public String getSignature() {
        String genericJoin = this.genericNameToTypeMap == null ? "" : this.genericNameToTypeMap.values().stream().map(v -> v.getTypeName()).collect(Collectors.joining("_"));
        String signature = this.javaClass.toGenericString() + "#" + genericJoin;
        return signature;
    }

    public String getSchemaRecursiveSuffix() {
        String genericJoin = this.genericNameToTypeMap == null ? "" : this.genericNameToTypeMap.values().stream().map(v -> {
            if (v instanceof Class) {
                return ((Class)v).getSimpleName();
            }
            return v.getTypeName();
        }).collect(Collectors.joining("_"));
        return genericJoin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Type getContextualType(Type genericType) {
        if (this.isGenericallyTyped()) {
            if (genericType instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)genericType;
                if (this.getGenericNameToTypeMap().containsKey(typeVariable.getName())) {
                    return this.getGenericNameToTypeMap().get(typeVariable.getName());
                }
            } else {
                if (genericType instanceof ParameterizedType) {
                    ParameterizedTypeImpl substitution = new ParameterizedTypeImpl((ParameterizedType)genericType);
                    this.doContextualSubstitution(substitution);
                    return substitution;
                }
                if (genericType instanceof GenericArrayType) {
                    GenericArrayType genericArrayType = (GenericArrayType)genericType;
                    if (genericArrayType.getGenericComponentType() instanceof ParameterizedType) {
                        ParameterizedTypeImpl substitution = new ParameterizedTypeImpl((ParameterizedType)genericArrayType.getGenericComponentType());
                        this.doContextualSubstitution(substitution);
                        return new GenericArrayTypeImpl(substitution);
                    }
                    if (!(genericArrayType.getGenericComponentType() instanceof TypeVariable)) throw new RuntimeException("Type : " + ((GenericArrayType)genericType).getGenericComponentType().getClass().toString() + " not handled in generic array contextual substitution. Scanned object is : " + this.getJavaClass().getName());
                    TypeVariable typeVariable = (TypeVariable)genericArrayType.getGenericComponentType();
                    if (this.getGenericNameToTypeMap().containsKey(typeVariable.getName())) {
                        return new GenericArrayTypeImpl(this.getGenericNameToTypeMap().get(typeVariable.getName()));
                    }
                }
            }
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            if (parameterizedType.getRawType() != Class.class) return TypeToken.of(this.getJavaClass()).resolveType(genericType).getType();
            if (parameterizedType.getActualTypeArguments().length != 1) return TypeToken.of(this.getJavaClass()).resolveType(genericType).getType();
            if (!(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType)) return TypeToken.of(this.getJavaClass()).resolveType(genericType).getType();
            WildcardType wt = (WildcardType)parameterizedType.getActualTypeArguments()[0];
            if (wt.getLowerBounds().length != 0) return genericType;
            if (wt.getUpperBounds().length != 1) return genericType;
            return wt.getUpperBounds()[0];
        }
        if (!(genericType instanceof TypeVariable)) return genericType;
        return TypeToken.of(this.getJavaClass()).resolveType(genericType).getType();
    }

    private void doContextualSubstitution(ParameterizedTypeImpl substitution) {
        for (int i = 0; i < substitution.getActualTypeArguments().length; ++i) {
            if (this.getGenericNameToTypeMap().containsKey(substitution.getActualTypeArguments()[i].getTypeName())) {
                substitution.getActualTypeArguments()[i] = this.getGenericNameToTypeMap().get(substitution.getActualTypeArguments()[i].getTypeName());
            }
            substitution.getActualTypeArguments()[i] = this.getContextualType(substitution.getActualTypeArguments()[i]);
        }
    }

    public String getSchemaReferenceName() {
        return this.schemaReferenceName;
    }

    public void setSchemaReferenceName(String schemaReferenceName) {
        this.schemaReferenceName = schemaReferenceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataObject that = (DataObject)o;
        return Objects.equals(this.javaClass, that.javaClass);
    }

    public int hashCode() {
        return Objects.hash(this.javaClass);
    }

    public String toString() {
        return "DataObject{openApiType=" + this.openApiResolvedType + ", arrayItemDataObject=" + this.arrayItemDataObject + '}';
    }
}

