/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.yaml.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.TagLibrary;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.NullableConfigurationHolder;
import io.github.kbuntrock.javadoc.ClassDocumentation;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.reflection.AdditionnalSchemaLibrary;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import io.github.kbuntrock.utils.Logger;
import io.github.kbuntrock.utils.OpenApiResolvedType;
import io.github.kbuntrock.utils.UnwrappingType;
import io.github.kbuntrock.yaml.model.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Schema {
    @JsonIgnore
    protected String description;
    @JsonIgnore
    protected List<String> required;
    @JsonIgnore
    protected OpenApiResolvedType type;
    @JsonIgnore
    protected Map<String, Property> properties;
    @JsonIgnore
    protected List<String> enumValues;
    @JsonIgnore
    protected List<String> enumNames;
    @JsonIgnore
    protected List<String> enumDescriptions;
    @JsonIgnore
    protected Schema additionalProperties;
    @JsonIgnore
    protected String reference;
    @JsonIgnore
    protected Schema items;
    @JsonIgnore
    private Boolean uniqueItems;
    @JsonIgnore
    private boolean mainReference = false;
    @JsonIgnore
    private DataObject parentDataObject;
    @JsonIgnore
    private String parentFieldName;
    @JsonIgnore
    protected ApiConfiguration apiConfiguration;

    public Schema(ApiConfiguration apiConfiguration) {
        this.apiConfiguration = apiConfiguration;
    }

    public Schema(DataObject dataObject, Set<String> exploredSignatures, TagLibrary tagLibrary) {
        this(dataObject, false, exploredSignatures, null, null, tagLibrary);
    }

    public Schema(DataObject wrappedDataObject, boolean mainReference, Set<String> exploredSignatures, DataObject parentDataObject, String parentFieldName, TagLibrary tagLibrary) {
        String swaggerDescription;
        MergedAnnotations mergedClassAnnotations;
        MergedAnnotation classSchemaAnnotation;
        DataObject dataObject = tagLibrary.getOpenApiTypeResolver().unwrapDataObject(wrappedDataObject, UnwrappingType.SCHEMA);
        this.apiConfiguration = tagLibrary.getApiConfiguration();
        this.mainReference = mainReference;
        ClassDocumentation classDocumentation = null;
        if (tagLibrary.hasJavadocMap()) {
            Optional<String> optionalDescription;
            classDocumentation = tagLibrary.getJavadocMap().get(dataObject.getJavaClass().getCanonicalName());
            if (classDocumentation != null) {
                classDocumentation.inheritanceEnhancement(dataObject.getJavaClass(), ClassDocumentation.EnhancementType.BOTH, tagLibrary.getJavadocMap());
            }
            if (classDocumentation != null && mainReference && (optionalDescription = classDocumentation.getDescription()).isPresent()) {
                this.description = optionalDescription.get();
            }
        }
        if ((classSchemaAnnotation = (mergedClassAnnotations = MergedAnnotations.from(dataObject.getJavaClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY)).get("io.swagger.v3.oas.annotations.media.Schema")).isPresent() && !StringUtils.isEmpty((CharSequence)(swaggerDescription = classSchemaAnnotation.getString("description")))) {
            this.description = swaggerDescription;
        }
        if (dataObject.isMap()) {
            this.type = dataObject.getOpenApiResolvedType();
            this.additionalProperties = new Schema(dataObject.getMapValueType(), false, exploredSignatures, parentDataObject, parentFieldName, tagLibrary);
        } else if (dataObject.isOpenApiArray()) {
            this.type = dataObject.getOpenApiResolvedType();
            this.items = new Schema(dataObject.getArrayItemDataObject(), false, exploredSignatures, parentDataObject, parentFieldName, tagLibrary);
            this.uniqueItems = dataObject.getUniqueItems();
        } else if (!mainReference && dataObject.isReferenceObject()) {
            DataObject referenceDataObject = tagLibrary.getClassToSchemaObject().get(dataObject.getJavaClass());
            if (referenceDataObject == null) {
                throw new RuntimeException("Writing schema but could not find a reference for class " + dataObject.getJavaClass().getSimpleName());
            }
            this.reference = dataObject.getOpenApiResolvedType().isCompleteNode() ? "#/components/schemas/" + dataObject.getOpenApiResolvedType().getModelName() : "#/components/schemas/" + referenceDataObject.getSchemaReferenceName();
        } else if (mainReference && dataObject.isReferenceObject() || dataObject.isGenericallyTypedObject()) {
            String objectSignature;
            boolean forcedReference = false;
            String referenceSignature = null;
            if (parentDataObject != null && parentFieldName != null && !exploredSignatures.add(objectSignature = parentDataObject.getJavaClass().getSimpleName() + "_" + parentFieldName + "_" + dataObject.getSignature())) {
                referenceSignature = parentDataObject.getJavaClass().getSimpleName() + "_" + dataObject.getSchemaRecursiveSuffix();
                AdditionnalSchemaLibrary.addDataObject(referenceSignature, dataObject);
                forcedReference = true;
            }
            if (!forcedReference) {
                this.type = dataObject.getOpenApiResolvedType();
                if (!this.type.isCompleteNode()) {
                    List<String> enumItemValues;
                    this.properties = new LinkedHashMap<String, Property>();
                    List<Field> fields = ReflectionsUtils.getAllNonStaticFields(new ArrayList<Field>(), dataObject.getJavaClass());
                    if (!fields.isEmpty() && !dataObject.isEnum()) {
                        for (Field field : fields) {
                            String swaggerExample;
                            MergedAnnotations mergedAnnotations;
                            MergedAnnotation schemaAnnotation;
                            JavadocWrapper javadocWrapper;
                            List<Annotation> annotations = this.getRelevantAnnotationsForField(field);
                            if (field.isAnnotationPresent(JsonIgnore.class)) continue;
                            String propertyFieldName = field.getName();
                            JsonProperty jsonPropertyField = this.findAnnotationByClass(annotations, JsonProperty.class);
                            if (jsonPropertyField != null && !jsonPropertyField.value().isEmpty()) {
                                propertyFieldName = jsonPropertyField.value();
                            }
                            DataObject wrappedPropertyObject = new DataObject(dataObject.getContextualType(field.getGenericType()), tagLibrary.getOpenApiTypeResolver());
                            DataObject propertyObject = tagLibrary.getOpenApiTypeResolver().unwrapDataObject(wrappedPropertyObject, UnwrappingType.SCHEMA);
                            Property property = new Property(propertyObject, false, propertyFieldName, exploredSignatures, dataObject, tagLibrary);
                            this.extractConstraints(field, annotations, property);
                            this.properties.put(property.getName(), property);
                            if (classDocumentation != null && (javadocWrapper = classDocumentation.getFieldsJavadoc().get(field.getName())) != null) {
                                Optional<String> desc = javadocWrapper.getDescription();
                                property.setDescription(desc.get());
                            }
                            if (!(schemaAnnotation = (mergedAnnotations = MergedAnnotations.from((AnnotatedElement)field)).get("io.swagger.v3.oas.annotations.media.Schema")).isPresent()) continue;
                            String swaggerDescription2 = schemaAnnotation.getString("description");
                            if (!StringUtils.isEmpty((CharSequence)swaggerDescription2)) {
                                property.setDescription(swaggerDescription2);
                            }
                            if (StringUtils.isEmpty((CharSequence)(swaggerExample = schemaAnnotation.getString("example")))) continue;
                            property.setExample(swaggerExample);
                        }
                    }
                    if (dataObject.getJavaClass().isInterface()) {
                        List methods = Arrays.stream(dataObject.getJavaClass().getMethods()).collect(Collectors.toList());
                        methods.sort(Comparator.comparing(a -> a.getName()));
                        for (Method method : methods) {
                            JavadocWrapper javadocWrapper;
                            boolean methodStartWithGet;
                            boolean bl = methodStartWithGet = method.getName().startsWith("get") && method.getName().length() != TagLibrary.METHOD_GET_PREFIX_SIZE;
                            if (method.getParameters().length != 0 || method.getGenericReturnType() == null || !methodStartWithGet && (!method.getName().startsWith("is") || method.getName().length() == TagLibrary.METHOD_IS_PREFIX_SIZE)) continue;
                            String name = methodStartWithGet ? method.getName().replaceFirst("get", "") : method.getName().replaceFirst("is", "");
                            Logger.INSTANCE.getLogger().debug((CharSequence)(dataObject.getJavaClass().getSimpleName() + " method name : " + method.getName() + " - " + name));
                            name = name.substring(0, 1).toLowerCase() + name.substring(1);
                            DataObject propertyObject = new DataObject(dataObject.getContextualType(method.getGenericReturnType()), tagLibrary.getOpenApiTypeResolver());
                            Property property = new Property(propertyObject, false, name, exploredSignatures, dataObject, tagLibrary);
                            this.properties.put(property.getName(), property);
                            if (classDocumentation == null || (javadocWrapper = classDocumentation.getMethodsJavadocByIdentifier().get(JavaClassAnalyser.createMethodIdentifier(method))) == null) continue;
                            Optional<String> desc = javadocWrapper.getDescription();
                            property.setDescription(desc.get());
                        }
                    }
                    if ((enumItemValues = dataObject.getEnumItemValues()) != null && !enumItemValues.isEmpty()) {
                        this.enumValues = enumItemValues;
                        this.enumNames = dataObject.getEnumItemNames();
                        if (classDocumentation != null) {
                            this.enumDescriptions = new ArrayList<String>();
                            StringBuilder stringBuilder = new StringBuilder();
                            if (this.description != null) {
                                stringBuilder.append(this.description);
                                stringBuilder.append("\n");
                            }
                            for (int i = 0; i < enumItemValues.size(); ++i) {
                                Optional<String> desc;
                                String descriptionValue = "";
                                String value = this.enumNames == null ? enumItemValues.get(i) : this.enumNames.get(i);
                                JavadocWrapper javadocWrapper = classDocumentation.getFieldsJavadoc().get(value);
                                if (javadocWrapper != null && (desc = javadocWrapper.getDescription()).isPresent()) {
                                    descriptionValue = desc.get();
                                    if (this.apiConfiguration.getEnumListDescriptionEnabled().booleanValue()) {
                                        stringBuilder.append("  * ");
                                        stringBuilder.append("`");
                                        stringBuilder.append(value);
                                        stringBuilder.append("` - ");
                                        stringBuilder.append(desc.get());
                                        stringBuilder.append("\n");
                                    }
                                }
                                this.enumDescriptions.add(descriptionValue);
                            }
                            this.description = stringBuilder.toString();
                        }
                    }
                    this.required = this.properties.values().stream().filter(Property::isRequired).map(Property::getName).collect(Collectors.toList());
                }
            } else {
                this.reference = "#/components/schemas/" + referenceSignature;
            }
        } else {
            this.type = dataObject.getOpenApiResolvedType();
        }
    }

    private <T extends Annotation> T findAnnotationByClass(List<Annotation> annotations, Class<T> annotationType) {
        return (T)((Annotation)annotations.stream().filter(a -> a.annotationType().equals(annotationType)).findFirst().orElse(null));
    }

    private List<Annotation> getRelevantAnnotationsForField(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        List relatedMethods = Arrays.stream(declaringClass.getMethods()).filter(Schema.isMethodGetterForField(field).or(Schema.isMethodSetterForField(field))).collect(Collectors.toList());
        return Stream.concat(relatedMethods.stream().flatMap(method -> Arrays.stream(method.getAnnotations())), Arrays.stream(field.getAnnotations())).collect(Collectors.toList());
    }

    private static Predicate<Method> isMethodGetterForField(Field field) {
        return method -> (method.getName().equalsIgnoreCase(field.getName()) || method.getName().equalsIgnoreCase("get" + field.getName()) || method.getName().equalsIgnoreCase("is" + field.getName())) && method.getReturnType().equals(field.getType()) && method.getParameterCount() == 0;
    }

    private static Predicate<Method> isMethodSetterForField(Field field) {
        return method -> (method.getName().equalsIgnoreCase(field.getName()) || method.getName().equalsIgnoreCase("set" + field.getName())) && method.getReturnType().equals(Void.TYPE) && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(field.getType());
    }

    private void extractConstraints(Field field, List<Annotation> annotations, Property property) {
        Size size = this.findAnnotationByClass(annotations, Size.class);
        if (size != null) {
            property.setMinLength(size.min());
            if (size.max() != Integer.MAX_VALUE) {
                property.setMaxLength(size.max());
            }
        }
        if (NullableConfigurationHolder.hasNonNullAnnotation(annotations)) {
            property.setRequired(true);
        } else if (NullableConfigurationHolder.hasNullableAnnotation(annotations)) {
            property.setRequired(false);
        } else {
            property.setRequired(NullableConfigurationHolder.isDefaultNonNullableFields());
        }
    }

    public List<String> getRequired() {
        return this.required;
    }

    public void setRequired(List<String> required) {
        this.required = required;
    }

    public OpenApiResolvedType getType() {
        return this.type;
    }

    public void setType(OpenApiResolvedType type) {
        this.type = type;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Property> properties) {
        this.properties = properties;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    public Schema getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Schema additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Schema getItems() {
        return this.items;
    }

    public void setItems(Schema items) {
        this.items = items;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    @JsonAnyGetter
    public Map<String, Object> getJsonObject() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.description != null) {
            map.put("description", this.description);
        }
        if (this.required != null && !this.required.isEmpty()) {
            map.put("required", this.required);
        }
        if (this.type != null) {
            for (Map.Entry<String, JsonNode> entry : this.type.getSchemaSection().entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            map.put("properties", this.properties);
        }
        if (this.enumValues != null && !this.enumValues.isEmpty()) {
            map.put("enum", this.enumValues);
        }
        if (this.apiConfiguration.getEnumNameExtensionEnabled().booleanValue() && this.enumNames != null && !this.enumNames.isEmpty()) {
            map.put(this.apiConfiguration.getEnumNameExtensionValue(), this.enumNames);
        }
        if (this.apiConfiguration.getEnumDescriptionExtensionEnabled().booleanValue() && this.enumDescriptions != null && !this.enumDescriptions.isEmpty()) {
            map.put(this.apiConfiguration.getEnumDescriptionExtensionValue(), this.enumDescriptions);
        }
        if (this.additionalProperties != null) {
            map.put("additionalProperties", this.additionalProperties);
        }
        if (StringUtils.isNotBlank((CharSequence)this.reference)) {
            map.put("$ref", this.reference);
        }
        if (this.items != null) {
            map.put("items", this.items);
        }
        if (this.uniqueItems != null) {
            map.put("uniqueItems", this.uniqueItems);
        }
        return map;
    }
}

