/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddDefaultValueChange;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.change.core.AddUniqueConstraintChange;
import liquibase.change.core.AlterSequenceChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateProcedureChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.DropAllForeignKeyConstraintsChange;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.change.core.DropIndexChange;
import liquibase.change.core.DropNotNullConstraintChange;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.change.core.DropProcedureChange;
import liquibase.change.core.DropSequenceChange;
import liquibase.change.core.DropTableChange;
import liquibase.change.core.DropUniqueConstraintChange;
import liquibase.change.core.DropViewChange;
import liquibase.change.core.InsertDataChange;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadUpdateDataChange;
import liquibase.change.core.MergeColumnChange;
import liquibase.change.core.ModifyDataTypeChange;
import liquibase.change.core.RenameColumnChange;
import liquibase.change.core.RenameSequenceChange;
import liquibase.change.core.RenameTableChange;
import liquibase.change.core.RenameViewChange;
import liquibase.change.core.UpdateDataChange;

public final class Changes {
    private static final List<Class<? extends Change>> DDL_CHANGE_TYPES = Collections.unmodifiableList(Arrays.asList(DropViewChange.class, AddUniqueConstraintChange.class, DropColumnChange.class, DropIndexChange.class, AddForeignKeyConstraintChange.class, ModifyDataTypeChange.class, DropNotNullConstraintChange.class, RenameTableChange.class, MergeColumnChange.class, AlterSequenceChange.class, CreateIndexChange.class, RenameViewChange.class, DropPrimaryKeyChange.class, DropUniqueConstraintChange.class, DropSequenceChange.class, RenameSequenceChange.class, CreateSequenceChange.class, AddNotNullConstraintChange.class, DropDefaultValueChange.class, AddColumnChange.class, DropTableChange.class, DropAllForeignKeyConstraintsChange.class, CreateViewChange.class, CreateTableChange.class, RenameColumnChange.class, CreateProcedureChange.class, DropForeignKeyConstraintChange.class, DropProcedureChange.class, AddPrimaryKeyChange.class, AddDefaultValueChange.class));
    private static final List<Class<? extends Change>> DML_CHANGE_TYPES = Collections.unmodifiableList(Arrays.asList(InsertDataChange.class, UpdateDataChange.class, DeleteDataChange.class, LoadDataChange.class, LoadUpdateDataChange.class));

    private Changes() {
    }

    public static boolean isDDL(Change change) {
        return DDL_CHANGE_TYPES.contains(change.getClass());
    }

    public static boolean isDML(Change change) {
        return DML_CHANGE_TYPES.contains(change.getClass());
    }
}

