/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter;

import io.github.liquibaselinter.ChangeLogLintingException;
import io.github.liquibaselinter.config.Config;
import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.report.Report;
import io.github.liquibaselinter.report.ReportItem;
import io.github.liquibaselinter.rules.ChangeLogRule;
import io.github.liquibaselinter.rules.ChangeRule;
import io.github.liquibaselinter.rules.ChangeSetRule;
import io.github.liquibaselinter.rules.ConditionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import org.apache.commons.lang3.StringUtils;

class RuleRunner {
    private static final String LQL_IGNORE_TOKEN = "lql-ignore";
    private final Config config;
    private final List<ChangeRule> changeRules = RuleRunner.loadAvailablesServices(ChangeRule.class);
    private final List<ChangeSetRule> changeSetRules = RuleRunner.loadAvailablesServices(ChangeSetRule.class);
    private final List<ChangeLogRule> changeLogRules = RuleRunner.loadAvailablesServices(ChangeLogRule.class);
    private final List<ReportItem> reportItems = new ArrayList<ReportItem>();
    private final Set<String> filesParsed = new HashSet<String>();

    public RuleRunner(Config config) {
        this.config = config;
    }

    private static <T> List<T> loadAvailablesServices(Class<T> clazz) {
        return StreamSupport.stream(ServiceLoader.load(clazz).spliterator(), false).collect(Collectors.toList());
    }

    public Report buildReport() {
        return new Report(this.config, this.reportItems);
    }

    public Set<String> getFilesParsed() {
        return this.filesParsed;
    }

    public void checkChange(Change change) throws ChangeLogLintingException {
        ChangeSet changeSet = change.getChangeSet();
        DatabaseChangeLog changeLog = changeSet.getChangeLog();
        for (ChangeRule changeRule : this.changeRules) {
            if (!changeRule.getChangeType().isAssignableFrom(change.getClass()) || !changeRule.supports(change)) continue;
            List<RuleConfig> configs = this.config.forRule(changeRule.getName());
            String ruleName = changeRule.getName();
            for (RuleConfig ruleConfig : configs) {
                if (!this.isEnabled(ruleConfig) || !ConditionHelper.evaluateCondition(ruleConfig, change)) continue;
                changeRule.configure(ruleConfig);
                String message = changeRule.getMessage(change);
                if (changeRule.invalid(change)) {
                    this.handleViolation(changeLog, changeSet, ruleName, message);
                    continue;
                }
                this.reportItems.add(ReportItem.passed(changeLog, changeSet, ruleName, message));
            }
        }
    }

    public void checkChangeSet(ChangeSet changeSet) throws ChangeLogLintingException {
        DatabaseChangeLog changeLog = changeSet.getChangeLog();
        for (ChangeSetRule changeSetRule : this.changeSetRules) {
            String ruleName = changeSetRule.getName();
            List<RuleConfig> configs = this.config.forRule(ruleName);
            for (RuleConfig ruleConfig : configs) {
                if (!this.isEnabled(ruleConfig) || !ConditionHelper.evaluateCondition(ruleConfig, changeSet)) continue;
                changeSetRule.configure(ruleConfig);
                String message = changeSetRule.getMessage(changeSet);
                if (changeSetRule.invalid(changeSet)) {
                    this.handleViolation(changeLog, changeSet, ruleName, message);
                    continue;
                }
                this.reportItems.add(ReportItem.passed(changeLog, changeSet, ruleName, message));
            }
        }
    }

    public void checkChangeLog(DatabaseChangeLog changeLog) throws ChangeLogLintingException {
        for (ChangeLogRule changeLogRule : this.changeLogRules) {
            String ruleName = changeLogRule.getName();
            List<RuleConfig> configs = this.config.forRule(ruleName);
            for (RuleConfig ruleConfig : configs) {
                if (!this.isEnabled(ruleConfig) || !ConditionHelper.evaluateCondition(ruleConfig, changeLog)) continue;
                changeLogRule.configure(ruleConfig);
                String message = changeLogRule.getMessage(changeLog);
                if (changeLogRule.invalid(changeLog)) {
                    this.handleViolation(changeLog, null, ruleName, message);
                    continue;
                }
                this.reportItems.add(ReportItem.passed(changeLog, null, ruleName, message));
            }
        }
    }

    private void handleViolation(DatabaseChangeLog databaseChangeLog, ChangeSet changeSet, String rule, String message) throws ChangeLogLintingException {
        if (this.isIgnored(rule, changeSet)) {
            this.reportItems.add(ReportItem.ignored(databaseChangeLog, changeSet, rule, message));
        } else {
            if (this.config.isFailFast()) {
                throw ChangeLogLintingException.from(databaseChangeLog, changeSet, message);
            }
            this.reportItems.add(ReportItem.error(databaseChangeLog, changeSet, rule, message));
        }
    }

    private boolean isIgnored(String ruleName, ChangeSet changeSet) {
        String comments = Optional.ofNullable(changeSet).map(ChangeSet::getComments).orElse("");
        if (comments.endsWith(LQL_IGNORE_TOKEN)) {
            return true;
        }
        int index = comments.indexOf("lql-ignore:");
        if (index >= 0) {
            String toIgnore = comments.substring(index + LQL_IGNORE_TOKEN.length() + 1);
            return Arrays.stream(toIgnore.split(",")).anyMatch(ruleName::equalsIgnoreCase);
        }
        return false;
    }

    private boolean isEnabled(RuleConfig ruleConfig) {
        return ruleConfig.isEnabled() && (StringUtils.isEmpty((CharSequence)ruleConfig.getEnableAfter()) || this.filesParsed.contains(ruleConfig.getEnableAfter()));
    }
}

