/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.config;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Streams;
import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.exception.UnexpectedLiquibaseException;

@JsonDeserialize(builder=Builder.class)
public final class Config {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> VALUE_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private final Pattern ignoreContextPattern;
    private final Pattern ignoreFilesPattern;
    private final ListMultimap<String, RuleConfig> rules;
    private final boolean failFast;
    private final String enableAfter;
    private final ListMultimap<String, Reporter> reporting;
    private final List<String> imports;

    private Config(Pattern ignoreContextPattern, Pattern ignoreFilesPattern, ListMultimap<String, RuleConfig> rules, boolean failFast, String enableAfter, ListMultimap<String, Reporter> reporting, List<String> imports) {
        this.ignoreContextPattern = ignoreContextPattern;
        this.ignoreFilesPattern = ignoreFilesPattern;
        this.rules = (ListMultimap)Optional.ofNullable(rules).map(ImmutableListMultimap::copyOf).orElse(ImmutableListMultimap.of());
        this.failFast = failFast;
        this.enableAfter = enableAfter;
        this.reporting = (ListMultimap)Optional.ofNullable(reporting).map(ImmutableListMultimap::copyOf).orElse(ImmutableListMultimap.of());
        this.imports = (List)Optional.ofNullable(imports).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    public static Config fromInputStream(InputStream inputStream) throws IOException {
        return (Config)new ObjectMapper().readValue(inputStream, Config.class);
    }

    public Pattern getIgnoreContextPattern() {
        return this.ignoreContextPattern;
    }

    public Pattern getIgnoreFilesPattern() {
        return this.ignoreFilesPattern;
    }

    public ListMultimap<String, RuleConfig> getRules() {
        return this.rules;
    }

    public List<RuleConfig> forRule(String ruleName) {
        return this.rules.get((Object)ruleName);
    }

    public List<RuleConfig> getEnabledRuleConfig(String ruleName) {
        return this.forRule(ruleName).stream().filter(RuleConfig::isEnabled).collect(Collectors.toList());
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public String getEnableAfter() {
        return this.enableAfter;
    }

    public ListMultimap<String, Reporter> getReporting() {
        return this.reporting;
    }

    List<String> getImports() {
        return this.imports;
    }

    static class ReportingDeserializer
    extends JsonDeserializer<Object> {
        private static final ServiceLoader<Reporter.Factory> REPORTERS = ServiceLoader.load(Reporter.Factory.class);

        ReportingDeserializer() {
        }

        public ListMultimap<String, Reporter> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            ImmutableListMultimap.Builder reporting = new ImmutableListMultimap.Builder();
            JsonNode config = (JsonNode)jsonParser.readValueAsTree();
            config.fields().forEachRemaining(entry -> {
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isArray()) {
                    value.elements().forEachRemaining(node -> this.populateConfigValue((ImmutableListMultimap.Builder<String, Reporter>)reporting, key, (JsonNode)node));
                } else {
                    this.populateConfigValue((ImmutableListMultimap.Builder<String, Reporter>)reporting, key, value);
                }
            });
            return reporting.build();
        }

        private void populateConfigValue(ImmutableListMultimap.Builder<String, Reporter> reporting, String key, JsonNode node) {
            Reporter.Factory reporterFactory = Streams.stream(REPORTERS.iterator()).filter(factory -> factory.supports(key)).findFirst().orElseThrow(() -> new UnexpectedLiquibaseException("No lq lint reporter named '" + key + '\''));
            if (node.isBoolean()) {
                reporting.put((Object)key, reporterFactory.create(node.asBoolean()));
            } else if (node.isTextual()) {
                reporting.put((Object)key, reporterFactory.create(node.asText()));
            } else {
                reporting.put((Object)key, reporterFactory.create((ReporterConfig)OBJECT_MAPPER.convertValue((Object)node, reporterFactory.getConfigClass())));
            }
        }
    }

    static class RuleConfigDeserializer
    extends JsonDeserializer<Object> {
        RuleConfigDeserializer() {
        }

        public ListMultimap<String, RuleConfig> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Map config = (Map)jsonParser.readValueAs(VALUE_TYPE_REF);
            ImmutableListMultimap.Builder ruleConfigs = new ImmutableListMultimap.Builder();
            config.forEach((key, value) -> {
                if (value instanceof List) {
                    ((List)value).forEach(item -> this.populateConfigValue((ImmutableListMultimap.Builder<String, RuleConfig>)ruleConfigs, (String)key, item));
                } else {
                    this.populateConfigValue((ImmutableListMultimap.Builder<String, RuleConfig>)ruleConfigs, (String)key, value);
                }
            });
            return ruleConfigs.build();
        }

        private void populateConfigValue(ImmutableListMultimap.Builder<String, RuleConfig> ruleConfigs, String key, Object value) {
            try {
                boolean ruleEnabled = (Boolean)OBJECT_MAPPER.convertValue(value, Boolean.TYPE);
                ruleConfigs.put((Object)key, (Object)(ruleEnabled ? RuleConfig.enabled() : RuleConfig.disabled()));
            }
            catch (IllegalArgumentException e) {
                RuleConfig ruleConfig = (RuleConfig)OBJECT_MAPPER.convertValue(value, RuleConfig.class);
                ruleConfigs.put((Object)key, (Object)ruleConfig);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        private Pattern ignoreContextPattern;
        private Pattern ignoreFilesPattern;
        private ListMultimap<String, RuleConfig> rules = ImmutableListMultimap.of();
        private boolean failFast;
        private String enableAfter;
        private ListMultimap<String, Reporter> reporting = ImmutableListMultimap.of();
        private List<String> imports = Collections.emptyList();

        public Builder() {
        }

        public Builder(Config config) {
            this.ignoreContextPattern = config.getIgnoreContextPattern();
            this.ignoreFilesPattern = config.getIgnoreFilesPattern();
            this.rules = config.getRules();
            this.failFast = config.isFailFast();
            this.enableAfter = config.getEnableAfter();
            this.imports = config.getImports();
        }

        @JsonProperty(value="ignore-context-pattern")
        public Builder withIgnoreContextPattern(String ignoreContextPattern) {
            this.ignoreContextPattern = ignoreContextPattern != null ? Pattern.compile(ignoreContextPattern) : null;
            return this;
        }

        public Builder withIgnoreContextPattern(Pattern ignoreContextPattern) {
            this.ignoreContextPattern = this.ignoreFilesPattern;
            return this;
        }

        @JsonProperty(value="ignore-files-pattern")
        public Builder withIgnoreFilesPattern(String ignoreFilesPattern) {
            this.ignoreFilesPattern = ignoreFilesPattern != null ? Pattern.compile(ignoreFilesPattern) : null;
            return this;
        }

        public Builder withIgnoreFilesPattern(Pattern ignoreFilesPattern) {
            this.ignoreFilesPattern = ignoreFilesPattern;
            return this;
        }

        @JsonProperty(value="rules")
        @JsonDeserialize(using=RuleConfigDeserializer.class)
        public Builder withRules(ListMultimap<String, RuleConfig> rules) {
            this.rules = ImmutableListMultimap.copyOf(rules);
            return this;
        }

        @JsonProperty(value="fail-fast")
        public Builder withFailFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        @JsonProperty(value="enable-after")
        public Builder withEnableAfter(String enableAfter) {
            this.enableAfter = enableAfter;
            return this;
        }

        @JsonProperty(value="reporting")
        @JsonDeserialize(using=ReportingDeserializer.class)
        public Builder withReporting(ListMultimap<String, Reporter> reporting) {
            this.reporting = reporting;
            return this;
        }

        @JsonProperty(value="import")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public Builder withImports(String ... imports) {
            this.imports = Collections.unmodifiableList(Arrays.asList(imports));
            return this;
        }

        public Config build() {
            return new Config(this.ignoreContextPattern, this.ignoreFilesPattern, this.rules, this.failFast, this.enableAfter, this.reporting, this.imports);
        }
    }
}

