/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import io.github.liquibaselinter.config.Config;
import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.report.Reporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.ResourceAccessor;

public class ConfigLoader {
    public static final String LQLINT_CONFIG = "/lqlint.json";
    public static final String LQLINT_CONFIG_CLASSPATH = "lqlint.json";
    public static final String LQLINT_CONFIG_PATH_PROPERTY = "lqlint.config.path";
    public static final String LQLINT_CONFIG_IMPLICIT_PATH = "io/github/liquibaselinter/config/lqlint-implicit.json";

    public Config load(ResourceAccessor resourceAccessor) {
        List configPaths = Stream.of(System.getProperty(LQLINT_CONFIG_PATH_PROPERTY), LQLINT_CONFIG, LQLINT_CONFIG_CLASSPATH).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            for (String configPath : configPaths) {
                Config config = this.loadConfig(resourceAccessor, configPath);
                if (config == null) continue;
                return this.loadImports(resourceAccessor, config, Collections.singletonList(LQLINT_CONFIG_IMPLICIT_PATH));
            }
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException("Failed to load lq lint config file", (Throwable)e);
        }
        throw new UnexpectedLiquibaseException("Failed to load lq lint config file");
    }

    private Config loadConfig(ResourceAccessor resourceAccessor, String path) throws IOException {
        try (InputStream stream = resourceAccessor.openStream(null, path);){
            Config config;
            if (stream != null && (config = Config.fromInputStream(stream)) != null) {
                Config config2 = this.loadImports(resourceAccessor, config, config.getImports());
                return config2;
            }
        }
        return null;
    }

    private Config loadImports(ResourceAccessor resourceAccessor, Config config, List<String> imports) {
        ArrayListMultimap rules = ArrayListMultimap.create();
        ArrayListMultimap reporting = ArrayListMultimap.create();
        if (config.getRules() != null) {
            rules.putAll(config.getRules());
        }
        if (config.getReporting() != null) {
            reporting.putAll(config.getReporting());
        }
        if (imports != null) {
            for (String path : imports) {
                try {
                    Config importedConfig = this.loadConfig(resourceAccessor, path);
                    ConfigLoader.combine(config.getRules(), importedConfig.getRules(), rules);
                    ConfigLoader.combine(config.getReporting(), importedConfig.getReporting(), reporting);
                }
                catch (IOException | NullPointerException e) {
                    throw new UnexpectedLiquibaseException("Failed to load imported lq lint config file: " + path, (Throwable)e);
                }
            }
        }
        return new Config.Builder(config).withRules((ListMultimap<String, RuleConfig>)rules).withReporting((ListMultimap<String, Reporter>)reporting).withImports(new String[0]).build();
    }

    private static <T> void combine(ListMultimap<String, T> config, ListMultimap<String, T> imported, ListMultimap<String, T> combined) {
        if (imported != null) {
            imported.asMap().forEach((key, importedRulesList) -> {
                if (config == null || !config.containsKey(key)) {
                    combined.putAll(key, (Iterable)importedRulesList);
                }
            });
        }
    }
}

