/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.report;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableSet;
import io.github.liquibaselinter.report.ReportItem;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
public class ReporterConfig {
    private final boolean enabled;
    private final String path;
    private final Set<ReportItem.ReportItemType> filter;

    public ReporterConfig(BaseBuilder<?> builder) {
        this.enabled = builder.isEnabled();
        this.path = builder.getPath();
        this.filter = builder.getFilter();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPath() {
        return this.path;
    }

    public Set<ReportItem.ReportItemType> getFilter() {
        return this.filter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseBuilder<Builder> {
    }

    public static abstract class BaseBuilder<B extends BaseBuilder<B>> {
        private boolean enabled = true;
        private String path;
        private Set<ReportItem.ReportItemType> filter = new LinkedHashSet<ReportItem.ReportItemType>(Arrays.asList(ReportItem.ReportItemType.ERROR, ReportItem.ReportItemType.IGNORED));

        public B withEnabled(boolean enabled) {
            this.enabled = enabled;
            return (B)this;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public B withPath(String path) {
            this.path = path;
            return (B)this;
        }

        public String getPath() {
            return this.path;
        }

        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public B withFilter(ReportItem.ReportItemType ... filter) {
            this.filter = ImmutableSet.copyOf((Object[])filter);
            return (B)this;
        }

        public Set<ReportItem.ReportItemType> getFilter() {
            return this.filter;
        }

        public ReporterConfig build() {
            return new ReporterConfig(this);
        }
    }
}

