/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.rules.AbstractLintRule;
import io.github.liquibaselinter.rules.ChangeLogRule;
import liquibase.changelog.DatabaseChangeLog;

@AutoService(value={ChangeLogRule.class})
public class ChangeLogFileNameRule
extends AbstractLintRule
implements ChangeLogRule {
    private static final String NAME = "changelog-file-name";
    private static final String MESSAGE = "ChangeLog filename '%s' must follow pattern '%s'";

    public ChangeLogFileNameRule() {
        super(NAME, MESSAGE);
    }

    @Override
    public boolean invalid(DatabaseChangeLog changeLog) {
        return this.checkMandatoryPattern(changeLog.getPhysicalFilePath(), changeLog);
    }

    @Override
    public String getMessage(DatabaseChangeLog changeLog) {
        return this.formatMessage(changeLog.getPhysicalFilePath(), this.getConfig().getPatternString());
    }
}

