/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.rules.AbstractLintRule;
import io.github.liquibaselinter.rules.ChangeSetRule;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;

@AutoService(value={ChangeSetRule.class})
public class HasCommentRule
extends AbstractLintRule
implements ChangeSetRule {
    private static final String NAME = "has-comment";
    private static final String MESSAGE = "Change set must have a comment";

    public HasCommentRule() {
        super(NAME, MESSAGE);
    }

    @Override
    public boolean invalid(ChangeSet changeSet) {
        if (changeSet.getChanges().stream().anyMatch(TagDatabaseChange.class::isInstance)) {
            return false;
        }
        return this.checkNotBlank(changeSet.getComments());
    }
}

