/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.rules.AbstractLintRule;
import io.github.liquibaselinter.rules.ChangeRule;
import liquibase.change.AbstractChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.RenameTableChange;

@AutoService(value={ChangeRule.class})
public class TableNameLengthRule
extends AbstractLintRule
implements ChangeRule<AbstractChange> {
    private static final String NAME = "table-name-length";
    private static final String MESSAGE = "Table '%s' name must not be longer than %d";

    public TableNameLengthRule() {
        super(NAME, MESSAGE);
    }

    @Override
    public Class<AbstractChange> getChangeType() {
        return AbstractChange.class;
    }

    @Override
    public boolean supports(AbstractChange change) {
        return change instanceof CreateTableChange || change instanceof RenameTableChange;
    }

    @Override
    public boolean invalid(AbstractChange change) {
        String tableName = this.getTableName(change);
        return tableName != null && this.checkMaxLength(tableName);
    }

    @Override
    public String getMessage(AbstractChange change) {
        return this.formatMessage(this.getTableName(change), this.getConfig().getMaxLength());
    }

    private String getTableName(AbstractChange change) {
        if (change instanceof CreateTableChange) {
            return ((CreateTableChange)change).getTableName();
        }
        return ((RenameTableChange)change).getNewTableName();
    }
}

