/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.rules.AbstractLintRule;
import io.github.liquibaselinter.rules.ChangeRule;
import liquibase.change.AbstractChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.RenameTableChange;

@AutoService(value={ChangeRule.class})
public class TableNameRule
extends AbstractLintRule
implements ChangeRule<AbstractChange> {
    private static final String NAME = "table-name";
    private static final String MESSAGE = "Table name does not follow pattern";

    public TableNameRule() {
        super(NAME, MESSAGE);
    }

    @Override
    public Class<AbstractChange> getChangeType() {
        return AbstractChange.class;
    }

    @Override
    public boolean supports(AbstractChange change) {
        return change instanceof CreateTableChange || change instanceof RenameTableChange;
    }

    @Override
    public boolean invalid(AbstractChange change) {
        return this.checkMandatoryPattern(this.getTableName(change), change);
    }

    @Override
    public String getMessage(AbstractChange change) {
        return this.formatMessage(this.getTableName(change), this.getConfig().getPatternString());
    }

    private String getTableName(AbstractChange change) {
        if (change instanceof CreateTableChange) {
            return ((CreateTableChange)change).getTableName();
        }
        return ((RenameTableChange)change).getNewTableName();
    }
}

