/*
 * Decompiled with CFR 0.152.
 */
package feign.soap;

import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.jaxb.JAXBContextFactory;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;

public class SOAPDecoder
implements Decoder {
    private final JAXBContextFactory jaxbContextFactory;
    private final String soapProtocol;
    private final boolean useFirstChild;

    public SOAPDecoder(JAXBContextFactory jaxbContextFactory) {
        this.jaxbContextFactory = jaxbContextFactory;
        this.soapProtocol = "SOAP 1.1 Protocol";
        this.useFirstChild = false;
    }

    private SOAPDecoder(Builder builder) {
        this.soapProtocol = builder.soapProtocol;
        this.jaxbContextFactory = builder.jaxbContextFactory;
        this.useFirstChild = builder.useFirstChild;
    }

    public Object decode(Response response, Type type) throws IOException {
        if (response.status() == 404) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        while (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            type = ptype.getRawType();
        }
        if (!(type instanceof Class)) {
            throw new UnsupportedOperationException("SOAP only supports decoding raw types. Found " + type);
        }
        try {
            SOAPMessage message = MessageFactory.newInstance((String)this.soapProtocol).createMessage(null, response.body().asInputStream());
            if (message.getSOAPBody() != null) {
                if (message.getSOAPBody().hasFault()) {
                    throw new SOAPFaultException(message.getSOAPBody().getFault());
                }
                Unmarshaller unmarshaller = this.jaxbContextFactory.createUnmarshaller((Class)type);
                if (this.useFirstChild) {
                    Object object = unmarshaller.unmarshal(message.getSOAPBody().getFirstChild());
                    return object;
                }
                Object object = unmarshaller.unmarshal((Node)message.getSOAPBody().extractContentAsDocument());
                return object;
            }
        }
        catch (JAXBException | SOAPException e) {
            throw new DecodeException(response.status(), e.toString(), response.request(), e);
        }
        finally {
            if (response.body() != null) {
                response.body().close();
            }
        }
        return Util.emptyValueOf((Type)type);
    }

    public static class Builder {
        String soapProtocol = "SOAP 1.1 Protocol";
        JAXBContextFactory jaxbContextFactory;
        boolean useFirstChild = false;

        public Builder withJAXBContextFactory(JAXBContextFactory jaxbContextFactory) {
            this.jaxbContextFactory = jaxbContextFactory;
            return this;
        }

        public Builder withSOAPProtocol(String soapProtocol) {
            this.soapProtocol = soapProtocol;
            return this;
        }

        public Builder useFirstChild() {
            this.useFirstChild = true;
            return this;
        }

        public SOAPDecoder build() {
            if (this.jaxbContextFactory == null) {
                throw new IllegalStateException("JAXBContextFactory must be non-null");
            }
            return new SOAPDecoder(this);
        }
    }
}

