/*
 * Decompiled with CFR 0.152.
 */
package feign.opentracing;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.opentracing.FeignSpanDecorator;
import feign.opentracing.HttpHeadersInjectAdapter;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TracingClient
implements Client {
    private static final Logger log = Logger.getLogger(TracingClient.class.getName());
    private Tracer tracer;
    private List<FeignSpanDecorator> spanDecorators;
    private Client delegate;

    public TracingClient(Client delegate, Tracer tracer) {
        this(delegate, tracer, Collections.singletonList(new FeignSpanDecorator.StandardTags()));
    }

    public TracingClient(Client delegate, Tracer tracer, List<FeignSpanDecorator> spanDecorators) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<FeignSpanDecorator>(spanDecorators);
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        try (Scope scope = null;){
            scope = this.tracer.buildSpan(request.method()).withTag(Tags.SPAN_KIND.getKey(), "client").startActive(true);
            for (FeignSpanDecorator spanDecorator : this.spanDecorators) {
                try {
                    spanDecorator.onRequest(request, options, scope.span());
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Exception during decorating span", ex);
                }
            }
            request = this.inject(scope.span().context(), request);
            Response response = this.delegate.execute(request, options);
            for (FeignSpanDecorator spanDecorator : this.spanDecorators) {
                try {
                    spanDecorator.onResponse(response, options, scope.span());
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Exception during decorating span", ex);
                }
            }
            Response response2 = response;
            return response2;
        }
    }

    private Request inject(SpanContext spanContext, Request request) {
        HashMap<String, Collection<String>> headersWithTracingContext = new HashMap<String, Collection<String>>(request.headers());
        this.tracer.inject(spanContext, Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersInjectAdapter(headersWithTracingContext));
        return Request.create((String)request.method(), (String)request.url(), headersWithTracingContext, (byte[])request.body(), (Charset)request.charset());
    }
}

