/*
 * Decompiled with CFR 0.152.
 */
package feign.opentracing;

import io.opentracing.propagation.TextMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class HttpHeadersInjectAdapter
implements TextMap {
    private Map<String, Collection<String>> headers;

    public HttpHeadersInjectAdapter(Map<String, Collection<String>> headers) {
        if (headers == null) {
            throw new NullPointerException("Headers should not be null!");
        }
        this.headers = headers;
    }

    public void put(String key, String value) {
        Collection<String> values = this.headers.get(key);
        if (values == null) {
            values = new ArrayList<String>(1);
            this.headers.put(key, values);
        }
        try {
            values.add(value);
        }
        catch (UnsupportedOperationException ex) {
            if (values instanceof List) {
                ArrayList<String> list = new ArrayList<String>(values);
                list.add(value);
                this.headers.put(key, list);
            }
            if (values instanceof Set) {
                HashSet<String> set = new HashSet<String>(values);
                set.add(value);
                this.headers.put(key, set);
            }
            throw ex;
        }
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException("This class should be used only with tracer#inject()");
    }
}

