/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.layout.BlockFormattingContext;
import com.openhtmltopdf.layout.FloatManager;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.PersistentBFC;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FlowingColumnBox;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.PageBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FlowingColumnContainerBox
extends BlockBox {
    private FlowingColumnBox _child;

    private int findPageIndex(LayoutContext c, int y) {
        return c.getRootLayer().getPageIndex(y);
    }

    private void layoutFloats(TreeMap<Integer, ColumnPosition> columns, List<FloatManager.BoxOffset> floats, int columnCount, int colWidth, int colGap) {
        for (FloatManager.BoxOffset bo : floats) {
            BlockBox floater = bo.getBox();
            ColumnBreakStore store = new ColumnBreakStore();
            floater.findColumnBreakOpportunities(store);
            for (ColumnBreakOpportunity breakOp : store.breaks) {
                Map.Entry<Integer, ColumnPosition> entry = columns.floorEntry(breakOp.box.getAbsY());
                ColumnPosition column = entry.getValue();
                int yAdjust = column.pasteY - column.copyY;
                int xAdjust = column.columnIndex % columnCount * colWidth + column.columnIndex % columnCount * colGap;
                this.reposition(breakOp.box, xAdjust, yAdjust);
                if (breakOp.ancestors != null) {
                    this.repositionAncestors(breakOp.ancestors, xAdjust, yAdjust);
                }
                if (!(breakOp.box instanceof LineBox)) continue;
                breakOp.box.calcChildLocations();
            }
        }
    }

    private void layoutFloats(TreeMap<Integer, ColumnPosition> columnMap, PersistentBFC bfc, int columnCount, int colWidth, int colGap) {
        List<FloatManager.BoxOffset> floatsL = this.getPersistentBFC().getFloatManager().getFloats(FloatManager.FloatDirection.LEFT);
        List<FloatManager.BoxOffset> floatsR = this.getPersistentBFC().getFloatManager().getFloats(FloatManager.FloatDirection.RIGHT);
        this.layoutFloats(columnMap, floatsL, columnCount, colWidth, colGap);
        this.layoutFloats(columnMap, floatsR, columnCount, colWidth, colGap);
    }

    private void reposition(Box box, int xAdjust, int yAdjust) {
        if (box instanceof BlockBox && ((BlockBox)box).isFloated()) {
            box.setX(box.getX() + xAdjust);
            box.setY(box.getY() + yAdjust);
        } else {
            box.setAbsY(box.getAbsY() + yAdjust);
            box.setAbsX(box.getAbsX() + xAdjust);
        }
    }

    private void repositionAncestors(List<Box> ancestors, int xAdjust, int yAdjust) {
        for (Box ancestor : ancestors) {
            this.reposition(ancestor, xAdjust, yAdjust);
        }
    }

    private int adjustUnbalanced(LayoutContext c, Box child, int colGap, int colWidth, int columnCount, int xStart) {
        int startY = this.getAbsY();
        List<PageBox> pages = c.getRootLayer().getPages();
        boolean haveFloats = !this.getPersistentBFC().getFloatManager().getFloats(FloatManager.FloatDirection.LEFT).isEmpty() || !this.getPersistentBFC().getFloatManager().getFloats(FloatManager.FloatDirection.RIGHT).isEmpty();
        TreeMap<Integer, ColumnPosition> columnMap = haveFloats ? new TreeMap<Integer, ColumnPosition>() : null;
        int pageIdx = this.findPageIndex(c, startY);
        int colStart = startY;
        int colHeight = pages.get(pageIdx).getBottom() - this.getChild().getAbsY();
        int colIdx = 0;
        int finalHeight = 0;
        if (child.getHeight() <= colHeight) {
            return child.getHeight();
        }
        ColumnBreakStore store = new ColumnBreakStore();
        child.findColumnBreakOpportunities(store);
        if (store.breaks.isEmpty() || store.breaks.size() == 1) {
            return this.getChild().getHeight();
        }
        ColumnPosition current = new ColumnPosition(colIdx, colStart, colStart, colHeight, pageIdx);
        if (haveFloats) {
            columnMap.put(colStart, current);
        }
        Collections.sort(store.breaks, Comparator.comparingInt(brk -> ((ColumnBreakOpportunity)brk).box.getAbsY() + ((ColumnBreakOpportunity)brk).box.getBorderBoxHeight(c)));
        for (int i = 0; i < store.breaks.size(); ++i) {
            int newPageIdx;
            Box next;
            int nextYHeight;
            ColumnBreakOpportunity br = (ColumnBreakOpportunity)store.breaks.get(i);
            ColumnBreakOpportunity nextBr = i < store.breaks.size() - 1 ? (ColumnBreakOpportunity)store.breaks.get(i + 1) : null;
            Box ch = br.box;
            int yAdjust = current.pasteY - current.copyY;
            int yProposedFinal = ch.getAbsY() + yAdjust;
            ch.setAbsY(yProposedFinal);
            finalHeight = Math.max(yProposedFinal + ch.getBorderBoxHeight(c) - startY, finalHeight);
            int xAdjust = colIdx % columnCount * colWidth + colIdx % columnCount * colGap;
            ch.setAbsX(ch.getAbsX() + xAdjust);
            if (br.ancestors != null) {
                this.repositionAncestors(br.ancestors, xAdjust, yAdjust);
            }
            if (ch instanceof LineBox) {
                ch.calcChildLocations();
            }
            if (nextBr == null || (nextYHeight = (next = nextBr.box).getAbsY() + yAdjust + next.getBorderBoxHeight(c) - current.pasteY) <= current.maxColHeight && !ch.getStyle().isColumnBreakAfter() && !next.getStyle().isColumnBreakBefore()) continue;
            int newColIdx = colIdx + 1;
            boolean needNewPage = newColIdx % columnCount == 0;
            int n = newPageIdx = needNewPage ? current.pageIdx + 1 : current.pageIdx;
            if (newPageIdx >= pages.size()) {
                c.getRootLayer().addPage(c);
            }
            PageBox page = pages.get(newPageIdx);
            int pasteY = needNewPage ? page.getTop() : current.pasteY;
            int copyY = next.getAbsY();
            current = new ColumnPosition(newColIdx, copyY, pasteY, page.getBottom() - pasteY, newPageIdx);
            if (haveFloats) {
                columnMap.put(copyY, current);
            }
            ++colIdx;
        }
        if (haveFloats) {
            this.layoutFloats(columnMap, this.getPersistentBFC(), columnCount, colWidth, colGap);
        }
        return finalHeight;
    }

    @Override
    public void layout(LayoutContext c, int contentStart) {
        BlockFormattingContext bfc = new BlockFormattingContext(this, c);
        c.pushBFC(bfc);
        this.addBoxID(c);
        this.calcDimensions(c);
        int colCount = this.getStyle().columnCount();
        int colGapCount = colCount - 1;
        float colGap = this.getStyle().isIdent(CSSName.COLUMN_GAP, IdentValue.NORMAL) ? this.getStyle().getLineHeight(c) : this.getStyle().getFloatPropertyProportionalWidth(CSSName.COLUMN_GAP, this.getContentWidth(), c);
        float totalGap = colGap * (float)colGapCount;
        int colWidth = (int)(((float)this.getContentWidth() - totalGap) / (float)colCount);
        this._child.setContainingLayer(this.getContainingLayer());
        this._child.setContentWidth(colWidth);
        this._child.setColumnWidth(colWidth);
        this._child.setAbsX(this.getAbsX());
        this._child.setAbsY(this.getAbsY());
        c.setIsPrintOverride(false);
        this._child.layout(c, contentStart);
        c.setIsPrintOverride(null);
        int height = this.adjustUnbalanced(c, this._child, (int)colGap, colWidth, colCount, this.getLeftMBP() + this.getX());
        this._child.setHeight(0);
        this.setHeight(height);
        c.popBFC();
    }

    public void setOnlyChild(LayoutContext c, FlowingColumnBox child) {
        this._child = child;
        this.addChild(child);
    }

    public FlowingColumnBox getChild() {
        return this._child;
    }

    public static class ColumnBreakStore {
        private final List<ColumnBreakOpportunity> breaks = new ArrayList<ColumnBreakOpportunity>();
        private final Set<Box> processedContainers = new HashSet<Box>();

        public void addBreak(Box box, List<Box> ancestors) {
            this.breaks.add(ColumnBreakOpportunity.of(box, ancestors));
        }

        public boolean checkContainerShouldProcess(Box container) {
            if (container instanceof FlowingColumnContainerBox || container instanceof FlowingColumnBox) {
                return false;
            }
            return this.processedContainers.add(container);
        }

        public String toString() {
            return this.breaks.toString();
        }
    }

    public static class ColumnBreakOpportunity {
        private final Box box;
        private final List<Box> ancestors;

        private ColumnBreakOpportunity(Box box, List<Box> ancestors) {
            this.box = box;
            this.ancestors = ancestors;
        }

        static ColumnBreakOpportunity of(Box box, List<Box> ancestors) {
            return new ColumnBreakOpportunity(box, ancestors);
        }

        public String toString() {
            return String.valueOf(this.box);
        }
    }

    private static class ColumnPosition {
        private final int columnIndex;
        private final int copyY;
        private final int pasteY;
        private final int maxColHeight;
        private final int pageIdx;

        private ColumnPosition(int columnIndex, int copyY, int pasteY, int maxColHeight, int pageIdx) {
            this.columnIndex = columnIndex;
            this.copyY = copyY;
            this.pasteY = pasteY;
            this.maxColHeight = maxColHeight;
            this.pageIdx = pageIdx;
        }

        public String toString() {
            return String.format("[index='%d', copyY='%d', pasteY='%d', maxColHeight='%d', pageIdx='%d']", this.columnIndex, this.copyY, this.pasteY, this.maxColHeight, this.pageIdx);
        }
    }
}

