/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.reportportal;

import courgette.integration.reportportal.ReportPortalService;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.event.EventHolder;
import courgette.runtime.event.EventSender;

public class ReportPortalSender
implements EventSender {
    private final ReportPortalService reportPortalService;

    public ReportPortalSender(ReportPortalService reportPortalService) {
        this.reportPortalService = reportPortalService;
    }

    @Override
    public synchronized void send(EventHolder eventHolder) {
        CourgetteRunnerInfo runnerInfo = eventHolder.getCourgetteRunnerInfo();
        switch (eventHolder.getCourgetteEvent()) {
            case TEST_RUN_STARTED: {
                this.reportPortalService.startLaunch();
                this.reportPortalService.startTestSuite();
                break;
            }
            case TEST_PASSED: 
            case TEST_FAILED: 
            case TEST_PASSED_AFTER_RERUN: {
                this.reportPortalService.addTest(runnerInfo);
                break;
            }
            case TEST_RUN_FINISHED: {
                this.reportPortalService.finishTestSuite();
                this.reportPortalService.finishLaunch();
            }
        }
    }
}

