/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.slack;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import courgette.integration.slack.SlackService;
import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteRunResult;
import courgette.runtime.CourgetteSlackOptions;
import courgette.runtime.event.CourgetteEvent;
import courgette.runtime.event.EventHolder;
import courgette.runtime.event.EventSender;
import io.cucumber.core.gherkin.Feature;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SlackMessageSender
implements EventSender {
    private final SlackService slackService;
    private final CourgetteSlackOptions slackOptions;
    private final Mustache messageTemplate;

    public SlackMessageSender(SlackService slackService, CourgetteSlackOptions slackOptions) {
        this.slackService = slackService;
        this.slackOptions = slackOptions;
        this.messageTemplate = this.readTemplate("/slack/message.mustache");
    }

    @Override
    public void send(EventHolder eventHolder) {
        this.slackOptions.getChannels().forEach(channel -> this.createMessage((String)channel, eventHolder).ifPresent(this.slackService::postMessage));
    }

    private Optional<String> createMessage(String channel, EventHolder eventHolder) {
        try {
            if (this.isInfoEvent(eventHolder)) {
                return Optional.of(this.createFromTemplate(this.messageTemplate, this.createInfoMessageData(channel, eventHolder)));
            }
            return Optional.of(this.createFromTemplate(this.messageTemplate, this.createMessageData(channel, eventHolder)));
        }
        catch (Exception e) {
            CourgetteException.printError("Courgette Slack Message: There was an error creating the slack message -> " + e.getMessage());
            return Optional.empty();
        }
    }

    private boolean isInfoEvent(EventHolder eventHolder) {
        return eventHolder.getCourgetteEvent().equals((Object)CourgetteEvent.TEST_RUN_STARTED) || eventHolder.getCourgetteEvent().equals((Object)CourgetteEvent.TEST_RUN_FINISHED);
    }

    private Map<String, Object> createInfoMessageData(String channel, EventHolder eventHolder) {
        return this.createDefaultData(channel, eventHolder);
    }

    private Map<String, Object> createMessageData(String channel, EventHolder eventHolder) {
        HashMap<String, Object> section = new HashMap<String, Object>();
        this.addOptional(section, eventHolder);
        HashMap<String, Object> data = this.createDefaultData(channel, eventHolder);
        data.put("section", section);
        return data;
    }

    private HashMap<String, Object> createDefaultData(String channel, EventHolder eventHolder) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("channel", channel);
        data.put("description", eventHolder.getCourgetteEvent().getDescription());
        data.put("timestamp", Instant.now().toString());
        data.put("session_id", eventHolder.getCourgetteProperties().getSessionId());
        this.addIcon(data, eventHolder.getCourgetteEvent());
        return data;
    }

    private void addOptional(Map<String, Object> data, EventHolder eventHolder) {
        CourgetteRunResult courgetteRunResult = eventHolder.getCourgetteRunResult();
        data.put("feature", this.trimFeatureName(courgetteRunResult.getFeature()));
        if (courgetteRunResult.getLineId() != null) {
            HashMap<String, Object> optional1 = new HashMap<String, Object>();
            optional1.put("scenario", this.getScenarioName(courgetteRunResult, courgetteRunResult.getLineId()));
            optional1.put("line", courgetteRunResult.getLineId());
            data.put("optional1", optional1);
        }
        if (eventHolder.getCourgetteProperties().getCourgetteOptions().rerunFailedScenarios() && !eventHolder.getCourgetteEvent().equals((Object)CourgetteEvent.TEST_RERUN)) {
            HashMap<String, Boolean> optional2 = new HashMap<String, Boolean>();
            optional2.put("rerun", this.isRerun(courgetteRunResult));
            data.put("optional2", optional2);
        }
    }

    private void addIcon(Map<String, Object> data, CourgetteEvent event) {
        switch (event) {
            case TEST_RUN_STARTED: 
            case TEST_RUN_FINISHED: {
                data.put("icon", "information_source");
                break;
            }
            case TEST_PASSED: 
            case TEST_PASSED_AFTER_RERUN: {
                data.put("icon", "white_check_mark");
                break;
            }
            case TEST_FAILED: {
                data.put("icon", "x");
                break;
            }
            case TEST_RERUN: {
                data.put("icon", "warning");
            }
        }
    }

    private String trimFeatureName(Feature feature) {
        return new File(feature.getUri()).getName().split("\\.")[0].trim();
    }

    private String getScenarioName(CourgetteRunResult courgetteRunResult, Integer lineNumber) {
        return courgetteRunResult.getFeature().getPickles().stream().filter(t -> t.getLocation().getLine() == lineNumber.intValue()).findFirst().get().getName();
    }

    private boolean isRerun(CourgetteRunResult courgetteRunResult) {
        return courgetteRunResult.getStatus().equals((Object)CourgetteRunResult.Status.PASSED_AFTER_RERUN) || courgetteRunResult.getStatus().equals((Object)CourgetteRunResult.Status.FAILED_AFTER_RERUN);
    }

    private String createFromTemplate(Mustache template, Object data) {
        StringWriter writer = new StringWriter();
        template.execute((Writer)writer, data);
        return ((Object)writer).toString();
    }

    private Mustache readTemplate(String template) {
        StringBuilder templateContent = new StringBuilder();
        try {
            String line;
            InputStream in = this.getClass().getResourceAsStream(template);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                templateContent.append(line);
            }
        }
        catch (Exception e) {
            CourgetteException.printExceptionStackTrace(e);
        }
        return new DefaultMustacheFactory().compile((Reader)new StringReader(templateContent.toString()), "");
    }
}

