/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteException;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.messages.Messages;
import io.cucumber.messages.NdjsonToMessageIterable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CourgetteNdJsonCreator {
    private final Map<Feature, List<List<Messages.Envelope>>> messages;
    private final Predicate<Messages.Envelope> gherkinEnvelope = envelope -> Messages.Envelope.MessageCase.GHERKIN_DOCUMENT.equals((Object)envelope.getMessageCase());
    private final Predicate<Messages.Envelope> metaEnvelope = envelope -> Messages.Envelope.MessageCase.META.equals((Object)envelope.getMessageCase());
    private final Predicate<Messages.Envelope> testRunStartedOrFinishedEnvelope = envelope -> Messages.Envelope.MessageCase.TEST_RUN_STARTED.equals((Object)envelope.getMessageCase()) || Messages.Envelope.MessageCase.TEST_RUN_FINISHED.equals((Object)envelope.getMessageCase());

    public CourgetteNdJsonCreator(Map<Feature, List<List<Messages.Envelope>>> messages) {
        this.messages = messages;
    }

    public static List<Messages.Envelope> createMessages(String source) {
        List<String> messageList = Arrays.asList(source.split("\n"));
        ArrayList<Messages.Envelope> messages = new ArrayList<Messages.Envelope>(messageList.size());
        messageList.forEach(m -> {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(m.getBytes(StandardCharsets.UTF_8));
                for (Messages.Envelope message : new NdjsonToMessageIterable((InputStream)in)) {
                    messages.add(message);
                }
            }
            catch (Exception e) {
                CourgetteException.printExceptionStackTrace(e);
            }
        });
        return messages;
    }

    public List<Messages.Envelope> createFeatureMessages() {
        return this.getMessages();
    }

    public List<Messages.Envelope> createScenarioMessages() {
        return this.getScenarioMessages();
    }

    private List<Messages.Envelope> getMessages() {
        List<Messages.Envelope> featureMessages = this.messages.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toList());
        return this.mutateMessages(featureMessages);
    }

    private List<Messages.Envelope> getScenarioMessages() {
        ArrayList<Messages.Envelope> scenarioMessages = new ArrayList<Messages.Envelope>();
        this.messages.forEach((k, v) -> {
            ArrayList<Messages.GherkinDocument.Feature.Scenario.Builder> scenarios = new ArrayList<Messages.GherkinDocument.Feature.Scenario.Builder>();
            ArrayList<Messages.Envelope> messages = new ArrayList<Messages.Envelope>();
            v.forEach(message -> this.addMessage((List<Messages.Envelope>)message, (List<Messages.GherkinDocument.Feature.Scenario.Builder>)scenarios, (List<Messages.Envelope>)messages));
            Messages.Envelope oldGherkinDocument = this.extractFirstGherkinDocument(messages);
            Messages.Envelope newGherkinDocument = this.createNewGherkinDocument(oldGherkinDocument, scenarios);
            messages.removeIf(this.gherkinEnvelope);
            messages.add(3, newGherkinDocument);
            scenarioMessages.addAll(messages);
        });
        return this.mutateMessages(scenarioMessages);
    }

    private List<Messages.Envelope> mutateMessages(List<Messages.Envelope> envelopes) {
        if (envelopes != null && !envelopes.isEmpty()) {
            Messages.Envelope testRunStarted = this.createTestRunStarted(envelopes);
            Messages.Envelope testRunFinished = this.createTestRunFinished(envelopes);
            envelopes.subList(1, envelopes.size()).removeIf(this.metaEnvelope);
            envelopes.removeIf(this.testRunStartedOrFinishedEnvelope);
            envelopes.add(2, testRunStarted);
            envelopes.add(testRunFinished);
            return envelopes;
        }
        return null;
    }

    private void addMessage(List<Messages.Envelope> envelopes, List<Messages.GherkinDocument.Feature.Scenario.Builder> scenarios, List<Messages.Envelope> messages) {
        ArrayList envelopeList = new ArrayList();
        Optional<Messages.TestCase> testCase = this.extractTestCase(envelopes);
        Optional<Messages.Pickle> pickle = this.extractPickle(envelopes, testCase);
        envelopes.forEach(envelope -> {
            if (pickle.isPresent()) {
                if (Messages.Envelope.MessageCase.GHERKIN_DOCUMENT.equals((Object)envelope.getMessageCase())) {
                    Optional<Messages.GherkinDocument.Feature.Scenario.Builder> scenario = envelope.toBuilder().getGherkinDocument().getFeatureOrBuilder().getChildrenOrBuilderList().stream().map(scenarioBuilder -> scenarioBuilder.getScenario().toBuilder()).filter(scenarioBuilder -> scenarioBuilder.getId().equals(((Messages.Pickle)pickle.get()).getAstNodeIds(0))).findFirst();
                    scenario.ifPresent(scenarios::add);
                    envelopeList.add(envelope);
                } else if (Messages.Envelope.MessageCase.PICKLE.equals((Object)envelope.getMessageCase())) {
                    if (envelope.getPickle() == pickle.get()) {
                        envelopeList.add(envelope);
                    }
                } else {
                    envelopeList.add(envelope);
                }
            }
        });
        messages.addAll(envelopeList);
    }

    private Messages.Envelope extractFirstGherkinDocument(List<Messages.Envelope> envelopes) {
        return envelopes.stream().filter(envelope -> Messages.Envelope.MessageCase.GHERKIN_DOCUMENT.equals((Object)envelope.getMessageCase())).filter(envelope -> !envelope.getGherkinDocument().getUri().equals("")).findFirst().get();
    }

    private Messages.Envelope createNewGherkinDocument(Messages.Envelope gherkinDocument, List<Messages.GherkinDocument.Feature.Scenario.Builder> scenarios) {
        ArrayList children = new ArrayList();
        scenarios.forEach(scenario -> {
            Messages.GherkinDocument.Feature.FeatureChild.Builder fcb = Messages.GherkinDocument.Feature.FeatureChild.newBuilder();
            fcb.setScenario(scenario);
            children.add(fcb.build());
        });
        Messages.GherkinDocument.Feature feature = gherkinDocument.getGherkinDocument().getFeature().toBuilder().clearChildren().addAllChildren(children).build();
        return gherkinDocument.toBuilder().setGherkinDocument(gherkinDocument.getGherkinDocument().toBuilder().setFeature(feature)).build();
    }

    private Optional<Messages.TestCase> extractTestCase(List<Messages.Envelope> envelopes) {
        return envelopes.stream().map(Messages.Envelope::getTestCase).filter(testCase -> !testCase.getPickleId().equals("")).findFirst();
    }

    private Optional<Messages.Pickle> extractPickle(List<Messages.Envelope> envelopes, Optional<Messages.TestCase> testCase) {
        if (!envelopes.isEmpty() && testCase.isPresent()) {
            return envelopes.stream().map(Messages.Envelope::getPickle).filter(pickle -> pickle.getId().equals(((Messages.TestCase)testCase.get()).getPickleId())).findFirst();
        }
        return Optional.empty();
    }

    private Messages.Envelope createTestRunStarted(List<Messages.Envelope> envelopes) {
        long seconds = envelopes.stream().filter(envelope -> Messages.Envelope.MessageCase.TEST_RUN_STARTED.equals((Object)envelope.getMessageCase())).map(Messages.Envelope::getTestRunStarted).map(Messages.TestRunStarted::getTimestamp).min(Comparator.comparingLong(Messages.Timestamp::getSeconds)).get().getSeconds();
        Messages.Timestamp timestamp = Messages.Timestamp.newBuilder().setSeconds(seconds).build();
        return Messages.Envelope.newBuilder().setTestRunStarted(Messages.TestRunStarted.newBuilder().setTimestamp(timestamp)).build();
    }

    private Messages.Envelope createTestRunFinished(List<Messages.Envelope> envelopes) {
        long seconds = envelopes.stream().filter(envelope -> Messages.Envelope.MessageCase.TEST_RUN_FINISHED.equals((Object)envelope.getMessageCase())).map(Messages.Envelope::getTestRunFinished).map(Messages.TestRunFinished::getTimestamp).max(Comparator.comparingLong(Messages.Timestamp::getSeconds)).get().getSeconds();
        Messages.Timestamp timestamp = Messages.Timestamp.newBuilder().setSeconds(seconds).build();
        return Messages.Envelope.newBuilder().setTestRunFinished(Messages.TestRunFinished.newBuilder().setTimestamp(timestamp).build()).build();
    }
}

